/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.jetty.http.HttpCookie;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpStatus;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.MimeTypes;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.BufferCache;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.SessionManager;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ErrorHandler;
import org.eclipse.jetty.util.ByteArrayISO8859Writer;
import org.eclipse.jetty.util.QuotedStringTokenizer;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.log.Log;

public class Response
implements HttpServletResponse {
    public static final int NONE = 0;
    public static final int STREAM = 1;
    public static final int WRITER = 2;
    public static final String SET_INCLUDE_HEADER_PREFIX = "org.eclipse.jetty.server.include.";
    private final HttpConnection _connection;
    private int _status = 200;
    private String _reason;
    private Locale _locale;
    private String _mimeType;
    private BufferCache.CachedBuffer _cachedMimeType;
    private String _characterEncoding;
    private boolean _explicitEncoding;
    private String _contentType;
    private int _outputState;
    private PrintWriter _writer;

    public Response(HttpConnection connection) {
        this._connection = connection;
    }

    protected void recycle() {
        this._status = 200;
        this._reason = null;
        this._locale = null;
        this._mimeType = null;
        this._cachedMimeType = null;
        this._characterEncoding = null;
        this._explicitEncoding = false;
        this._contentType = null;
        this._outputState = 0;
        this._writer = null;
    }

    public void addCookie(HttpCookie cookie) {
        this._connection.getResponseFields().addSetCookie(cookie);
    }

    public void addCookie(Cookie cookie) {
        this._connection.getResponseFields().addSetCookie(cookie.getName(), cookie.getValue(), cookie.getDomain(), cookie.getPath(), (long)cookie.getMaxAge(), cookie.getComment(), cookie.getSecure(), false, cookie.getVersion());
    }

    public boolean containsHeader(String name) {
        return this._connection.getResponseFields().containsKey(name);
    }

    public String encodeURL(String url) {
        int prefix;
        String sessionURLPrefix;
        Request request = this._connection.getRequest();
        SessionManager sessionManager = request.getSessionManager();
        if (sessionManager == null) {
            return url;
        }
        HttpURI uri = null;
        if (sessionManager.isCheckingRemoteSessionIdEncoding() && URIUtil.hasScheme((String)url)) {
            uri = new HttpURI(url);
            String path = uri.getPath();
            path = path == null ? "" : path;
            int port = uri.getPort();
            if (port < 0) {
                int n = port = "https".equalsIgnoreCase(uri.getScheme()) ? 443 : 80;
            }
            if (!request.getServerName().equalsIgnoreCase(uri.getHost()) || request.getServerPort() != port || !path.startsWith(request.getContextPath())) {
                return url;
            }
        }
        if ((sessionURLPrefix = sessionManager.getSessionIdPathParameterNamePrefix()) == null) {
            return url;
        }
        if (url == null) {
            return null;
        }
        if (request.isRequestedSessionIdFromCookie()) {
            int prefix2 = url.indexOf(sessionURLPrefix);
            if (prefix2 != -1) {
                int suffix = url.indexOf("?", prefix2);
                if (suffix < 0) {
                    suffix = url.indexOf("#", prefix2);
                }
                if (suffix <= prefix2) {
                    return url.substring(0, prefix2);
                }
                return url.substring(0, prefix2) + url.substring(suffix);
            }
            return url;
        }
        HttpSession session = request.getSession(false);
        if (session == null) {
            return url;
        }
        if (!sessionManager.isValid(session)) {
            return url;
        }
        String id = sessionManager.getNodeId(session);
        if (uri == null) {
            uri = new HttpURI(url);
        }
        if ((prefix = url.indexOf(sessionURLPrefix)) != -1) {
            int suffix = url.indexOf("?", prefix);
            if (suffix < 0) {
                suffix = url.indexOf("#", prefix);
            }
            if (suffix <= prefix) {
                return url.substring(0, prefix + sessionURLPrefix.length()) + id;
            }
            return url.substring(0, prefix + sessionURLPrefix.length()) + id + url.substring(suffix);
        }
        int suffix = url.indexOf(63);
        if (suffix < 0) {
            suffix = url.indexOf(35);
        }
        if (suffix < 0) {
            return url + (("https".equalsIgnoreCase(uri.getScheme()) || "http".equalsIgnoreCase(uri.getScheme())) && uri.getPath() == null ? "/" : "") + sessionURLPrefix + id;
        }
        return url.substring(0, suffix) + (("https".equalsIgnoreCase(uri.getScheme()) || "http".equalsIgnoreCase(uri.getScheme())) && uri.getPath() == null ? "/" : "") + sessionURLPrefix + id + url.substring(suffix);
    }

    public String encodeRedirectURL(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeUrl(String url) {
        return this.encodeURL(url);
    }

    @Deprecated
    public String encodeRedirectUrl(String url) {
        return this.encodeRedirectURL(url);
    }

    public void sendError(int code, String message) throws IOException {
        if (this._connection.isIncluding()) {
            return;
        }
        if (this.isCommitted()) {
            Log.warn((String)("Committed before " + code + " " + message));
        }
        this.resetBuffer();
        this._characterEncoding = null;
        this.setHeader("Expires", null);
        this.setHeader("Last-Modified", null);
        this.setHeader("Cache-Control", null);
        this.setHeader("Content-Type", null);
        this.setHeader("Content-Length", null);
        this._outputState = 0;
        this.setStatus(code, message);
        if (message == null) {
            message = HttpStatus.getMessage((int)code);
        }
        if (code != 204 && code != 304 && code != 206 && code >= 200) {
            Request request = this._connection.getRequest();
            ErrorHandler error_handler = null;
            ContextHandler.Context context = request.getContext();
            if (context != null) {
                error_handler = context.getContextHandler().getErrorHandler();
            }
            if (error_handler == null) {
                error_handler = (ErrorHandler)this._connection.getConnector().getServer().getBean(ErrorHandler.class);
            }
            if (error_handler != null) {
                request.setAttribute("javax.servlet.error.status_code", new Integer(code));
                request.setAttribute("javax.servlet.error.message", message);
                request.setAttribute("javax.servlet.error.request_uri", request.getRequestURI());
                request.setAttribute("javax.servlet.error.servlet_name", request.getServletName());
                error_handler.handle(null, this._connection.getRequest(), this._connection.getRequest(), this);
            } else {
                String uri;
                this.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
                this.setContentType("text/html;charset=ISO-8859-1");
                ByteArrayISO8859Writer writer = new ByteArrayISO8859Writer(2048);
                if (message != null) {
                    message = StringUtil.replace((String)message, (String)"&", (String)"&amp;");
                    message = StringUtil.replace((String)message, (String)"<", (String)"&lt;");
                    message = StringUtil.replace((String)message, (String)">", (String)"&gt;");
                }
                if ((uri = request.getRequestURI()) != null) {
                    uri = StringUtil.replace((String)uri, (String)"&", (String)"&amp;");
                    uri = StringUtil.replace((String)uri, (String)"<", (String)"&lt;");
                    uri = StringUtil.replace((String)uri, (String)">", (String)"&gt;");
                }
                writer.write("<html>\n<head>\n<meta http-equiv=\"Content-Type\" content=\"text/html;charset=ISO-8859-1\"/>\n");
                writer.write("<title>Error ");
                writer.write(Integer.toString(code));
                writer.write(' ');
                if (message == null) {
                    message = HttpStatus.getMessage((int)code);
                }
                writer.write(message);
                writer.write("</title>\n</head>\n<body>\n<h2>HTTP ERROR: ");
                writer.write(Integer.toString(code));
                writer.write("</h2>\n<p>Problem accessing ");
                writer.write(uri);
                writer.write(". Reason:\n<pre>    ");
                writer.write(message);
                writer.write("</pre>");
                writer.write("</p>\n<hr /><i><small>Powered by Jetty://</small></i>");
                for (int i = 0; i < 20; ++i) {
                    writer.write("\n                                                ");
                }
                writer.write("\n</body>\n</html>\n");
                writer.flush();
                this.setContentLength(writer.size());
                writer.writeTo((OutputStream)this.getOutputStream());
                writer.destroy();
            }
        } else if (code != 206) {
            this._connection.getRequestFields().remove(HttpHeaders.CONTENT_TYPE_BUFFER);
            this._connection.getRequestFields().remove(HttpHeaders.CONTENT_LENGTH_BUFFER);
            this._characterEncoding = null;
            this._mimeType = null;
            this._cachedMimeType = null;
        }
        this.complete();
    }

    public void sendError(int sc) throws IOException {
        if (sc == 102) {
            this.sendProcessing();
        } else {
            this.sendError(sc, null);
        }
    }

    public void sendProcessing() throws IOException {
        if (this._connection.isExpecting102Processing() && !this.isCommitted()) {
            ((HttpGenerator)this._connection.getGenerator()).send1xx(102);
        }
    }

    public void sendRedirect(String location) throws IOException {
        if (this._connection.isIncluding()) {
            return;
        }
        if (location == null) {
            throw new IllegalArgumentException();
        }
        if (!URIUtil.hasScheme((String)location)) {
            StringBuilder buf = this._connection.getRequest().getRootURL();
            if (location.startsWith("/")) {
                buf.append(location);
            } else {
                String path = this._connection.getRequest().getRequestURI();
                String parent = path.endsWith("/") ? path : URIUtil.parentPath((String)path);
                location = URIUtil.addPaths((String)parent, (String)location);
                if (location == null) {
                    throw new IllegalStateException("path cannot be above root");
                }
                if (!location.startsWith("/")) {
                    buf.append('/');
                }
                buf.append(location);
            }
            location = buf.toString();
            HttpURI uri = new HttpURI(location);
            String path = uri.getDecodedPath();
            String canonical = URIUtil.canonicalPath((String)path);
            if (canonical == null) {
                throw new IllegalArgumentException();
            }
            if (!canonical.equals(path)) {
                buf = this._connection.getRequest().getRootURL();
                buf.append(canonical);
                if (uri.getQuery() != null) {
                    buf.append('?');
                    buf.append(uri.getQuery());
                }
                if (uri.getFragment() != null) {
                    buf.append('#');
                    buf.append(uri.getFragment());
                }
                location = buf.toString();
            }
        }
        location = this.encodeRedirectURL(location);
        this.resetBuffer();
        this.setHeader("Location", location);
        this.setStatus(302);
        this.complete();
    }

    public void setDateHeader(String name, long date) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().putDateField(name, date);
        }
    }

    public void addDateHeader(String name, long date) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().addDateField(name, date);
        }
    }

    public void setHeader(String name, String value) {
        if ("Content-Type".equalsIgnoreCase(name)) {
            this.setContentType(value);
        } else {
            if (this._connection.isIncluding()) {
                if (name.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                    name = name.substring(SET_INCLUDE_HEADER_PREFIX.length());
                } else {
                    return;
                }
            }
            this._connection.getResponseFields().put(name, value);
            if ("Content-Length".equalsIgnoreCase(name)) {
                if (value == null) {
                    this._connection._generator.setContentLength(-1L);
                } else {
                    this._connection._generator.setContentLength(Long.parseLong(value));
                }
            }
        }
    }

    public String getHeader(String name) {
        return this._connection.getResponseFields().getStringField(name);
    }

    public Enumeration getHeaders(String name) {
        Enumeration e = this._connection.getResponseFields().getValues(name);
        if (e == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return e;
    }

    public void addHeader(String name, String value) {
        if (this._connection.isIncluding()) {
            if (name.startsWith(SET_INCLUDE_HEADER_PREFIX)) {
                name = name.substring(SET_INCLUDE_HEADER_PREFIX.length());
            } else {
                return;
            }
        }
        this._connection.getResponseFields().add(name, value);
        if ("Content-Length".equalsIgnoreCase(name)) {
            this._connection._generator.setContentLength(Long.parseLong(value));
        }
    }

    public void setIntHeader(String name, int value) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().putLongField(name, (long)value);
            if ("Content-Length".equalsIgnoreCase(name)) {
                this._connection._generator.setContentLength((long)value);
            }
        }
    }

    public void addIntHeader(String name, int value) {
        if (!this._connection.isIncluding()) {
            this._connection.getResponseFields().addLongField(name, (long)value);
            if ("Content-Length".equalsIgnoreCase(name)) {
                this._connection._generator.setContentLength((long)value);
            }
        }
    }

    public void setStatus(int sc) {
        this.setStatus(sc, null);
    }

    public void setStatus(int sc, String sm) {
        if (sc <= 0) {
            throw new IllegalArgumentException();
        }
        if (!this._connection.isIncluding()) {
            this._status = sc;
            this._reason = sm;
        }
    }

    public String getCharacterEncoding() {
        if (this._characterEncoding == null) {
            this._characterEncoding = "ISO-8859-1";
        }
        return this._characterEncoding;
    }

    String getSetCharacterEncoding() {
        return this._characterEncoding;
    }

    public String getContentType() {
        return this._contentType;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (this._outputState != 0 && this._outputState != 1) {
            throw new IllegalStateException("WRITER");
        }
        this._outputState = 1;
        return this._connection.getOutputStream();
    }

    public boolean isWriting() {
        return this._outputState == 2;
    }

    public boolean isOutputing() {
        return this._outputState != 0;
    }

    public PrintWriter getWriter() throws IOException {
        if (this._outputState != 0 && this._outputState != 2) {
            throw new IllegalStateException("STREAM");
        }
        if (this._writer == null) {
            String encoding = this._characterEncoding;
            if (encoding == null) {
                if (this._mimeType != null) {
                    encoding = null;
                }
                if (encoding == null) {
                    encoding = "ISO-8859-1";
                }
                this.setCharacterEncoding(encoding);
            }
            this._writer = this._connection.getPrintWriter(encoding);
        }
        this._outputState = 2;
        return this._writer;
    }

    public void setCharacterEncoding(String encoding) {
        if (this._connection.isIncluding()) {
            return;
        }
        if (this._outputState == 0 && !this.isCommitted()) {
            this._explicitEncoding = true;
            if (encoding == null) {
                if (this._characterEncoding != null) {
                    this._characterEncoding = null;
                    if (this._cachedMimeType != null) {
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, (Buffer)this._cachedMimeType);
                    } else {
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._mimeType);
                    }
                }
            } else {
                this._characterEncoding = encoding;
                if (this._contentType != null) {
                    int i0 = this._contentType.indexOf(59);
                    if (i0 < 0) {
                        BufferCache.CachedBuffer content_type;
                        this._contentType = null;
                        if (this._cachedMimeType != null && (content_type = this._cachedMimeType.getAssociate((Object)this._characterEncoding)) != null) {
                            this._contentType = content_type.toString();
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, (Buffer)content_type);
                        }
                        if (this._contentType == null) {
                            this._contentType = this._mimeType + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)this._characterEncoding, (String)";= ");
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        }
                    } else {
                        int i8;
                        int i2;
                        int i1 = this._contentType.indexOf("charset=", i0);
                        this._contentType = i1 < 0 ? this._contentType + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)this._characterEncoding, (String)";= ") : ((i2 = this._contentType.indexOf(" ", i8 = i1 + 8)) < 0 ? this._contentType.substring(0, i8) + QuotedStringTokenizer.quoteIfNeeded((String)this._characterEncoding, (String)";= ") : this._contentType.substring(0, i8) + QuotedStringTokenizer.quoteIfNeeded((String)this._characterEncoding, (String)";= ") + this._contentType.substring(i2));
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                    }
                }
            }
        }
    }

    public void setContentLength(int len) {
        if (this.isCommitted() || this._connection.isIncluding()) {
            return;
        }
        this._connection._generator.setContentLength((long)len);
        if (len >= 0) {
            this._connection.getResponseFields().putLongField("Content-Length", (long)len);
            if (this._connection._generator.isAllContentWritten()) {
                if (this._outputState == 2) {
                    this._writer.close();
                } else if (this._outputState == 1) {
                    try {
                        this.getOutputStream().close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    public void setLongContentLength(long len) {
        if (this.isCommitted() || this._connection.isIncluding()) {
            return;
        }
        this._connection._generator.setContentLength(len);
        this._connection.getResponseFields().putLongField("Content-Length", len);
    }

    public void setContentType(String contentType) {
        if (this.isCommitted() || this._connection.isIncluding()) {
            return;
        }
        if (contentType == null) {
            if (this._locale == null) {
                this._characterEncoding = null;
            }
            this._mimeType = null;
            this._cachedMimeType = null;
            this._contentType = null;
            this._connection.getResponseFields().remove(HttpHeaders.CONTENT_TYPE_BUFFER);
        } else {
            int i0 = contentType.indexOf(59);
            if (i0 > 0) {
                this._mimeType = contentType.substring(0, i0).trim();
                this._cachedMimeType = MimeTypes.CACHE.get(this._mimeType);
                int i1 = contentType.indexOf("charset=", i0 + 1);
                if (i1 >= 0) {
                    this._explicitEncoding = true;
                    int i8 = i1 + 8;
                    int i2 = contentType.indexOf(32, i8);
                    if (this._outputState == 2) {
                        if (i1 == i0 + 1 && i2 < 0 || i1 == i0 + 2 && i2 < 0 && contentType.charAt(i0 + 1) == ' ') {
                            if (this._cachedMimeType != null) {
                                BufferCache.CachedBuffer content_type = this._cachedMimeType.getAssociate((Object)this._characterEncoding);
                                if (content_type != null) {
                                    this._contentType = content_type.toString();
                                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, (Buffer)content_type);
                                } else {
                                    this._contentType = this._mimeType + ";charset=" + this._characterEncoding;
                                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                                }
                            } else {
                                this._contentType = this._mimeType + ";charset=" + this._characterEncoding;
                                this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                            }
                        } else if (i2 < 0) {
                            this._contentType = contentType.substring(0, i1) + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)this._characterEncoding, (String)";= ");
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        } else {
                            this._contentType = contentType.substring(0, i1) + contentType.substring(i2) + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)this._characterEncoding, (String)";= ");
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        }
                    } else if (i1 == i0 + 1 && i2 < 0 || i1 == i0 + 2 && i2 < 0 && contentType.charAt(i0 + 1) == ' ') {
                        this._cachedMimeType = MimeTypes.CACHE.get(this._mimeType);
                        this._characterEncoding = QuotedStringTokenizer.unquote((String)contentType.substring(i8));
                        if (this._cachedMimeType != null) {
                            BufferCache.CachedBuffer content_type = this._cachedMimeType.getAssociate((Object)this._characterEncoding);
                            if (content_type != null) {
                                this._contentType = content_type.toString();
                                this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, (Buffer)content_type);
                            } else {
                                this._contentType = contentType;
                                this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                            }
                        } else {
                            this._contentType = contentType;
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        }
                    } else if (i2 > 0) {
                        this._characterEncoding = QuotedStringTokenizer.unquote((String)contentType.substring(i8, i2));
                        this._contentType = contentType;
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                    } else {
                        this._characterEncoding = QuotedStringTokenizer.unquote((String)contentType.substring(i8));
                        this._contentType = contentType;
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                    }
                } else {
                    this._cachedMimeType = null;
                    this._contentType = this._characterEncoding == null ? contentType : contentType + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)this._characterEncoding, (String)";= ");
                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                }
            } else {
                this._mimeType = contentType;
                this._cachedMimeType = MimeTypes.CACHE.get(this._mimeType);
                if (this._characterEncoding != null) {
                    if (this._cachedMimeType != null) {
                        BufferCache.CachedBuffer content_type = this._cachedMimeType.getAssociate((Object)this._characterEncoding);
                        if (content_type != null) {
                            this._contentType = content_type.toString();
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, (Buffer)content_type);
                        } else {
                            this._contentType = this._mimeType + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)this._characterEncoding, (String)";= ");
                            this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                        }
                    } else {
                        this._contentType = contentType + ";charset=" + QuotedStringTokenizer.quoteIfNeeded((String)this._characterEncoding, (String)";= ");
                        this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                    }
                } else if (this._cachedMimeType != null) {
                    this._contentType = this._cachedMimeType.toString();
                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, (Buffer)this._cachedMimeType);
                } else {
                    this._contentType = contentType;
                    this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
                }
            }
        }
    }

    public void setBufferSize(int size) {
        if (this.isCommitted() || this.getContentCount() > 0L) {
            throw new IllegalStateException("Committed or content written");
        }
        this._connection.getGenerator().increaseContentBufferSize(size);
    }

    public int getBufferSize() {
        return this._connection.getGenerator().getContentBufferSize();
    }

    public void flushBuffer() throws IOException {
        this._connection.flushResponse();
    }

    public void reset() {
        this.resetBuffer();
        this.fwdReset();
        this._status = 200;
        this._reason = null;
        HttpFields response_fields = this._connection.getResponseFields();
        response_fields.clear();
        String connection = this._connection.getRequestFields().getStringField(HttpHeaders.CONNECTION_BUFFER);
        if (connection != null) {
            String[] values = connection.split(",");
            block5: for (int i = 0; values != null && i < values.length; ++i) {
                BufferCache.CachedBuffer cb = HttpHeaderValues.CACHE.get(values[0].trim());
                if (cb == null) continue;
                switch (cb.getOrdinal()) {
                    case 1: {
                        response_fields.put(HttpHeaders.CONNECTION_BUFFER, HttpHeaderValues.CLOSE_BUFFER);
                        continue block5;
                    }
                    case 5: {
                        if (!"HTTP/1.0".equalsIgnoreCase(this._connection.getRequest().getProtocol())) continue block5;
                        response_fields.put(HttpHeaders.CONNECTION_BUFFER, "keep-alive");
                        continue block5;
                    }
                    case 8: {
                        response_fields.put(HttpHeaders.CONNECTION_BUFFER, "TE");
                    }
                }
            }
        }
    }

    public void fwdReset() {
        this.resetBuffer();
        this._outputState = 0;
        this._writer = null;
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Committed");
        }
        this._connection.getGenerator().resetBuffer();
    }

    public boolean isCommitted() {
        return this._connection.isResponseCommitted();
    }

    public void setLocale(Locale locale) {
        if (locale == null || this.isCommitted() || this._connection.isIncluding()) {
            return;
        }
        this._locale = locale;
        this._connection.getResponseFields().put(HttpHeaders.CONTENT_LANGUAGE_BUFFER, locale.toString().replace('_', '-'));
        if (this._explicitEncoding || this._outputState != 0) {
            return;
        }
        if (this._connection.getRequest().getContext() == null) {
            return;
        }
        String charset = this._connection.getRequest().getContext().getContextHandler().getLocaleEncoding(locale);
        if (charset != null && charset.length() > 0) {
            this._characterEncoding = charset;
            String type = this.getContentType();
            if (type != null) {
                this._characterEncoding = charset;
                int semi = type.indexOf(59);
                if (semi < 0) {
                    this._mimeType = type;
                    this._contentType = type = type + ";charset=" + charset;
                } else {
                    this._mimeType = type.substring(0, semi);
                    this._contentType = this._mimeType = this._mimeType + ";charset=" + charset;
                }
                this._cachedMimeType = MimeTypes.CACHE.get(this._mimeType);
                this._connection.getResponseFields().put(HttpHeaders.CONTENT_TYPE_BUFFER, this._contentType);
            }
        }
    }

    public Locale getLocale() {
        if (this._locale == null) {
            return Locale.getDefault();
        }
        return this._locale;
    }

    public int getStatus() {
        return this._status;
    }

    public String getReason() {
        return this._reason;
    }

    public void complete() throws IOException {
        this._connection.completeResponse();
    }

    public long getContentCount() {
        if (this._connection == null || this._connection.getGenerator() == null) {
            return -1L;
        }
        return this._connection.getGenerator().getContentWritten();
    }

    public HttpFields getHttpFields() {
        return this._connection.getResponseFields();
    }

    public String toString() {
        return "HTTP/1.1 " + this._status + " " + (this._reason == null ? "" : this._reason) + System.getProperty("line.separator") + this._connection.getResponseFields().toString();
    }

    private static class NullOutput
    extends ServletOutputStream {
        private NullOutput() {
        }

        public void write(int b) throws IOException {
        }

        public void print(String s) throws IOException {
        }

        public void println(String s) throws IOException {
        }

        public void write(byte[] b, int off, int len) throws IOException {
        }
    }
}

