/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.devutils.debugbar;

import org.apache.wicket.Component;
import org.apache.wicket.Page;
import org.apache.wicket.Session;
import org.apache.wicket.devutils.debugbar.DebugBar;
import org.apache.wicket.devutils.debugbar.IDebugBarContributor;
import org.apache.wicket.devutils.debugbar.StandardDebugPanel;
import org.apache.wicket.devutils.inspector.LiveSessionsPage;
import org.apache.wicket.devutils.inspector.SessionSizeModel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.util.lang.Bytes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionSizeDebugPanel
extends StandardDebugPanel {
    private static final long serialVersionUID = 1L;
    public static final IDebugBarContributor DEBUG_BAR_CONTRIB = new IDebugBarContributor(){
        private static final long serialVersionUID = 1L;

        public Component createComponent(String id, DebugBar debugBar) {
            return new SessionSizeDebugPanel(id);
        }
    };

    public SessionSizeDebugPanel(String id) {
        super(id);
    }

    @Override
    protected Class<? extends Page> getLinkPageClass() {
        return LiveSessionsPage.class;
    }

    @Override
    protected ResourceReference getImageResourceReference() {
        return new PackageResourceReference(SessionSizeDebugPanel.class, "harddrive.png");
    }

    @Override
    protected IModel<String> getDataModel() {
        return new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;
            private final IModel<Bytes> size = new SessionSizeModel(Session.get());

            public String getObject() {
                Bytes sessionSizeInBytes = (Bytes)this.size.getObject();
                String sessionSizeAsString = sessionSizeInBytes != null ? sessionSizeInBytes.toString() : "unknown";
                return "Session: " + sessionSizeAsString;
            }

            public void detach() {
                super.detach();
                this.size.detach();
            }
        };
    }
}

