/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.util;

import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import org.apache.commons.lang.StringUtils;
import org.hibernate.cfg.EJB3NamingStrategy;

public class MidPointNamingStrategy
extends EJB3NamingStrategy {
    private static final Trace LOGGER = TraceManager.getTrace(MidPointNamingStrategy.class);

    public String classToTableName(String className) {
        String name = className.substring(1);
        name = name.replaceAll(String.format("%s|%s|%s", "(?<=[A-Z])(?=[A-Z][a-z])", "(?<=[^A-Z])(?=[A-Z])", "(?<=[A-Za-z])(?=[^A-Za-z])"), "_");
        String result = "m_" + name.toLowerCase();
        LOGGER.trace("classToTableName {} to {}", new Object[]{className, result});
        return result;
    }

    public String logicalColumnName(String columnName, String propertyName) {
        String result = StringUtils.isNotEmpty((String)columnName) ? columnName : (propertyName.startsWith("credentials.") || propertyName.startsWith("activation.") ? super.propertyToColumnName(propertyName) : propertyName.replaceAll("\\.", "_"));
        LOGGER.trace("logicalColumnName {} {} to {}", new Object[]{columnName, propertyName, result});
        return result;
    }

    public String propertyToColumnName(String propertyName) {
        String result = propertyName.replaceAll("\\.", "_");
        if (propertyName.contains("&&")) {
            result = super.propertyToColumnName(propertyName);
        } else if (propertyName.startsWith("credentials.") || propertyName.startsWith("activation.")) {
            result = super.propertyToColumnName(propertyName);
        }
        LOGGER.trace("propertyToColumnName {} to {} (original: {})", new Object[]{propertyName, result, super.propertyToColumnName(propertyName)});
        return result;
    }

    public String joinKeyColumnName(String joinedColumn, String joinedTable) {
        String result = super.joinKeyColumnName(joinedColumn, joinedTable);
        LOGGER.trace("joinKeyColumnName {} {} to {}", new Object[]{joinedColumn, joinedTable, result});
        return result;
    }

    public String columnName(String columnName) {
        String result = super.columnName(columnName);
        LOGGER.trace("columnName {} to {}", new Object[]{columnName, result});
        return result;
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        String result = super.foreignKeyColumnName(propertyName, propertyEntityName, propertyTableName, referencedColumnName);
        LOGGER.trace("foreignKeyColumnName {} {} {} {} to {}", new Object[]{propertyName, propertyEntityName, propertyTableName, referencedColumnName, result});
        return result;
    }
}

