/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.data.common;

import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.repo.sql.data.common.RActivation;
import com.evolveum.midpoint.repo.sql.data.common.RAnyContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainerType;
import com.evolveum.midpoint.repo.sql.data.common.REmbeddedReference;
import com.evolveum.midpoint.repo.sql.data.common.RObject;
import com.evolveum.midpoint.repo.sql.data.common.ROwnable;
import com.evolveum.midpoint.repo.sql.data.common.RUtil;
import com.evolveum.midpoint.repo.sql.query.QueryEntity;
import com.evolveum.midpoint.repo.sql.util.ContainerIdGenerator;
import com.evolveum.midpoint.repo.sql.util.DtoTranslationException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountConstructionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ExtensionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.MapsId;
import javax.persistence.OneToOne;
import javax.persistence.Transient;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;
import org.hibernate.annotations.ForeignKey;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.Table;
import org.hibernate.annotations.Type;

@Entity
@Table(appliesTo="m_assignment", indexes={@Index(name="iAssignmentEnabled", columnNames={"enabled"})})
@ForeignKey(name="fk_assignment")
public class RAssignment
extends RContainer
implements ROwnable {
    private static final Trace LOGGER = TraceManager.getTrace(RAssignment.class);
    private RObject owner;
    private String ownerOid;
    private Long ownerId;
    @QueryEntity(any=true)
    private RAnyContainer extension;
    @QueryEntity(embedded=true)
    private RActivation activation;
    private String accountConstruction;
    private REmbeddedReference targetRef;

    @ForeignKey(name="fk_assignment_owner")
    @MapsId(value="owner")
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumns(value={@JoinColumn(name="owner_oid", referencedColumnName="oid"), @JoinColumn(name="owner_id", referencedColumnName="id")})
    public RObject getOwner() {
        return this.owner;
    }

    @Embedded
    public REmbeddedReference getTargetRef() {
        return this.targetRef;
    }

    @Column(name="owner_id", nullable=false)
    public Long getOwnerId() {
        if (this.ownerId == null && this.owner != null) {
            this.ownerId = this.owner.getId();
        }
        return this.ownerId;
    }

    @Column(name="owner_oid", length=36, nullable=false)
    public String getOwnerOid() {
        if (this.ownerOid == null && this.owner != null) {
            this.ownerOid = this.owner.getOid();
        }
        return this.ownerOid;
    }

    @OneToOne(optional=true, orphanRemoval=true)
    @ForeignKey(name="none")
    @Cascade(value={CascadeType.ALL})
    @JoinColumns(value={@JoinColumn(name="extOid", referencedColumnName="owner_oid"), @JoinColumn(name="extId", referencedColumnName="owner_id"), @JoinColumn(name="extType", referencedColumnName="ownerType")})
    public RAnyContainer getExtension() {
        return this.extension;
    }

    @Embedded
    public RActivation getActivation() {
        return this.activation;
    }

    @Type(type="org.hibernate.type.TextType")
    public String getAccountConstruction() {
        return this.accountConstruction;
    }

    public void setActivation(RActivation activation) {
        this.activation = activation;
    }

    public void setExtension(RAnyContainer extension) {
        this.extension = extension;
        if (this.extension != null) {
            this.extension.setOwnerType(RContainerType.ASSIGNMENT);
        }
    }

    public void setAccountConstruction(String accountConstruction) {
        this.accountConstruction = accountConstruction;
    }

    public void setOwnerId(Long ownerId) {
        this.ownerId = ownerId;
    }

    public void setOwnerOid(String ownerOid) {
        this.ownerOid = ownerOid;
    }

    public void setTargetRef(REmbeddedReference targetRef) {
        this.targetRef = targetRef;
    }

    public void setOwner(RObject owner) {
        this.owner = owner;
    }

    @Override
    @Transient
    public RContainer getContainerOwner() {
        return this.getOwner();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RAssignment that = (RAssignment)o;
        if (this.accountConstruction != null ? !this.accountConstruction.equals(that.accountConstruction) : that.accountConstruction != null) {
            return false;
        }
        if (this.activation != null ? !this.activation.equals(that.activation) : that.activation != null) {
            return false;
        }
        if (this.extension != null ? !this.extension.equals(that.extension) : that.extension != null) {
            return false;
        }
        return !(this.targetRef != null ? !this.targetRef.equals(that.targetRef) : that.targetRef != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.activation != null ? this.activation.hashCode() : 0);
        result = 31 * result + (this.accountConstruction != null ? this.accountConstruction.hashCode() : 0);
        return result;
    }

    public static void copyToJAXB(RAssignment repo, AssignmentType jaxb, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        jaxb.setId(RUtil.getStringFromLong(repo.getId()));
        if (repo.getExtension() != null) {
            ExtensionType extension = new ExtensionType();
            jaxb.setExtension(extension);
            RAnyContainer.copyToJAXB(repo.getExtension(), extension, prismContext);
        }
        if (repo.getActivation() != null) {
            jaxb.setActivation(repo.getActivation().toJAXB(prismContext));
        }
        try {
            jaxb.setAccountConstruction(RUtil.toJAXB(repo.getAccountConstruction(), AccountConstructionType.class, prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
        if (repo.getTargetRef() != null) {
            jaxb.setTargetRef(repo.getTargetRef().toJAXB(prismContext));
        }
    }

    public static void copyFromJAXB(AssignmentType jaxb, RAssignment repo, ObjectType parent, PrismContext prismContext) throws DtoTranslationException {
        Validate.notNull((Object)repo, (String)"Repo object must not be null.");
        Validate.notNull((Object)jaxb, (String)"JAXB object must not be null.");
        repo.setOid(parent.getOid());
        repo.setId(RUtil.getLongWrappedFromString(jaxb.getId()));
        if (jaxb.getExtension() != null) {
            RAnyContainer extension = new RAnyContainer();
            extension.setOwner(repo);
            repo.setExtension(extension);
            RAnyContainer.copyFromJAXB(jaxb.getExtension(), extension, prismContext);
            new ContainerIdGenerator().generate(null, extension);
        }
        if (jaxb.getActivation() != null) {
            RActivation activation = new RActivation();
            RActivation.copyFromJAXB(jaxb.getActivation(), activation, prismContext);
            repo.setActivation(activation);
        }
        try {
            repo.setAccountConstruction(RUtil.toRepo(jaxb.getAccountConstruction(), prismContext));
        }
        catch (Exception ex) {
            throw new DtoTranslationException(ex.getMessage(), ex);
        }
        if (jaxb.getTarget() != null) {
            LOGGER.warn("Target from assignment type won't be saved. It should be translated to target reference.");
        }
        repo.setTargetRef(RUtil.jaxbRefToEmbeddedRepoRef(jaxb.getTargetRef(), prismContext));
    }

    public AssignmentType toJAXB(PrismContext prismContext) throws DtoTranslationException {
        AssignmentType object = new AssignmentType();
        RAssignment.copyToJAXB(this, object, prismContext);
        return object;
    }
}

