/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;
import org.basex.util.list.ElementList;

public class IntList
extends ElementList {
    protected int[] list;

    public IntList() {
        this(8);
    }

    public IntList(int c) {
        this.list = new int[c];
    }

    public IntList(double f) {
        this();
        this.factor = f;
    }

    public IntList(int[] a) {
        this.list = a;
        this.size = a.length;
    }

    public final void add(int e) {
        if (this.size == this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize());
        }
        this.list[this.size++] = e;
    }

    public final int get(int i) {
        return this.list[i];
    }

    public final void set(int i, int e) {
        if (i >= this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize(i + 1));
        }
        this.list[i] = e;
        this.size = Math.max(this.size, i + 1);
    }

    public final boolean contains(int e) {
        int i = 0;
        while (i < this.size) {
            if (this.list[i] == e) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public final void insert(int i, int[] e) {
        int l = e.length;
        if (l == 0) {
            return;
        }
        if (this.size + l > this.list.length) {
            this.list = Arrays.copyOf(this.list, this.newSize(this.size + l));
        }
        Array.move(this.list, i, l, this.size - i);
        System.arraycopy(e, 0, this.list, i, l);
        this.size += l;
    }

    public final void delete(int i) {
        Array.move(this.list, i + 1, -1, --this.size - i);
    }

    public final void move(int e, int i) {
        int a = i;
        while (a < this.size) {
            int n = a++;
            this.list[n] = this.list[n] + e;
        }
    }

    public final int peek() {
        return this.list[this.size - 1];
    }

    public final int pop() {
        return this.list[--this.size];
    }

    public final void push(int val) {
        this.add(val);
    }

    public final int sortedIndexOf(int e) {
        return Arrays.binarySearch(this.list, 0, this.size, e);
    }

    public final int[] toArray() {
        return Arrays.copyOf(this.list, this.size);
    }

    public IntList sort() {
        Arrays.sort(this.list, 0, this.size);
        return this;
    }

    public final void sort(byte[][] tok, boolean num, boolean asc) {
        this.sort(0, this.size, num, asc, tok);
    }

    public final void sort(double[] num, boolean asc) {
        this.sort(0, this.size, asc, num);
    }

    private void sort(int s, int e, boolean g, boolean f, byte[][] t) {
        int c;
        int a;
        if (e < 7) {
            int i = s;
            while (i < e + s) {
                int j = i;
                while (j > s) {
                    int h;
                    int n = h = g ? this.s(t[j - 1], t[j]) : this.d(t[j - 1], t[j]);
                    if (f ? h < 0 : h > 0) break;
                    this.s(j, j - 1, t);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = s + (e >> 1);
        if (e > 7) {
            int l = s;
            int n = s + e - 1;
            if (e > 40) {
                int k = e >>> 3;
                l = this.m(l, l + k, l + (k << 1));
                m = this.m(m - k, m, m + k);
                n = this.m(n - (k << 1), n - k, n);
            }
            m = this.m(l, m, n);
        }
        byte[] v = t[m];
        int b = a = s;
        int d = c = s + e - 1;
        while (true) {
            int h;
            if (b <= c) {
                int n = h = g ? this.s(t[b], v) : this.d(t[b], v);
                if (!(!f ? h < 0 : h > 0)) {
                    if (h == 0) {
                        this.s(a++, b, t);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                int n = h = g ? this.s(t[c], v) : this.d(t[c], v);
                if (!f ? h > 0 : h < 0) break;
                if (h == 0) {
                    this.s(c, d--, t);
                }
                --c;
            }
            if (b > c) break;
            this.s(b++, c--, t);
        }
        int n = s + e;
        int k = Math.min(a - s, b - a);
        this.s(s, b - k, k, t);
        k = Math.min(d - c, n - d - 1);
        this.s(b, n - k, k, t);
        k = b - a;
        if (k > 1) {
            this.sort(s, k, g, f, t);
        }
        if ((k = d - c) > 1) {
            this.sort(n - k, k, g, f, t);
        }
    }

    private void sort(int s, int e, boolean f, double[] t) {
        int c;
        int a;
        if (e < 7) {
            int i = s;
            while (i < e + s) {
                int j = i;
                while (j > s) {
                    double h = t[j - 1] - t[j];
                    if (f ? h < 0.0 : h > 0.0) break;
                    this.s(j, j - 1, t);
                    --j;
                }
                ++i;
            }
            return;
        }
        int m = s + (e >> 1);
        if (e > 7) {
            int l = s;
            int n = s + e - 1;
            if (e > 40) {
                int k = e >>> 3;
                l = this.m(l, l + k, l + (k << 1));
                m = this.m(m - k, m, m + k);
                n = this.m(n - (k << 1), n - k, n);
            }
            m = this.m(l, m, n);
        }
        double v = t[m];
        int b = a = s;
        int d = c = s + e - 1;
        while (true) {
            double h;
            if (b <= c) {
                h = t[b] - v;
                if (!(!f ? h < 0.0 : h > 0.0)) {
                    if (h == 0.0) {
                        this.s(a++, b, t);
                    }
                    ++b;
                    continue;
                }
            }
            while (c >= b) {
                h = t[c] - v;
                if (!f ? h > 0.0 : h < 0.0) break;
                if (h == 0.0) {
                    this.s(c, d--, t);
                }
                --c;
            }
            if (b > c) break;
            this.s(b++, c--, t);
        }
        int n = s + e;
        int k = Math.min(a - s, b - a);
        this.s(s, b - k, k, t);
        k = Math.min(d - c, n - d - 1);
        this.s(b, n - k, k, t);
        k = b - a;
        if (k > 1) {
            this.sort(s, k, f, t);
        }
        if ((k = d - c) > 1) {
            this.sort(n - k, k, f, t);
        }
    }

    private int s(byte[] a, byte[] b) {
        double n = Token.toDouble(a) - Token.toDouble(b);
        return n > 0.0 ? 1 : (n < 0.0 ? -1 : 0);
    }

    private int d(byte[] a, byte[] b) {
        return a == null ? (b == null ? 0 : -1) : (b == null ? 1 : Token.diff(a, b));
    }

    private void s(int a, int b, byte[][] t) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        byte[] c = t[a];
        t[a] = t[b];
        t[b] = c;
    }

    private void s(int a, int b, double[] t) {
        int l = this.list[a];
        this.list[a] = this.list[b];
        this.list[b] = l;
        double c = t[a];
        t[a] = t[b];
        t[b] = c;
    }

    private void s(int a, int b, int n, byte[][] t) {
        int i = 0;
        while (i < n) {
            this.s(a + i, b + i, t);
            ++i;
        }
    }

    private void s(int a, int b, int n, double[] t) {
        int i = 0;
        while (i < n) {
            this.s(a + i, b + i, t);
            ++i;
        }
    }

    private int m(int a, int b, int c) {
        return this.list[a] < this.list[b] ? (this.list[b] < this.list[c] ? b : (this.list[a] < this.list[c] ? c : a)) : (this.list[b] > this.list[c] ? b : (this.list[a] > this.list[c] ? c : a));
    }

    public String toString() {
        TokenBuilder tb = new TokenBuilder(String.valueOf(Util.name(this)) + '[');
        int i = 0;
        while (i < this.size) {
            tb.add(String.valueOf(i == 0 ? "" : ", ") + this.list[i]);
            ++i;
        }
        return tb.add(93).toString();
    }
}

