/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.ft;

import java.lang.reflect.Method;
import java.util.EnumMap;
import java.util.EnumSet;
import org.basex.util.Reflect;
import org.basex.util.Token;
import org.basex.util.ft.FTIterator;
import org.basex.util.ft.Language;
import org.basex.util.ft.Stemmer;

final class LuceneStemmer
extends Stemmer {
    private static final String PKG = "org.apache.lucene.analysis";
    private static final EnumMap<Language, StemmerClass> CLASSES = new EnumMap(Language.class);
    private StemmerClass clazz;
    private Object stemmer;

    static {
        if (Reflect.available(PKG)) {
            LuceneStemmer.add(Language.PT, "br.Brazilian");
            LuceneStemmer.add(Language.DE);
            LuceneStemmer.add(Language.FR);
            LuceneStemmer.add(Language.NL);
            LuceneStemmer.add(Language.RU);
        }
    }

    private static void add(Language lang) {
        LuceneStemmer.add(lang, String.valueOf(lang.name().toLowerCase()) + '.' + (Object)((Object)lang));
    }

    private static void add(Language lang, String path) {
        Class<?> clz = Reflect.find("org.apache.lucene.analysis." + path + "Stemmer");
        Method m = Reflect.method(clz, "stem", String.class);
        CLASSES.put(lang, new StemmerClass(clz, m));
    }

    static boolean available() {
        return CLASSES.size() > 0;
    }

    LuceneStemmer() {
    }

    LuceneStemmer(Language lang, FTIterator fti) {
        super(fti);
        this.clazz = CLASSES.get((Object)lang);
        this.stemmer = Reflect.get(this.clazz.clz);
    }

    @Override
    Stemmer get(Language l, FTIterator fti) {
        return new LuceneStemmer(l, fti);
    }

    @Override
    public boolean supports(Language lang) {
        return CLASSES.containsKey((Object)lang);
    }

    @Override
    int prec() {
        return 200;
    }

    @Override
    EnumSet<Language> languages() {
        return EnumSet.copyOf(CLASSES.keySet());
    }

    @Override
    byte[] stem(byte[] word) {
        return Token.token((String)Reflect.invoke(this.clazz.stem, this.stemmer, Token.string(word)));
    }

    private static class StemmerClass {
        final Class<?> clz;
        final Method stem;

        StemmerClass(Class<?> sc, Method stm) {
            this.clz = sc;
            this.stem = stm;
            this.stem.setAccessible(true);
        }
    }
}

