/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.io.out.PrintOutput;
import org.basex.query.QueryException;
import org.basex.server.LocalSession;
import org.basex.server.Query;
import org.basex.server.QueryListener;
import org.basex.util.Token;

public class LocalQuery
extends Query {
    private final QueryListener qp;
    private final ByteArrayOutputStream buf;
    private boolean ready;
    private final LocalSession session;

    LocalQuery(LocalSession s, String q, Context ctx) throws BaseXException {
        this.session = s;
        this.buf = new ByteArrayOutputStream();
        try {
            this.qp = new QueryListener(q, PrintOutput.get(this.buf), ctx);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    LocalQuery(LocalSession s, String q, Context ctx, OutputStream o) throws BaseXException {
        this.session = s;
        this.buf = null;
        try {
            this.qp = new QueryListener(q, PrintOutput.get(o), ctx);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    @Override
    public void bind(String n, String v, String t) throws BaseXException {
        try {
            this.qp.bind(n, v, t);
        }
        catch (QueryException ex) {
            throw new BaseXException(ex);
        }
    }

    @Override
    public String init() throws BaseXException {
        try {
            this.qp.init();
        }
        catch (Exception ex) {
            throw new BaseXException(ex);
        }
        return this.output();
    }

    @Override
    public boolean more() throws BaseXException {
        try {
            this.ready = true;
            return this.qp.next();
        }
        catch (Exception ex) {
            throw new BaseXException(ex);
        }
    }

    @Override
    public String next() throws BaseXException {
        try {
            if (this.ready) {
                this.ready = false;
            } else {
                this.qp.next();
            }
        }
        catch (Exception ex) {
            throw new BaseXException(ex);
        }
        return this.output();
    }

    @Override
    public String execute() throws BaseXException {
        try {
            this.qp.execute();
        }
        catch (Exception ex) {
            throw new BaseXException(ex);
        }
        return this.output();
    }

    @Override
    public String info() throws BaseXException {
        return Token.string(this.qp.info());
    }

    @Override
    public String close() throws BaseXException {
        this.session.removeQuery(this);
        return this.closeListener();
    }

    String closeListener() throws BaseXException {
        try {
            this.qp.close(false);
        }
        catch (IOException ex) {
            throw new BaseXException(ex);
        }
        return this.output();
    }

    private String output() {
        if (this.buf == null) {
            return null;
        }
        String result = Token.string(this.buf.toByteArray());
        this.buf.reset();
        return result;
    }
}

