/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.value;

import java.io.IOException;
import org.basex.core.Text;
import org.basex.data.Data;
import org.basex.index.Index;
import org.basex.index.IndexCache;
import org.basex.index.IndexIterator;
import org.basex.index.IndexStats;
import org.basex.index.IndexToken;
import org.basex.index.RangeToken;
import org.basex.io.random.DataAccess;
import org.basex.util.Num;
import org.basex.util.Performance;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.IntMap;
import org.basex.util.list.IntList;

public final class DiskValues
implements Index {
    private final int size;
    private final DataAccess idxr;
    private final DataAccess idxl;
    private final boolean text;
    private final Data data;
    private final IndexCache cache = new IndexCache();
    private final IntMap<byte[]> ctext = new IntMap();

    public DiskValues(Data d, boolean txt) throws IOException {
        this(d, txt, txt ? "txt" : "atv");
    }

    DiskValues(Data d, boolean txt, String pref) throws IOException {
        this.data = d;
        this.text = txt;
        this.idxl = new DataAccess(d.meta.dbfile(String.valueOf(pref) + 'l'));
        this.idxr = new DataAccess(d.meta.dbfile(String.valueOf(pref) + 'r'));
        this.size = this.idxl.read4();
    }

    @Override
    public byte[] info() {
        TokenBuilder tb = new TokenBuilder();
        tb.add("- Structure: Binary tree" + Text.NL);
        long l = this.idxl.length() + this.idxr.length();
        tb.add("- Size: " + Performance.format(l, true) + Text.NL);
        IndexStats stats = new IndexStats(this.data);
        int m = 0;
        while (m < this.size) {
            int oc = this.idxl.readNum(this.idxr.read5((long)m * 5L));
            if (stats.adding(oc)) {
                stats.add(this.data.text(this.idxl.readNum(), this.text));
            }
            ++m;
        }
        stats.print(tb);
        return tb.finish();
    }

    @Override
    public IndexIterator ids(IndexToken tok) {
        if (tok instanceof RangeToken) {
            return this.idRange((RangeToken)tok);
        }
        int id = this.cache.id(tok.get());
        if (id > 0) {
            return this.iter(this.cache.size(id), this.cache.pointer(id));
        }
        long pos = this.get(tok.get());
        return pos == 0L ? IndexIterator.EMPTY : this.iter(this.idxl.readNum(pos), this.idxl.pos());
    }

    @Override
    public int nrIDs(IndexToken it) {
        if (it instanceof RangeToken) {
            return this.idRange((RangeToken)it).size();
        }
        if (it.get().length > 96) {
            return Integer.MAX_VALUE;
        }
        byte[] tok = it.get();
        int id = this.cache.id(tok);
        if (id > 0) {
            return this.cache.size(id);
        }
        long pos = this.get(tok);
        if (pos == 0L) {
            return 0;
        }
        int nr = this.idxl.readNum(pos);
        this.cache.add(it.get(), nr, pos + (long)Num.length(nr));
        return nr;
    }

    byte[] nextValues() {
        return this.idxr.pos() >= this.idxr.length() ? Token.EMPTY : this.idxl.readBytes(this.idxr.read5(), this.idxl.read4());
    }

    private IndexIterator iter(int s, long ps) {
        IntList ids = new IntList(s);
        long p = ps;
        int l = 0;
        int v = 0;
        while (l < s) {
            p = this.idxl.pos();
            ids.add(v += this.idxl.readNum(p));
            ++l;
        }
        return this.iter(ids);
    }

    private IndexIterator idRange(RangeToken tok) {
        double min = tok.min;
        double max = tok.max;
        int len = max > 0.0 && (double)((long)max) == max ? Token.token(max).length : 0;
        boolean simple = len != 0 && min > 0.0 && (double)((long)min) == min && Token.token(min).length == len;
        IntList ids = new IntList();
        int l = 0;
        while (l < this.size) {
            int ds = this.idxl.readNum(this.idxr.read5((long)l * 5L));
            int pre = this.idxl.readNum();
            double v = this.data.textDbl(pre, this.text);
            if (v >= min && v <= max) {
                int d = 0;
                while (d < ds) {
                    ids.add(pre);
                    pre += this.idxl.readNum();
                    ++d;
                }
            } else if (simple && v > max && this.data.textLen(pre, this.text) == len) break;
            ++l;
        }
        return this.iter(ids.sort());
    }

    private IndexIterator iter(final IntList ids) {
        return new IndexIterator(){
            int p = -1;

            @Override
            public boolean more() {
                return ++this.p < ids.size();
            }

            @Override
            public int next() {
                return ids.get(this.p);
            }

            @Override
            public double score() {
                return -1.0;
            }
        };
    }

    private long get(byte[] key) {
        int l = 0;
        int h = this.size - 1;
        while (l <= h) {
            int d;
            int m = l + h >>> 1;
            long pos = this.idxr.read5((long)m * 5L);
            this.idxl.readNum(pos);
            int pre = this.idxl.readNum();
            byte[] txt = this.ctext.get(m);
            if (txt == null) {
                txt = this.data.text(pre, this.text);
                this.ctext.add(m, txt);
            }
            if ((d = Token.diff(txt, key)) == 0) {
                return pos;
            }
            if (d < 0) {
                l = m + 1;
                continue;
            }
            h = m - 1;
        }
        return 0L;
    }

    @Override
    public synchronized void close() throws IOException {
        this.idxl.close();
        this.idxr.close();
    }
}

