/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.tree;

import org.basex.core.Context;
import org.basex.data.Data;
import org.basex.gui.view.tree.TreeBorder;
import org.basex.gui.view.tree.TreeNodeCache;

final class TreeSubtree {
    private final TreeNodeCache nc;
    private TreeBorder[][] border;

    TreeSubtree(Data d, boolean atts) {
        this.nc = new TreeNodeCache(d, atts);
    }

    void generateBorders(Context c) {
        Data d = c.current.data;
        int[] roots = c.current.list;
        int rl = roots.length;
        if (rl == 0) {
            return;
        }
        this.border = new TreeBorder[rl][];
        int i = 0;
        while (i < rl) {
            this.border[i] = this.nc.subtree(d, roots[i]);
            ++i;
        }
    }

    int getPrePerIndex(int rn, int lv, int ix) {
        return this.getPrePerIndex(this.getTreeBorder(rn, lv), ix);
    }

    private int getPrePerIndex(TreeBorder bo, int ix) {
        int start = bo.start + ix;
        if (start < 0) {
            return -1;
        }
        return this.nc.getPrePerLevelAndIndex(bo.level, start);
    }

    int getPreIndex(int rn, int lv, int pre) {
        return this.getPreIndex(this.getTreeBorder(rn, lv), pre);
    }

    private int getPreIndex(TreeBorder bo, int pre) {
        return this.nc.searchPreIndex(bo.level, pre, pre, bo.start, bo.getEnd()) - bo.start;
    }

    int levelSize(int rn, int lv) {
        return this.getTreeBorder((int)rn, (int)lv).size;
    }

    TreeBorder getTreeBorder(int rn, int lv) {
        return this.border[rn][lv];
    }

    int getSubtreeHeight(int rn) {
        return this.border.length > rn ? this.border[rn].length : -1;
    }

    int getMaxSubtreeHeight() {
        int h = 0;
        TreeBorder[][] treeBorderArray = this.border;
        int n = this.border.length;
        int n2 = 0;
        while (n2 < n) {
            TreeBorder[] b = treeBorderArray[n2];
            int hh = b.length;
            if (hh > h) {
                h = hh;
            }
            ++n2;
        }
        return h;
    }

    int searchPreArrayPos(int rn, int lv, int pre) {
        return this.searchPreArrayPos(this.getTreeBorder(rn, lv), pre);
    }

    private int searchPreArrayPos(TreeBorder bo, int pre) {
        return this.nc.searchPreArrayPos(bo.level, bo.start, bo.getEnd(), pre) - bo.start;
    }

    TreeBorder[] subtree(Data d, int pre) {
        return this.nc.subtree(d, pre);
    }
}

