/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.util.aspect;

import com.evolveum.midpoint.util.aspect.ObjectFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.annotation.Order;

@Aspect
@Order(value=-2147483648)
public class MidpointAspect {
    public static final String INDENT_STRING = " ";
    private static AtomicInteger idcounter = new AtomicInteger(0);
    private static AtomicInteger subidcounter = new AtomicInteger(0);
    private static final Logger LOGGER_PROFILING = LoggerFactory.getLogger((String)"PROFILING");
    private static final String MDC_SUBSYSTEM_KEY = "subsystem";
    public static final String SUBSYSTEM_REPOSITORY = "REPOSITORY";
    public static final String SUBSYSTEM_TASKMANAGER = "TASKMANAGER";
    public static final String SUBSYSTEM_PROVISIONING = "PROVISIONING";
    public static final String SUBSYSTEM_RESOURCEOBJECTCHANGELISTENER = "RESOURCEOBJECTCHANGELISTENER";
    public static final String SUBSYSTEM_MODEL = "MODEL";
    public static final String SUBSYSTEM_WEB = "WEB";
    public static final String SUBSYSTEM_UCF = "UCF";
    public static final String[] SUBSYSTEMS = new String[]{"REPOSITORY", "TASKMANAGER", "PROVISIONING", "RESOURCEOBJECTCHANGELISTENER", "MODEL", "WEB", "UCF"};
    private static List<ObjectFormatter> formatters = new ArrayList<ObjectFormatter>();
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ MidpointAspect ajc$perSingletonInstance;

    static {
        try {
            MidpointAspect.ajc$perSingletonInstance = new MidpointAspect();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }

    public static void registerFormatter(ObjectFormatter formatter) {
        formatters.add(formatter);
    }

    @Around(value="entriesIntoRepository()")
    public Object processRepositoryNdc(ProceedingJoinPoint pjp) throws Throwable {
        return this.wrapSubsystem(pjp, SUBSYSTEM_REPOSITORY);
    }

    @Around(value="entriesIntoTaskManager()")
    public Object processTaskManagerNdc(ProceedingJoinPoint pjp) throws Throwable {
        return this.wrapSubsystem(pjp, SUBSYSTEM_TASKMANAGER);
    }

    @Around(value="entriesIntoProvisioning()")
    public Object processProvisioningNdc(ProceedingJoinPoint pjp) throws Throwable {
        return this.wrapSubsystem(pjp, SUBSYSTEM_PROVISIONING);
    }

    @Around(value="entriesIntoResourceObjectChangeListener()")
    public Object processResourceObjectChangeListenerNdc(ProceedingJoinPoint pjp) throws Throwable {
        return this.wrapSubsystem(pjp, SUBSYSTEM_RESOURCEOBJECTCHANGELISTENER);
    }

    @Around(value="entriesIntoModel()")
    public Object processModelNdc(ProceedingJoinPoint pjp) throws Throwable {
        return this.wrapSubsystem(pjp, SUBSYSTEM_MODEL);
    }

    @Around(value="entriesIntoWeb()")
    public Object processWebNdc(ProceedingJoinPoint pjp) throws Throwable {
        return this.wrapSubsystem(pjp, SUBSYSTEM_WEB);
    }

    @Around(value="entriesIntoUcf()")
    public Object processUcfNdc(ProceedingJoinPoint pjp) throws Throwable {
        return this.wrapSubsystem(pjp, SUBSYSTEM_UCF);
    }

    public static String swapSubsystemMark(String subsystemName) {
        String prev = MDC.get((String)MDC_SUBSYSTEM_KEY);
        if (subsystemName == null) {
            MDC.remove((String)MDC_SUBSYSTEM_KEY);
        } else {
            MDC.put((String)MDC_SUBSYSTEM_KEY, (String)subsystemName);
        }
        return prev;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object wrapSubsystem(ProceedingJoinPoint pjp, String subsystem) throws Throwable {
        block21: {
            block22: {
                retValue = null;
                prev = null;
                id = 0;
                d = 1;
                exc = false;
                excName = null;
                startTime = System.nanoTime();
                infoLog = new StringBuilder("#### Entry: ");
                try {
                    prev = MidpointAspect.swapSubsystemMark(subsystem);
                    if (MidpointAspect.LOGGER_PROFILING.isDebugEnabled()) {
                        id = MidpointAspect.idcounter.incrementAndGet();
                        infoLog.append(id);
                    }
                    if (MidpointAspect.LOGGER_PROFILING.isTraceEnabled()) {
                        depth = MDC.get((String)"depth");
                        d = depth == null || depth.isEmpty() != false ? 0 : Integer.parseInt(depth);
                        MDC.put((String)"depth", (String)Integer.toString(++d));
                        i = 0;
                        while (i < d) {
                            infoLog.append(" ");
                            ++i;
                        }
                    }
                    if (MidpointAspect.LOGGER_PROFILING.isDebugEnabled()) {
                        infoLog.append(this.getClassName(pjp));
                        MidpointAspect.LOGGER_PROFILING.debug("{}->{}", (Object)infoLog, (Object)pjp.getSignature().getName());
                        if (MidpointAspect.LOGGER_PROFILING.isTraceEnabled()) {
                            args = pjp.getArgs();
                            sb = new StringBuffer();
                            sb.append("###### args: ");
                            sb.append("(");
                            i = 0;
                            while (i < args.length) {
                                sb.append(this.formatVal(args[i]));
                                if (args.length != i + 1) {
                                    sb.append(", ");
                                }
                                ++i;
                            }
                            sb.append(")");
                            MidpointAspect.LOGGER_PROFILING.trace(sb.toString());
                        }
                    }
                    try {
                        retValue = pjp.proceed();
                    }
                    catch (Exception e) {
                        excName = e.getClass().getName();
                        exc = true;
                        throw e;
                    }
                    var16_16 = retValue;
                    return var16_16;
                }
                finally {
                    if (MidpointAspect.LOGGER_PROFILING.isTraceEnabled()) {
                        MDC.put((String)"depth", (String)Integer.toString(--d));
                    }
                    if (!MidpointAspect.LOGGER_PROFILING.isDebugEnabled()) break block21;
                    sb = new StringBuilder();
                    sb.append("##### Exit: ");
                    if (MidpointAspect.LOGGER_PROFILING.isDebugEnabled()) {
                        sb.append(id);
                        sb.append(" ");
                    }
                    if (!MidpointAspect.LOGGER_PROFILING.isTraceEnabled()) break block22;
                    i = 0;
                    ** while (i < d + 1)
                }
lbl-1000:
                // 1 sources

                {
                    sb.append(" ");
                    ++i;
                    continue;
                }
            }
            sb.append(this.getClassName(pjp));
            sb.append("->");
            sb.append(pjp.getSignature().getName());
            if (MidpointAspect.LOGGER_PROFILING.isDebugEnabled()) {
                sb.append(" etime: ");
                elapsed = System.nanoTime() - startTime;
                sb.append(elapsed / 1000000L);
                sb.append('.');
                mikros = elapsed / 1000L % 1000L;
                if (mikros < 100L) {
                    sb.append('0');
                }
                if (mikros < 10L) {
                    sb.append('0');
                }
                sb.append(mikros);
                sb.append(" ms");
            }
            MidpointAspect.LOGGER_PROFILING.debug(sb.toString());
            if (MidpointAspect.LOGGER_PROFILING.isTraceEnabled()) {
                if (exc) {
                    MidpointAspect.LOGGER_PROFILING.trace("###### return exception: {}", (Object)excName);
                } else {
                    MidpointAspect.LOGGER_PROFILING.trace("###### retval: {}", (Object)this.formatVal(retValue));
                }
            }
        }
        MidpointAspect.swapSubsystemMark(prev);
        return var16_16;
    }

    @Pointcut(value="execution(* com.evolveum.midpoint.repo.api.RepositoryService.*(..))")
    public /* synthetic */ void entriesIntoRepository() {
    }

    @Pointcut(value="execution(* com.evolveum.midpoint.task.api.TaskManager.*(..))")
    public /* synthetic */ void entriesIntoTaskManager() {
    }

    @Pointcut(value="execution(* com.evolveum.midpoint.provisioning.api.ProvisioningService.*(..))")
    public /* synthetic */ void entriesIntoProvisioning() {
    }

    @Pointcut(value="execution(* com.evolveum.midpoint.provisioning.api.ResourceObjectChangeListener.*(..))")
    public /* synthetic */ void entriesIntoResourceObjectChangeListener() {
    }

    @Pointcut(value="execution(* com.evolveum.midpoint.model.api.ModelService.*(..))")
    public /* synthetic */ void entriesIntoModel() {
    }

    @Pointcut(value="execution(* com.evolveum.midpoint.web.page..*.*(..)) && !execution(protected * com.evolveum.midpoint.web.page..*.createStringResource(..)) && !execution(public * com.evolveum.midpoint.web.page..*.get*(..)) && !execution(public * com.evolveum.midpoint.web.page..*.set*(..))&& !execution(public * com.evolveum.midpoint.web.page..*.is*(..))")
    public /* synthetic */ void entriesIntoWeb() {
    }

    @Pointcut(value="execution(* com.evolveum.midpoint.provisioning.ucf.api.ConnectorInstance.*(..)) || execution(* com.evolveum.midpoint.provisioning.ucf.api.ConnectorFactory.*(..))")
    public /* synthetic */ void entriesIntoUcf() {
    }

    private String getClassName(ProceedingJoinPoint pjp) {
        String className = null;
        if (pjp.getThis() != null) {
            className = pjp.getThis().getClass().getName();
            className = className.replaceFirst("com.evolveum.midpoint", "..");
        }
        return className;
    }

    private String formatVal(Object value) {
        if (value == null) {
            return "null";
        }
        String out = null;
        for (ObjectFormatter formatter : formatters) {
            out = formatter.format(value);
            if (out != null) break;
        }
        if (out == null) {
            return value.toString();
        }
        return out;
    }

    public static MidpointAspect aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.evolveum.midpoint.util.aspect.MidpointAspect", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }
}

