/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.pvm.runtime;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.pvm.delegate.SubProcessActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;
import org.activiti.engine.impl.pvm.runtime.AbstractEventAtomicOperation;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;

public class AtomicOperationProcessEnd
extends AbstractEventAtomicOperation {
    private static Logger log = Logger.getLogger(AtomicOperationProcessEnd.class.getName());

    protected ScopeImpl getScope(InterpretableExecution execution) {
        return execution.getProcessDefinition();
    }

    protected String getEventName() {
        return "end";
    }

    protected void eventNotificationsCompleted(InterpretableExecution execution) {
        InterpretableExecution superExecution = execution.getSuperExecution();
        SubProcessActivityBehavior subProcessActivityBehavior = null;
        if (superExecution != null) {
            ActivityImpl activity = (ActivityImpl)superExecution.getActivity();
            subProcessActivityBehavior = (SubProcessActivityBehavior)activity.getActivityBehavior();
            try {
                subProcessActivityBehavior.completing(superExecution, execution);
            }
            catch (ActivitiException e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw e;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw new ActivitiException("Error while completing sub process of execution " + execution, e);
            }
        }
        execution.destroy();
        execution.remove();
        if (superExecution != null) {
            superExecution.setSubProcessInstance(null);
            try {
                subProcessActivityBehavior.completed(superExecution);
            }
            catch (ActivitiException e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw e;
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while completing sub process of execution " + execution, e);
                throw new ActivitiException("Error while completing sub process of execution " + execution, e);
            }
        }
    }
}

