/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.javax.el.ELContext;
import org.activiti.engine.impl.persistence.entity.HistoricVariableUpdateEntity;
import org.activiti.engine.impl.persistence.entity.VariableInstanceEntity;
import org.activiti.engine.impl.variable.VariableType;
import org.activiti.engine.impl.variable.VariableTypes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class VariableScopeImpl
implements Serializable,
VariableScope {
    private static final long serialVersionUID = 1L;
    protected Map<String, VariableInstanceEntity> variableInstances = null;
    protected ELContext cachedElContext;

    protected abstract List<VariableInstanceEntity> loadVariableInstances();

    protected abstract VariableScopeImpl getParentVariableScope();

    protected abstract void initializeVariableInstanceBackPointer(VariableInstanceEntity var1);

    protected void ensureVariableInstancesInitialized() {
        if (this.variableInstances == null) {
            this.variableInstances = new HashMap<String, VariableInstanceEntity>();
            CommandContext commandContext = Context.getCommandContext();
            if (commandContext == null) {
                throw new ActivitiException("lazy loading outside command context");
            }
            List<VariableInstanceEntity> variableInstancesList = this.loadVariableInstances();
            for (VariableInstanceEntity variableInstance : variableInstancesList) {
                this.variableInstances.put(variableInstance.getName(), variableInstance);
            }
        }
    }

    @Override
    public Map<String, Object> getVariables() {
        return this.collectVariables(new HashMap<String, Object>());
    }

    @Override
    public Map<String, Object> getVariablesLocal() {
        HashMap<String, Object> variables = new HashMap<String, Object>();
        this.ensureVariableInstancesInitialized();
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        return variables;
    }

    protected Map<String, Object> collectVariables(HashMap<String, Object> variables) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variables.putAll(parentScope.collectVariables(variables));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variables.put(variableInstance.getName(), variableInstance.getValue());
        }
        return variables;
    }

    @Override
    public Object getVariable(String variableName) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
        if (variableInstance != null) {
            return variableInstance.getValue();
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.getVariable(variableName);
        }
        return null;
    }

    @Override
    public Object getVariableLocal(Object variableName) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
        if (variableInstance != null) {
            return variableInstance.getValue();
        }
        return null;
    }

    @Override
    public boolean hasVariables() {
        this.ensureVariableInstancesInitialized();
        if (!this.variableInstances.isEmpty()) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariables();
        }
        return false;
    }

    @Override
    public boolean hasVariablesLocal() {
        this.ensureVariableInstancesInitialized();
        return !this.variableInstances.isEmpty();
    }

    @Override
    public boolean hasVariable(String variableName) {
        if (this.hasVariableLocal(variableName)) {
            return true;
        }
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            return parentScope.hasVariable(variableName);
        }
        return false;
    }

    @Override
    public boolean hasVariableLocal(String variableName) {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.containsKey(variableName);
    }

    protected Set<String> collectVariableNames(Set<String> variableNames) {
        this.ensureVariableInstancesInitialized();
        VariableScopeImpl parentScope = this.getParentVariableScope();
        if (parentScope != null) {
            variableNames.addAll(parentScope.collectVariableNames(variableNames));
        }
        for (VariableInstanceEntity variableInstance : this.variableInstances.values()) {
            variableNames.add(variableInstance.getName());
        }
        return variableNames;
    }

    @Override
    public Set<String> getVariableNames() {
        return this.collectVariableNames(new HashSet<String>());
    }

    @Override
    public Set<String> getVariableNamesLocal() {
        this.ensureVariableInstancesInitialized();
        return this.variableInstances.keySet();
    }

    @Override
    public void setVariable(String variableName, Object value) {
        if (this.hasVariableLocal(variableName)) {
            this.setVariableLocal(variableName, value);
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.setVariable(variableName, value);
            return;
        }
        this.createVariableLocal(variableName, value);
    }

    @Override
    public Object setVariableLocal(String variableName, Object value) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.get(variableName);
        if (variableInstance != null && !variableInstance.getType().isAbleToStore(value)) {
            this.removeVariable(variableName);
            variableInstance = null;
        }
        if (variableInstance == null) {
            this.createVariableLocal(variableName, value);
        } else {
            this.setVariableInstanceValue(value, variableInstance);
        }
        return null;
    }

    protected void setVariableInstanceValue(Object value, VariableInstanceEntity variableInstance) {
        variableInstance.setValue(value);
        int historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel();
        if (historyLevel == 3) {
            HistoricVariableUpdateEntity historicVariableUpdate = new HistoricVariableUpdateEntity(variableInstance);
            this.initializeActivityInstanceId(historicVariableUpdate);
            Context.getCommandContext().getDbSqlSession().insert(historicVariableUpdate);
        }
    }

    protected void initializeActivityInstanceId(HistoricVariableUpdateEntity historicVariableUpdate) {
    }

    @Override
    public void createVariableLocal(String variableName, Object value) {
        this.ensureVariableInstancesInitialized();
        if (this.variableInstances.containsKey(variableName)) {
            throw new ActivitiException("variable '" + variableName + "' already exists. Use setVariableLocal if you want to overwrite the value");
        }
        VariableTypes variableTypes = Context.getProcessEngineConfiguration().getVariableTypes();
        VariableType type = variableTypes.findVariableType(value);
        VariableInstanceEntity variableInstance = VariableInstanceEntity.createAndInsert(variableName, type, value);
        this.initializeVariableInstanceBackPointer(variableInstance);
        this.variableInstances.put(variableName, variableInstance);
        this.setVariableInstanceValue(value, variableInstance);
    }

    @Override
    public void createVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (Map.Entry<String, ? extends Object> entry : variables.entrySet()) {
                this.createVariableLocal(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    public void removeVariable(String variableName) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.remove(variableName);
        if (variableInstance != null) {
            variableInstance.delete();
            return;
        }
        VariableScopeImpl parentVariableScope = this.getParentVariableScope();
        if (parentVariableScope != null) {
            parentVariableScope.removeVariable(variableName);
        }
    }

    @Override
    public void removeVariableLocal(String variableName) {
        this.ensureVariableInstancesInitialized();
        VariableInstanceEntity variableInstance = this.variableInstances.remove(variableName);
        if (variableInstance != null) {
            variableInstance.delete();
        }
    }

    @Override
    public void setVariables(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariable(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void setVariablesLocal(Map<String, ? extends Object> variables) {
        if (variables != null) {
            for (String variableName : variables.keySet()) {
                this.setVariableLocal(variableName, variables.get(variableName));
            }
        }
    }

    @Override
    public void removeVariables() {
        this.ensureVariableInstancesInitialized();
        HashSet<String> variableNames = new HashSet<String>(this.variableInstances.keySet());
        for (String variableName : variableNames) {
            this.removeVariable(variableName);
        }
    }

    @Override
    public void removeVariablesLocal() {
        ArrayList<String> variableNames = new ArrayList<String>(this.getVariableNamesLocal());
        for (String variableName : variableNames) {
            this.removeVariableLocal(variableName);
        }
    }

    public ELContext getCachedElContext() {
        return this.cachedElContext;
    }

    public void setCachedElContext(ELContext cachedElContext) {
        this.cachedElContext = cachedElContext;
    }
}

