/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.mail;

import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import org.activiti.engine.ActivitiException;
import org.activiti.engine.identity.User;
import org.activiti.engine.impl.UserQueryImpl;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.mail.MailTransformer;
import org.activiti.engine.impl.persistence.entity.AttachmentEntity;
import org.activiti.engine.impl.persistence.entity.ByteArrayEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MailScanCmd
implements Command<Object> {
    private static Logger log = Logger.getLogger(MailScanCmd.class.getName());
    protected String userId;
    protected String imapUsername;
    protected String imapPassword;
    protected String imapHost;
    protected String imapProtocol;
    protected String toDoFolderName;
    protected String toDoInActivitiFolderName;

    @Override
    public Object execute(CommandContext commandContext) {
        log.fine("scanning mail for user " + this.userId);
        Store store = null;
        Folder toDoFolder = null;
        Folder toDoInActivitiFolder = null;
        try {
            Session session = Session.getDefaultInstance((Properties)new Properties());
            store = session.getStore(this.imapProtocol);
            log.fine("connecting to " + this.imapHost + " over " + this.imapProtocol + " for user " + this.imapUsername);
            store.connect(this.imapHost, this.imapUsername, this.imapPassword);
            toDoFolder = store.getFolder(this.toDoFolderName);
            toDoFolder.open(2);
            toDoInActivitiFolder = store.getFolder(this.toDoInActivitiFolderName);
            toDoInActivitiFolder.open(2);
            Message[] messages = toDoFolder.getMessages();
            log.fine("getting messages from myToDoFolder");
            DbSqlSession dbSqlSession = commandContext.getDbSqlSession();
            for (Message message : messages) {
                log.fine("transforming mail into activiti task: " + message.getSubject());
                MailTransformer mailTransformer = new MailTransformer(message);
                this.createTask(commandContext, dbSqlSession, mailTransformer);
                Message[] messagesToCopy = new Message[]{message};
                toDoFolder.copyMessages(messagesToCopy, toDoInActivitiFolder);
                message.setFlag(Flags.Flag.DELETED, true);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't scan mail for user " + this.userId + ": " + e.getMessage(), e);
        }
        finally {
            if (toDoInActivitiFolder != null && toDoInActivitiFolder.isOpen()) {
                try {
                    toDoInActivitiFolder.close(false);
                }
                catch (MessagingException e) {
                    e.printStackTrace();
                }
            }
            if (toDoFolder != null && toDoFolder.isOpen()) {
                try {
                    toDoFolder.close(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (store != null) {
                try {
                    store.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }

    public void createTask(CommandContext commandContext, DbSqlSession dbSqlSession, MailTransformer mailTransformer) throws MessagingException {
        String taskDescription = mailTransformer.getHtml();
        taskDescription = taskDescription.replaceAll("\\<.*?\\>", "");
        taskDescription = taskDescription.replaceAll("\\s", " ");
        if ((taskDescription = taskDescription.trim()).length() > 120) {
            taskDescription = taskDescription.substring(0, 117) + "...";
        }
        TaskEntity task = new TaskEntity();
        task.setAssignee(this.userId);
        task.setName(mailTransformer.getMessage().getSubject());
        task.setDescription(taskDescription);
        dbSqlSession.insert(task);
        String taskId = task.getId();
        for (String recipientEmailAddress : mailTransformer.getRecipients()) {
            User recipient = (User)new UserQueryImpl(commandContext).userEmail(recipientEmailAddress).singleResult();
            if (recipient == null) continue;
            task.addUserIdentityLink(recipient.getId(), "Recipient");
        }
        List<AttachmentEntity> attachments = mailTransformer.getAttachments();
        for (AttachmentEntity attachment : attachments) {
            ByteArrayEntity content = attachment.getContent();
            dbSqlSession.insert(content);
            attachment.setContentId(content.getId());
            attachment.setTaskId(taskId);
            dbSqlSession.insert(attachment);
        }
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getImapUsername() {
        return this.imapUsername;
    }

    public void setImapUsername(String imapUsername) {
        this.imapUsername = imapUsername;
    }

    public String getImapPassword() {
        return this.imapPassword;
    }

    public void setImapPassword(String imapPassword) {
        this.imapPassword = imapPassword;
    }

    public String getImapHost() {
        return this.imapHost;
    }

    public void setImapHost(String imapHost) {
        this.imapHost = imapHost;
    }

    public String getImapProtocol() {
        return this.imapProtocol;
    }

    public void setImapProtocol(String imapProtocol) {
        this.imapProtocol = imapProtocol;
    }

    public String getToDoFolderName() {
        return this.toDoFolderName;
    }

    public void setToDoFolderName(String toDoFolderName) {
        this.toDoFolderName = toDoFolderName;
    }

    public String getToDoInActivitiFolderName() {
        return this.toDoInActivitiFolderName;
    }

    public void setToDoInActivitiFolderName(String toDoInActivitiFolderName) {
        this.toDoInActivitiFolderName = toDoInActivitiFolderName;
    }
}

