/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl;

import java.sql.Connection;
import java.util.Map;
import org.activiti.engine.ManagementService;
import org.activiti.engine.impl.JobQueryImpl;
import org.activiti.engine.impl.ServiceImpl;
import org.activiti.engine.impl.TablePageQueryImpl;
import org.activiti.engine.impl.cmd.ExecuteJobsCmd;
import org.activiti.engine.impl.cmd.GetJobExceptionStacktraceCmd;
import org.activiti.engine.impl.cmd.GetPropertiesCmd;
import org.activiti.engine.impl.cmd.GetTableCountCmd;
import org.activiti.engine.impl.cmd.GetTableMetaDataCmd;
import org.activiti.engine.impl.cmd.SetJobRetriesCmd;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.DbSqlSessionFactory;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.management.TableMetaData;
import org.activiti.engine.management.TablePageQuery;
import org.activiti.engine.runtime.JobQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ManagementServiceImpl
extends ServiceImpl
implements ManagementService {
    @Override
    public Map<String, Long> getTableCount() {
        return this.commandExecutor.execute(new GetTableCountCmd());
    }

    @Override
    public TableMetaData getTableMetaData(String tableName) {
        return this.commandExecutor.execute(new GetTableMetaDataCmd(tableName));
    }

    @Override
    public void executeJob(String jobId) {
        this.commandExecutor.execute(new ExecuteJobsCmd(jobId));
    }

    @Override
    public void setJobRetries(String jobId, int retries) {
        this.commandExecutor.execute(new SetJobRetriesCmd(jobId, retries));
    }

    @Override
    public TablePageQuery createTablePageQuery() {
        return new TablePageQueryImpl(this.commandExecutor);
    }

    @Override
    public JobQuery createJobQuery() {
        return new JobQueryImpl(this.commandExecutor);
    }

    @Override
    public String getJobExceptionStacktrace(String jobId) {
        return this.commandExecutor.execute(new GetJobExceptionStacktraceCmd(jobId));
    }

    @Override
    public Map<String, String> getProperties() {
        return this.commandExecutor.execute(new GetPropertiesCmd());
    }

    @Override
    public String databaseSchemaUpgrade(final Connection connection, final String catalog, final String schema) {
        return this.commandExecutor.execute(new Command<String>(){

            @Override
            public String execute(CommandContext commandContext) {
                DbSqlSessionFactory dbSqlSessionFactory = (DbSqlSessionFactory)commandContext.getSessionFactories().get(DbSqlSession.class);
                DbSqlSession dbSqlSession = new DbSqlSession(dbSqlSessionFactory, connection, catalog, schema);
                commandContext.getSessions().put(DbSqlSession.class, dbSqlSession);
                return dbSqlSession.dbSchemaUpdate();
            }
        });
    }
}

