/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local.operations;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.framework.api.operations.UpdateApiOp;
import org.identityconnectors.framework.common.exceptions.UnknownUidException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.Name;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorAPIOperationRunner;
import org.identityconnectors.framework.impl.api.local.operations.ConnectorOperationalContext;
import org.identityconnectors.framework.impl.api.local.operations.GetImpl;
import org.identityconnectors.framework.impl.api.local.operations.ObjectNormalizerFacade;
import org.identityconnectors.framework.impl.api.local.operations.SearchImpl;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.UpdateAttributeValuesOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateImpl
extends ConnectorAPIOperationRunner
implements UpdateApiOp {
    static Set<String> OPERATIONAL_ATTRIBUTE_NAMES = new HashSet<String>();

    public UpdateImpl(ConnectorOperationalContext context, Connector connector) {
        super(context, connector);
    }

    @Override
    public Uid update(ObjectClass objclass, Uid uid, Set<Attribute> replaceAttributes, OperationOptions options) {
        UpdateImpl.validateInput(objclass, uid, replaceAttributes, false);
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ObjectNormalizerFacade normalizer = this.getNormalizer(objclass);
        uid = (Uid)normalizer.normalizeAttribute(uid);
        replaceAttributes = normalizer.normalizeAttributes(replaceAttributes);
        UpdateOp op = (UpdateOp)((Object)this.getConnector());
        Uid ret = op.update(objclass, uid, replaceAttributes, options);
        return (Uid)normalizer.normalizeAttribute(ret);
    }

    @Override
    public Uid addAttributeValues(ObjectClass objclass, Uid uid, Set<Attribute> valuesToAdd, OperationOptions options) {
        Uid ret;
        UpdateImpl.validateInput(objclass, uid, valuesToAdd, true);
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ObjectNormalizerFacade normalizer = this.getNormalizer(objclass);
        uid = (Uid)normalizer.normalizeAttribute(uid);
        valuesToAdd = normalizer.normalizeAttributes(valuesToAdd);
        UpdateOp op = (UpdateOp)((Object)this.getConnector());
        if (op instanceof UpdateAttributeValuesOp) {
            UpdateAttributeValuesOp valueOp = (UpdateAttributeValuesOp)op;
            ret = valueOp.addAttributeValues(objclass, uid, valuesToAdd, options);
        } else {
            Set<Attribute> replaceAttributes = this.fetchAndMerge(objclass, uid, valuesToAdd, true, options);
            ret = op.update(objclass, uid, replaceAttributes, options);
        }
        return (Uid)normalizer.normalizeAttribute(ret);
    }

    @Override
    public Uid removeAttributeValues(ObjectClass objclass, Uid uid, Set<Attribute> valuesToRemove, OperationOptions options) {
        Uid ret;
        UpdateImpl.validateInput(objclass, uid, valuesToRemove, true);
        if (options == null) {
            options = new OperationOptionsBuilder().build();
        }
        ObjectNormalizerFacade normalizer = this.getNormalizer(objclass);
        uid = (Uid)normalizer.normalizeAttribute(uid);
        valuesToRemove = normalizer.normalizeAttributes(valuesToRemove);
        UpdateOp op = (UpdateOp)((Object)this.getConnector());
        if (op instanceof UpdateAttributeValuesOp) {
            UpdateAttributeValuesOp valueOp = (UpdateAttributeValuesOp)op;
            ret = valueOp.removeAttributeValues(objclass, uid, valuesToRemove, options);
        } else {
            Set<Attribute> replaceAttributes = this.fetchAndMerge(objclass, uid, valuesToRemove, false, options);
            ret = op.update(objclass, uid, replaceAttributes, options);
        }
        return (Uid)normalizer.normalizeAttribute(ret);
    }

    private Set<Attribute> fetchAndMerge(ObjectClass objclass, Uid uid, Set<Attribute> valuesToChange, boolean add, OperationOptions options) {
        if (!(this.getConnector() instanceof SearchOp)) {
            String MSG = "Connector must support: " + SearchOp.class;
            throw new UnsupportedOperationException(MSG);
        }
        OperationOptionsBuilder builder = new OperationOptionsBuilder(options);
        HashSet<String> attrNames = new HashSet<String>();
        for (Attribute attribute : valuesToChange) {
            attrNames.add(attribute.getName());
        }
        builder.setAttributesToGet(attrNames);
        options = builder.build();
        ConnectorObject o = this.getConnectorObject(objclass, uid, options);
        if (o == null) {
            throw new UnknownUidException(uid, objclass);
        }
        Set<Attribute> mergeAttrs = this.merge(valuesToChange, o.getAttributes(), add);
        return mergeAttrs;
    }

    public Set<Attribute> merge(Set<Attribute> updateAttrs, Set<Attribute> baseAttrs, boolean add) {
        HashSet<Attribute> ret = new HashSet<Attribute>();
        Map<String, Attribute> baseAttrMap = AttributeUtil.toMap(baseAttrs);
        for (Attribute updateAttr : updateAttrs) {
            List<Object> values;
            Attribute modifiedAttr;
            String name = updateAttr.getName();
            Attribute baseAttr = baseAttrMap.get(name);
            if (add) {
                if (baseAttr == null) {
                    modifiedAttr = updateAttr;
                } else {
                    values = CollectionUtil.newList(baseAttr.getValue());
                    values.addAll(updateAttr.getValue());
                    modifiedAttr = AttributeBuilder.build(name, values);
                }
            } else {
                if (baseAttr == null) continue;
                values = CollectionUtil.newList(baseAttr.getValue());
                for (Object val : updateAttr.getValue()) {
                    values.remove(val);
                }
                modifiedAttr = values.isEmpty() ? AttributeBuilder.build(name) : AttributeBuilder.build(name, values);
            }
            ret.add(modifiedAttr);
        }
        return ret;
    }

    private ConnectorObject getConnectorObject(ObjectClass oclass, Uid uid, OperationOptions options) {
        GetImpl get = new GetImpl(new SearchImpl(this.getOperationalContext(), this.getConnector()));
        return get.getObject(oclass, uid, options);
    }

    public static void validateInput(ObjectClass objclass, Uid uid, Set<Attribute> attrs, boolean isDelta) {
        String OPERATIONAL_ATTRIBUTE_ERR = "Operational attribute '%s' can not be added or removed.";
        Assertions.nullCheck(uid, "uid");
        Assertions.nullCheck(objclass, "objclass");
        Assertions.nullCheck(attrs, "attrs");
        if (AttributeUtil.getUidAttribute(attrs) != null) {
            throw new IllegalArgumentException("Parameter 'attrs' contains a uid.");
        }
        if (isDelta) {
            for (Attribute attr : attrs) {
                Assertions.nullCheck(attr, "attr");
                if (attr.getValue() == null) {
                    throw new IllegalArgumentException("Can not add or remove a 'null' value.");
                }
                String name = attr.getName();
                if (!OPERATIONAL_ATTRIBUTE_NAMES.contains(name)) continue;
                String msg = String.format("Operational attribute '%s' can not be added or removed.", name);
                throw new IllegalArgumentException(msg);
            }
        }
    }

    static {
        OPERATIONAL_ATTRIBUTE_NAMES.addAll(OperationalAttributes.getOperationalAttributeNames());
        OPERATIONAL_ATTRIBUTE_NAMES.add(Name.NAME);
    }
}

