/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.util.HashMap;
import java.util.Map;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.pooling.ObjectPoolConfiguration;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConfigurationPropertiesImpl;
import org.identityconnectors.framework.impl.api.local.JavaClassProperties;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.local.ObjectPool;
import org.identityconnectors.framework.impl.api.local.ObjectPoolHandler;
import org.identityconnectors.framework.impl.api.local.ThreadClassLoaderManager;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.PoolableConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectorPoolManager {
    private static final Map<ConnectorPoolKey, ObjectPool<PoolableConnector>> _pools = new HashMap<ConnectorPoolKey, ObjectPool<PoolableConnector>>();
    private static Log _log = Log.getLog(ConnectorPoolManager.class);

    public static ObjectPool<PoolableConnector> getPool(APIConfigurationImpl impl, LocalConnectorInfoImpl localInfo) {
        try {
            return ConnectorPoolManager.getPool2(impl, localInfo);
        }
        catch (Exception e) {
            throw ConnectorException.wrap(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ObjectPool<PoolableConnector> getPool2(APIConfigurationImpl impl, LocalConnectorInfoImpl localInfo) throws InstantiationException, IllegalAccessException {
        ObjectPool<PoolableConnector> pool = null;
        if (impl.isConnectorPoolingSupported()) {
            ConnectorPoolKey key = new ConnectorPoolKey(impl.getConnectorInfo().getConnectorKey(), impl.getConfigurationProperties(), impl.getConnectorPoolConfiguration());
            Map<ConnectorPoolKey, ObjectPool<PoolableConnector>> map = _pools;
            synchronized (map) {
                pool = _pools.get(key);
                if (pool == null) {
                    _log.info("Creating new pool: {0}", impl.getConnectorInfo().getConnectorKey());
                    pool = new ObjectPool<PoolableConnector>(new ConnectorPoolHandler(impl, localInfo), impl.getConnectorPoolConfiguration());
                    _pools.put(key, pool);
                }
            }
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dispose() {
        Map<ConnectorPoolKey, ObjectPool<PoolableConnector>> map = _pools;
        synchronized (map) {
            for (ObjectPool<PoolableConnector> pool : _pools.values()) {
                try {
                    pool.shutdown();
                }
                catch (Exception e) {
                    _log.warn(e, "Failed to close pool: {0}", pool);
                }
            }
            _pools.clear();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ConnectorPoolHandler
    implements ObjectPoolHandler<PoolableConnector> {
        private final APIConfigurationImpl _apiConfiguration;
        private final LocalConnectorInfoImpl _localInfo;

        public ConnectorPoolHandler(APIConfigurationImpl apiConfiguration, LocalConnectorInfoImpl localInfo) {
            this._apiConfiguration = apiConfiguration;
            this._localInfo = localInfo;
        }

        @Override
        public PoolableConnector newObject() {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this._localInfo.getConnectorClass().getClassLoader());
            try {
                Configuration config = JavaClassProperties.createBean(this._apiConfiguration.getConfigurationProperties(), this._localInfo.getConnectorConfigurationClass());
                PoolableConnector connector = (PoolableConnector)this._localInfo.getConnectorClass().newInstance();
                connector.init(config);
                PoolableConnector poolableConnector = connector;
                return poolableConnector;
            }
            catch (Exception e) {
                throw ConnectorException.wrap(e);
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void testObject(PoolableConnector object) {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this._localInfo.getConnectorClass().getClassLoader());
            try {
                object.checkAlive();
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void disposeObject(PoolableConnector object) {
            ThreadClassLoaderManager.getInstance().pushClassLoader(this._localInfo.getConnectorClass().getClassLoader());
            try {
                object.dispose();
            }
            finally {
                ThreadClassLoaderManager.getInstance().popClassLoader();
            }
        }
    }

    private static class ConnectorPoolKey {
        private final ConnectorKey _connectorKey;
        private final ConfigurationPropertiesImpl _configProperties;
        private final ObjectPoolConfiguration _poolingConfig;

        public ConnectorPoolKey(ConnectorKey connectorKey, ConfigurationPropertiesImpl configProperties, ObjectPoolConfiguration poolingConfig) {
            this._connectorKey = connectorKey;
            this._configProperties = configProperties;
            this._poolingConfig = poolingConfig;
        }

        public int hashCode() {
            return this._connectorKey.hashCode();
        }

        public boolean equals(Object o) {
            if (o instanceof ConnectorPoolKey) {
                ConnectorPoolKey other = (ConnectorPoolKey)o;
                if (!this._connectorKey.equals(other._connectorKey)) {
                    return false;
                }
                if (!this._configProperties.equals(other._configProperties)) {
                    return false;
                }
                return this._poolingConfig.equals(other._poolingConfig);
            }
            return false;
        }
    }
}

