/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.xml;

import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class XsdTypeMapper {
    public static final String BOOLEAN_XML_VALUE_TRUE = "true";
    public static final String BOOLEAN_XML_VALUE_FALSE = "false";
    private static Map<Class, QName> javaToXsdTypeMap;
    private static Map<QName, Class> xsdToJavaTypeMap;
    private static final Trace LOGGER;

    static {
        LOGGER = TraceManager.getTrace(XsdTypeMapper.class);
        try {
            XsdTypeMapper.initTypeMap();
        }
        catch (Exception e) {
            LOGGER.error("Cannot initialize XSD type mapping: " + e.getMessage(), (Throwable)e);
            throw new IllegalStateException("Cannot initialize XSD type mapping: " + e.getMessage(), e);
        }
    }

    private static void initTypeMap() throws IOException, ClassNotFoundException {
        javaToXsdTypeMap = new HashMap<Class, QName>();
        xsdToJavaTypeMap = new HashMap<QName, Class>();
        XsdTypeMapper.addMapping(String.class, DOMUtil.XSD_STRING, true);
        XsdTypeMapper.addMapping(Character.TYPE, DOMUtil.XSD_STRING, false);
        XsdTypeMapper.addMapping(File.class, DOMUtil.XSD_STRING, false);
        XsdTypeMapper.addMapping(Integer.TYPE, DOMUtil.XSD_INT, true);
        XsdTypeMapper.addMapping(Integer.class, DOMUtil.XSD_INT, false);
        XsdTypeMapper.addMapping(BigInteger.class, DOMUtil.XSD_INTEGER, true);
        XsdTypeMapper.addMapping(Double.TYPE, DOMUtil.XSD_DOUBLE, true);
        XsdTypeMapper.addMapping(Double.class, DOMUtil.XSD_DOUBLE, false);
        XsdTypeMapper.addMapping(Float.TYPE, DOMUtil.XSD_FLOAT, true);
        XsdTypeMapper.addMapping(Float.class, DOMUtil.XSD_FLOAT, false);
        XsdTypeMapper.addMapping(Long.TYPE, DOMUtil.XSD_LONG, true);
        XsdTypeMapper.addMapping(Long.class, DOMUtil.XSD_LONG, false);
        XsdTypeMapper.addMapping(Short.TYPE, DOMUtil.XSD_SHORT, true);
        XsdTypeMapper.addMapping(Short.class, DOMUtil.XSD_SHORT, false);
        XsdTypeMapper.addMapping(Boolean.TYPE, DOMUtil.XSD_BOOLEAN, true);
        XsdTypeMapper.addMapping(Boolean.class, DOMUtil.XSD_BOOLEAN, false);
        XsdTypeMapper.addMapping(byte[].class, DOMUtil.XSD_BASE64BINARY, true);
        XsdTypeMapper.addMapping(GregorianCalendar.class, DOMUtil.XSD_DATETIME, true);
        XsdTypeMapper.addMapping(XMLGregorianCalendar.class, DOMUtil.XSD_DATETIME, true);
        XsdTypeMapper.addMapping(QName.class, DOMUtil.XSD_QNAME, true);
        XsdTypeMapper.addMapping(PolyString.class, PrismConstants.POLYSTRING_TYPE_QNAME, true);
        xsdToJavaTypeMap.put(DOMUtil.XSD_ANYURI, String.class);
    }

    private static void addMapping(Class javaClass, QName xsdType, boolean both) {
        LOGGER.trace("Adding XSD type mapping {} {} {} ", new Object[]{javaClass, both ? "<->" : " ->", xsdType});
        javaToXsdTypeMap.put(javaClass, xsdType);
        if (both) {
            xsdToJavaTypeMap.put(xsdType, javaClass);
        }
    }

    public static QName toXsdType(Class javaClass) {
        QName xsdType = XsdTypeMapper.getJavaToXsdMapping(javaClass);
        if (xsdType == null) {
            throw new IllegalArgumentException("No XSD mapping for Java type " + javaClass.getCanonicalName());
        }
        return xsdType;
    }

    public static QName getJavaToXsdMapping(Class<?> type) {
        if (javaToXsdTypeMap.containsKey(type)) {
            return javaToXsdTypeMap.get(type);
        }
        Class<?> superType = type.getSuperclass();
        if (superType != null) {
            return XsdTypeMapper.getJavaToXsdMapping(superType);
        }
        return null;
    }

    public static Class<?> getXsdToJavaMapping(QName xsdType) {
        return xsdToJavaTypeMap.get(xsdType);
    }

    public static Class<?> getTypeFromClass(Class<?> clazz) {
        if (javaToXsdTypeMap.containsKey(clazz)) {
            return clazz;
        }
        Class<?> superClazz = clazz.getSuperclass();
        if (superClazz != null) {
            return XsdTypeMapper.getTypeFromClass(superClazz);
        }
        return null;
    }

    public static Class toJavaType(QName xsdType) {
        Class javaType = xsdToJavaTypeMap.get(xsdType);
        if (javaType == null) {
            if (xsdType.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema")) {
                throw new IllegalArgumentException("No type mapping for XSD type " + xsdType);
            }
            return Element.class;
        }
        return javaType;
    }
}

