/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism.xml;

import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.xml.TypedValue;
import com.evolveum.midpoint.prism.xml.XsdTypeMapper;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.JAXBUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.io.File;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XmlTypeConverter {
    private static DatatypeFactory datatypeFactory = null;
    private static final Trace LOGGER = TraceManager.getTrace(XmlTypeConverter.class);

    private static DatatypeFactory getDatatypeFactory() {
        if (datatypeFactory == null) {
            try {
                datatypeFactory = DatatypeFactory.newInstance();
            }
            catch (DatatypeConfigurationException ex) {
                throw new IllegalStateException("Cannot construct DatatypeFactory: " + ex.getMessage(), ex);
            }
        }
        return datatypeFactory;
    }

    public static <T> T toJavaValue(Element xmlElement, Class<T> type) throws SchemaException {
        if (type.equals(Element.class)) {
            return (T)xmlElement;
        }
        if (type.equals(QName.class)) {
            return (T)DOMUtil.getQNameValue((Element)xmlElement);
        }
        if (PolyString.class.isAssignableFrom(type)) {
            return (T)XmlTypeConverter.polyStringToJava(xmlElement);
        }
        String stringContent = xmlElement.getTextContent();
        if (stringContent == null) {
            return null;
        }
        T javaValue = XmlTypeConverter.toJavaValue(stringContent, type);
        if (javaValue == null) {
            throw new IllegalArgumentException("Unknown type for conversion: " + type + "(element " + DOMUtil.getQName((Node)xmlElement) + ")");
        }
        return javaValue;
    }

    public static <T> T toJavaValue(String stringContent, Class<T> type) {
        if (type.equals(String.class)) {
            return (T)stringContent;
        }
        if (type.equals(Character.TYPE)) {
            return (T)new Character(stringContent.charAt(0));
        }
        if (type.equals(File.class)) {
            return (T)new File(stringContent);
        }
        if (type.equals(Integer.class)) {
            return (T)Integer.valueOf(stringContent);
        }
        if (type.equals(Integer.TYPE)) {
            return (T)Integer.valueOf(stringContent);
        }
        if (type.equals(Short.class) || type.equals(Short.TYPE)) {
            return (T)Short.valueOf(stringContent);
        }
        if (type.equals(Long.class)) {
            return (T)Long.valueOf(stringContent);
        }
        if (type.equals(Long.TYPE)) {
            return (T)Long.valueOf(stringContent);
        }
        if (type.equals(Float.TYPE)) {
            return (T)Float.valueOf(stringContent);
        }
        if (type.equals(Float.class)) {
            return (T)Float.valueOf(stringContent);
        }
        if (type.equals(Double.TYPE)) {
            return (T)Double.valueOf(stringContent);
        }
        if (type.equals(Double.class)) {
            return (T)Double.valueOf(stringContent);
        }
        if (type.equals(byte[].class)) {
            byte[] decodedData = Base64.decodeBase64((String)stringContent);
            return (T)decodedData;
        }
        if (type.equals(Boolean.TYPE) || Boolean.class.isAssignableFrom(type)) {
            return (T)Boolean.valueOf(stringContent);
        }
        if (type.equals(GregorianCalendar.class)) {
            return (T)XmlTypeConverter.getDatatypeFactory().newXMLGregorianCalendar(stringContent).toGregorianCalendar();
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(type)) {
            return (T)XmlTypeConverter.getDatatypeFactory().newXMLGregorianCalendar(stringContent);
        }
        if (type.equals(PolyString.class)) {
            return (T)new PolyString(stringContent);
        }
        return null;
    }

    public static Object toJavaValue(Element xmlElement, QName type) throws SchemaException {
        return XmlTypeConverter.toJavaValue(xmlElement, XsdTypeMapper.toJavaType(type));
    }

    public static Object toJavaValue(Element xmlElement) throws SchemaException {
        return XmlTypeConverter.toTypedJavaValueWithDefaultType(xmlElement, null).getValue();
    }

    public static TypedValue toTypedJavaValueWithDefaultType(Element xmlElement, QName defaultType) throws SchemaException {
        QName xsiType = DOMUtil.resolveXsiType((Element)xmlElement, null);
        if (xsiType == null && (xsiType = defaultType) == null) {
            QName elementQName = JAXBUtil.getElementQName((Object)xmlElement);
            throw new SchemaException("Cannot convert element " + elementQName + " to java, no type information available", elementQName);
        }
        return new TypedValue(XmlTypeConverter.toJavaValue(xmlElement, xsiType), xsiType, DOMUtil.getQName((Node)xmlElement));
    }

    public static Object toXsdElement(Object val, QName typeName, QName elementName, Document doc, boolean recordType) throws SchemaException {
        Object createdObject = XmlTypeConverter.toXsdElement(val, elementName, doc, false);
        if (createdObject instanceof Element) {
            Element createdElement = (Element)createdObject;
            if (recordType) {
                if (typeName == null) {
                    typeName = XsdTypeMapper.toXsdType(val.getClass());
                }
                DOMUtil.setXsiType((Element)createdElement, (QName)typeName);
            }
        }
        return createdObject;
    }

    public static Object toXsdElement(Object val, QName elementName, Document doc) throws SchemaException {
        return XmlTypeConverter.toXsdElement(val, elementName, doc, false);
    }

    public static Object toXsdElement(Object val, QName elementName, Document doc, boolean recordType) throws SchemaException {
        if (val == null) {
            return null;
        }
        Class<?> type = XsdTypeMapper.getTypeFromClass(val.getClass());
        if (type == null) {
            throw new IllegalArgumentException("No type mapping for conversion: " + val.getClass() + "(element " + elementName + ")");
        }
        if (doc == null) {
            doc = DOMUtil.getDocument();
        }
        Element element = doc.createElementNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        XmlTypeConverter.toXsdElement(val, element, recordType);
        return element;
    }

    public static void toXsdElement(Object val, Element element, boolean recordType) throws SchemaException {
        if (val instanceof Element) {
            return;
        }
        if (val instanceof QName) {
            QName qname = (QName)val;
            DOMUtil.setQNameValue((Element)element, (QName)qname);
        } else if (val instanceof PolyString) {
            XmlTypeConverter.polyStringToElement(element, (PolyString)val);
        } else {
            element.setTextContent(XmlTypeConverter.toXmlTextContent(val, DOMUtil.getQName((Node)element)));
        }
        if (recordType) {
            QName xsdType = XsdTypeMapper.toXsdType(val.getClass());
            DOMUtil.setXsiType((Element)element, (QName)xsdType);
        }
    }

    public static String toXmlTextContent(Object val, QName elementName) {
        if (val == null) {
            return null;
        }
        Class<?> type = XsdTypeMapper.getTypeFromClass(val.getClass());
        if (type == null) {
            throw new IllegalArgumentException("No type mapping for conversion: " + val.getClass() + "(element " + elementName + ")");
        }
        if (type.equals(String.class)) {
            return (String)val;
        }
        if (type.equals(Character.TYPE) || type.equals(Character.class)) {
            return ((Character)val).toString();
        }
        if (type.equals(File.class)) {
            return ((File)val).getPath();
        }
        if (type.equals(Integer.TYPE) || type.equals(Integer.class)) {
            return ((Integer)val).toString();
        }
        if (type.equals(Long.TYPE) || type.equals(Long.class)) {
            return ((Long)val).toString();
        }
        if (type.equals(Float.TYPE) || type.equals(Float.class)) {
            return ((Float)val).toString();
        }
        if (type.equals(Double.TYPE) || type.equals(Double.class)) {
            return ((Double)val).toString();
        }
        if (type.equals(byte[].class)) {
            byte[] binaryData = (byte[])val;
            return Base64.encodeBase64String((byte[])binaryData);
        }
        if (type.equals(Boolean.class)) {
            Boolean bool = (Boolean)val;
            if (bool.booleanValue()) {
                return "true";
            }
            return "false";
        }
        if (type.equals(GregorianCalendar.class)) {
            XMLGregorianCalendar xmlCal = XmlTypeConverter.createXMLGregorianCalendar((GregorianCalendar)val);
            return xmlCal.toXMLFormat();
        }
        if (XMLGregorianCalendar.class.isAssignableFrom(type)) {
            return ((XMLGregorianCalendar)val).toXMLFormat();
        }
        throw new IllegalArgumentException("Unknown type for conversion: " + type + "(element " + elementName + ")");
    }

    public static boolean canConvert(Class<?> clazz) {
        return XsdTypeMapper.getJavaToXsdMapping(clazz) != null;
    }

    public static boolean canConvert(QName xsdType) {
        return XsdTypeMapper.getXsdToJavaMapping(xsdType) != null;
    }

    public static <T> T convertValueElementAsScalar(Element valueElement, Class<T> type) throws SchemaException {
        return XmlTypeConverter.toJavaValue(valueElement, type);
    }

    public static Object convertValueElementAsScalar(Element valueElement, QName xsdType) throws SchemaException {
        return XmlTypeConverter.toJavaValue(valueElement, xsdType);
    }

    public static List<Object> convertValueElementAsList(Element valueElement) throws SchemaException {
        return XmlTypeConverter.convertValueElementAsList(valueElement.getChildNodes(), Object.class);
    }

    public static <T> List<T> convertValueElementAsList(Element valueElement, Class<T> type) throws SchemaException {
        if (type.equals(Object.class) && DOMUtil.hasXsiType((Element)valueElement)) {
            Object scalarValue = XmlTypeConverter.convertValueElementAsScalar(valueElement, DOMUtil.resolveXsiType((Element)valueElement));
            ArrayList<Object> list = new ArrayList<Object>(1);
            list.add(scalarValue);
            return list;
        }
        return XmlTypeConverter.convertValueElementAsList(valueElement.getChildNodes(), type);
    }

    public static List<?> convertValueElementAsList(Element valueElement, QName xsdType) throws SchemaException {
        Class type = XsdTypeMapper.toJavaType(xsdType);
        return XmlTypeConverter.convertValueElementAsList(valueElement.getChildNodes(), type);
    }

    public static <T> List<T> convertValueElementAsList(NodeList valueNodes, Class<T> type) throws SchemaException {
        ArrayList<Object> values = new ArrayList<Object>();
        if (valueNodes == null) {
            return values;
        }
        T scalarAttempt = XmlTypeConverter.tryConvertPrimitiveScalar(valueNodes, type);
        if (scalarAttempt != null) {
            values.add(scalarAttempt);
            return values;
        }
        int i = 0;
        while (i < valueNodes.getLength()) {
            Node node = valueNodes.item(i);
            if (!DOMUtil.isJunk((Node)node) && node.getNodeType() == 1) {
                Element element = (Element)node;
                String value = null;
                if (type.equals(Object.class)) {
                    Class overrideType = String.class;
                    if (DOMUtil.hasXsiType((Element)element)) {
                        QName xsiType = DOMUtil.resolveXsiType((Element)element);
                        overrideType = XsdTypeMapper.toJavaType(xsiType);
                    }
                    value = XmlTypeConverter.toJavaValue(element, overrideType);
                } else {
                    value = (String)XmlTypeConverter.toJavaValue(element, type);
                }
                values.add(value);
            }
            ++i;
        }
        return values;
    }

    private static <T> T tryConvertPrimitiveScalar(NodeList valueNodes, Class<T> type) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < valueNodes.getLength()) {
            Node node = valueNodes.item(i);
            if (!DOMUtil.isJunk((Node)node)) {
                if (node.getNodeType() == 3) {
                    sb.append(node.getTextContent());
                } else {
                    return null;
                }
            }
            ++i;
        }
        if (type.equals(Object.class)) {
            return (T)XmlTypeConverter.toJavaValue(sb.toString(), String.class);
        }
        return XmlTypeConverter.toJavaValue(sb.toString(), type);
    }

    public static void appendBelowNode(Object val, QName xsdType, QName name, Node parentNode, boolean recordType) throws SchemaException {
        Object xsdElement = XmlTypeConverter.toXsdElement(val, xsdType, name, parentNode.getOwnerDocument(), recordType);
        if (xsdElement == null) {
            return;
        }
        if (!(xsdElement instanceof Element)) {
            throw new IllegalStateException("The XSD type converter returned unknown element type: " + xsdElement + " (" + xsdElement.getClass().getName() + ")");
        }
        parentNode.appendChild((Element)xsdElement);
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(long timeInMillis) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTimeInMillis(timeInMillis);
        return XmlTypeConverter.createXMLGregorianCalendar(gregorianCalendar);
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(GregorianCalendar cal) {
        return XmlTypeConverter.getDatatypeFactory().newXMLGregorianCalendar(cal);
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(int year, int month, int day, int hour, int minute, int second, int millisecond, int timezone) {
        return XmlTypeConverter.getDatatypeFactory().newXMLGregorianCalendar(year, month, day, hour, minute, second, millisecond, timezone);
    }

    public static XMLGregorianCalendar createXMLGregorianCalendar(int year, int month, int day, int hour, int minute, int second) {
        return XmlTypeConverter.getDatatypeFactory().newXMLGregorianCalendar(year, month, day, hour, minute, second, 0, 0);
    }

    public static long toMillis(XMLGregorianCalendar xmlCal) {
        return xmlCal.toGregorianCalendar().getTimeInMillis();
    }

    private static PolyString polyStringToJava(Element polyStringElement) throws SchemaException {
        Element origElement = DOMUtil.getChildElement((Element)polyStringElement, (QName)PrismConstants.POLYSTRING_ELEMENT_ORIG_QNAME);
        if (origElement == null) {
            if (DOMUtil.hasChildElements((Node)polyStringElement)) {
                throw new SchemaException("Missing element " + PrismConstants.POLYSTRING_ELEMENT_ORIG_QNAME + " in polystring element " + DOMUtil.getQName((Node)polyStringElement));
            }
            String orig = polyStringElement.getTextContent();
            return new PolyString(orig);
        }
        String orig = origElement.getTextContent();
        String norm = null;
        Element normElement = DOMUtil.getChildElement((Element)polyStringElement, (QName)PrismConstants.POLYSTRING_ELEMENT_NORM_QNAME);
        if (normElement != null) {
            norm = normElement.getTextContent();
        }
        return new PolyString(orig, norm);
    }

    private static void polyStringToElement(Element polyStringElement, PolyString polyString) {
        Element origElement;
        if (polyString.getOrig() != null) {
            origElement = DOMUtil.createSubElement((Element)polyStringElement, (QName)PrismConstants.POLYSTRING_ELEMENT_ORIG_QNAME);
            origElement.setTextContent(polyString.getOrig());
        }
        if (polyString.getNorm() != null) {
            origElement = DOMUtil.createSubElement((Element)polyStringElement, (QName)PrismConstants.POLYSTRING_ELEMENT_NORM_QNAME);
            origElement.setTextContent(polyString.getNorm());
        }
    }
}

