/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.Definition;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;

public class ComplexTypeDefinition
extends Definition {
    private static final long serialVersionUID = 2655797837209175037L;
    private List<ItemDefinition> itemDefinitions = new ArrayList<ItemDefinition>();
    private QName superType;
    private boolean containerMarker;
    private boolean objectMarker;
    private boolean xsdAnyMarker;
    private QName extensionForType;
    private Class<?> compileTimeClass;

    public ComplexTypeDefinition(QName defaultName, QName typeName, PrismContext prismContext) {
        super(defaultName, typeName, prismContext);
    }

    public ComplexTypeDefinition(QName defaultName, QName typeName, PrismContext prismContext, Class<?> compileTimeClass) {
        super(defaultName, typeName, prismContext);
        this.compileTimeClass = compileTimeClass;
    }

    protected String getSchemaNamespace() {
        return this.getTypeName().getNamespaceURI();
    }

    public List<ItemDefinition> getDefinitions() {
        if (this.itemDefinitions == null) {
            this.itemDefinitions = new ArrayList<ItemDefinition>();
        }
        return this.itemDefinitions;
    }

    public Class<?> getCompileTimeClass() {
        return this.compileTimeClass;
    }

    public void setCompileTimeClass(Class<?> compileTimeClass) {
        this.compileTimeClass = compileTimeClass;
    }

    public QName getExtensionForType() {
        return this.extensionForType;
    }

    public void setExtensionForType(QName extensionForType) {
        this.extensionForType = extensionForType;
    }

    public boolean isContainerMarker() {
        return this.containerMarker;
    }

    public void setContainerMarker(boolean containerMarker) {
        this.containerMarker = containerMarker;
    }

    public boolean isObjectMarker() {
        return this.objectMarker;
    }

    public boolean isXsdAnyMarker() {
        return this.xsdAnyMarker;
    }

    public void setXsdAnyMarker(boolean xsdAnyMarker) {
        this.xsdAnyMarker = xsdAnyMarker;
    }

    public QName getSuperType() {
        return this.superType;
    }

    public void setSuperType(QName superType) {
        this.superType = superType;
    }

    public void setObjectMarker(boolean objectMarker) {
        this.objectMarker = objectMarker;
    }

    public void add(ItemDefinition definition) {
        this.itemDefinitions.add(definition);
    }

    public PrismPropertyDefinition createPropertyDefinifion(QName name, QName typeName) {
        PrismPropertyDefinition propDef = new PrismPropertyDefinition(name, name, typeName, this.prismContext);
        this.itemDefinitions.add(propDef);
        return propDef;
    }

    public PrismPropertyDefinition createPropertyDefinifion(QName name) {
        PrismPropertyDefinition propDef = new PrismPropertyDefinition(name, name, null, this.prismContext);
        this.itemDefinitions.add(propDef);
        return propDef;
    }

    public PrismPropertyDefinition createPropertyDefinition(String localName, QName typeName) {
        QName name = new QName(this.getSchemaNamespace(), localName);
        return this.createPropertyDefinifion(name, typeName);
    }

    public PrismPropertyDefinition createPropertyDefinifion(String localName, String localTypeName) {
        QName name = new QName(this.getSchemaNamespace(), localName);
        QName typeName = new QName(this.getSchemaNamespace(), localTypeName);
        return this.createPropertyDefinifion(name, typeName);
    }

    public PrismPropertyDefinition findPropertyDefinition(QName name) {
        return this.findItemDefinition(name, PrismPropertyDefinition.class);
    }

    public PrismContainerDefinition findContainerDefinition(QName name) {
        return this.findItemDefinition(name, PrismContainerDefinition.class);
    }

    public <T extends ItemDefinition> T findItemDefinition(QName name, Class<T> clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("type not specified while searching for " + name + " in " + this);
        }
        if (name == null) {
            throw new IllegalArgumentException("name not specified while searching in " + this);
        }
        for (ItemDefinition def : this.getDefinitions()) {
            if (!this.isItemValid(def, name, clazz)) continue;
            return (T)def;
        }
        return null;
    }

    private <T extends ItemDefinition> boolean isItemValid(ItemDefinition def, QName name, Class<T> clazz) {
        return clazz.isAssignableFrom(def.getClass()) && name.equals(def.getName());
    }

    @Override
    void revive(PrismContext prismContext) {
        if (this.prismContext != null) {
            return;
        }
        this.prismContext = prismContext;
        for (ItemDefinition def : this.itemDefinitions) {
            def.revive(prismContext);
        }
    }

    public boolean isEmpty() {
        return this.itemDefinitions.isEmpty();
    }

    public ComplexTypeDefinition clone() {
        ComplexTypeDefinition clone = new ComplexTypeDefinition(this.defaultName, this.typeName, this.prismContext);
        this.copyDefinitionData(clone);
        return clone;
    }

    protected void copyDefinitionData(ComplexTypeDefinition clone) {
        super.copyDefinitionData(clone);
        clone.itemDefinitions.addAll(this.itemDefinitions);
    }

    public void replaceDefinition(QName propertyName, ItemDefinition newDefinition) {
        for (ItemDefinition itemDef : this.itemDefinitions) {
            if (!itemDef.getName().equals(propertyName)) continue;
            if (!itemDef.getClass().isAssignableFrom(newDefinition.getClass())) {
                throw new IllegalArgumentException("The provided definition of class " + newDefinition.getClass().getName() + " does not match existing definition of class " + itemDef.getClass().getName());
            }
            this.itemDefinitions.remove(itemDef);
            if (!itemDef.getName().equals(newDefinition.getName())) {
                newDefinition = newDefinition.clone();
                newDefinition.setName(propertyName);
            }
            this.itemDefinitions.add(newDefinition);
            return;
        }
        throw new IllegalArgumentException("The definition with name " + propertyName + " was not found in complex type " + this.getTypeName());
    }

    @Override
    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(this.toString());
        if (this.extensionForType != null) {
            sb.append(",ext:");
            sb.append(DebugUtil.prettyPrint((QName)this.extensionForType));
        }
        if (this.ignored) {
            sb.append(",ignored");
        }
        if (this.containerMarker) {
            sb.append(",Mc");
        }
        if (this.objectMarker) {
            sb.append(",Mo");
        }
        if (this.xsdAnyMarker) {
            sb.append(",Ma");
        }
        sb.append("\n");
        for (ItemDefinition def : this.getDefinitions()) {
            sb.append(def.debugDump(indent + 1));
        }
        return sb.toString();
    }

    @Override
    protected String getDebugDumpClassName() {
        return "CTD";
    }
}

