/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.cfg.TransactionListener;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionContext
implements TransactionContext {
    protected PlatformTransactionManager transactionManager;
    protected CommandContext commandContext;

    public SpringTransactionContext(PlatformTransactionManager transactionManager, CommandContext commandContext) {
        this.transactionManager = transactionManager;
        this.commandContext = commandContext;
    }

    public void commit() {
    }

    public void rollback() {
        this.transactionManager.getTransaction(null).setRollbackOnly();
    }

    public void addTransactionListener(TransactionState transactionState, final TransactionListener transactionListener) {
        if (transactionState.equals((Object)TransactionState.COMMITTING)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void beforeCommit(boolean readOnly) {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.COMMITTED)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCommit() {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.ROLLINGBACK)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void beforeCompletion() {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.ROLLED_BACK)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                public void afterCompletion(int status) {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        }
    }

    protected abstract class TransactionSynchronizationAdapter
    implements TransactionSynchronization {
        protected TransactionSynchronizationAdapter() {
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void flush() {
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
        }

        public void afterCommit() {
        }

        public void afterCompletion(int status) {
        }
    }
}

