/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.common.expression.jsr223;

import com.evolveum.midpoint.common.expression.ExpressionEvaluator;
import com.evolveum.midpoint.common.expression.MidPointFunctions;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.prism.xml.ns._public.types_2.PolyStringType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.xml.namespace.QName;
import org.w3c.dom.Element;

public class Jsr223ExpressionEvaluator
implements ExpressionEvaluator {
    private static final String LANGUAGE_URL_BASE = "http://midpoint.evolveum.com/xml/ns/public/expression/language#";
    private static final String FUNCTION_LIBRARY_VARIABLE_NAME = "func";
    private ScriptEngine scriptEngine;
    private PrismContext prismContext;

    public Jsr223ExpressionEvaluator(String engineName, PrismContext prismContext) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager();
        this.scriptEngine = scriptEngineManager.getEngineByName(engineName);
        if (this.scriptEngine == null) {
            throw new SystemException("The JSR-223 scripting engine for '" + engineName + "' was not found");
        }
        this.prismContext = prismContext;
    }

    @Override
    public <T> PrismPropertyValue<T> evaluateScalar(Class<T> type, Element code, Map<QName, Object> variables, ObjectResolver objectResolver, MidPointFunctions functionLibrary, String contextDescription, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        Object evalRawResult = this.evaluate(type, code, variables, objectResolver, functionLibrary, contextDescription, result);
        T evalResult = this.convertScalarResult(type, evalRawResult, contextDescription);
        PrismPropertyValue pval = new PrismPropertyValue(evalResult);
        return pval;
    }

    @Override
    public <T> List<PrismPropertyValue<T>> evaluateList(Class<T> expectedType, Element code, Map<QName, Object> variables, ObjectResolver objectResolver, MidPointFunctions functionLibrary, String contextDescription, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        Object evalRawResult = this.evaluate(expectedType, code, variables, objectResolver, functionLibrary, contextDescription, result);
        ArrayList<PrismPropertyValue<T>> pvals = new ArrayList<PrismPropertyValue<T>>();
        if (evalRawResult instanceof Collection) {
            for (Object evalRawResultElement : (Collection)evalRawResult) {
                T evalResult = this.convertScalarResult(expectedType, evalRawResultElement, contextDescription);
                PrismPropertyValue pval = new PrismPropertyValue(evalResult);
                pvals.add(pval);
            }
        } else {
            T evalResult = this.convertScalarResult(expectedType, evalRawResult, contextDescription);
            PrismPropertyValue pval = new PrismPropertyValue(evalResult);
            pvals.add(pval);
        }
        return pvals;
    }

    private <T> T convertScalarResult(Class<T> expectedType, Object rawValue, String contextDescription) throws ExpressionEvaluationException {
        if (rawValue == null || expectedType.isInstance(rawValue)) {
            return (T)rawValue;
        }
        if (expectedType.equals(PolyString.class) && rawValue instanceof String) {
            return (T)new PolyString((String)rawValue);
        }
        if (expectedType.equals(PolyStringType.class) && rawValue instanceof String) {
            PolyStringType polyStringType = new PolyStringType();
            polyStringType.setOrig((String)rawValue);
            return (T)polyStringType;
        }
        if (expectedType.equals(String.class) && rawValue instanceof PolyString) {
            return (T)((PolyString)rawValue).getOrig();
        }
        if (expectedType.equals(String.class) && rawValue instanceof PolyStringType) {
            return (T)((PolyStringType)rawValue).getOrig();
        }
        throw new ExpressionEvaluationException("Expected " + expectedType + " from expression, but got " + rawValue.getClass() + " " + contextDescription);
    }

    private <T> Object evaluate(Class<T> type, Element codeElement, Map<QName, Object> variables, ObjectResolver objectResolver, MidPointFunctions functionLibrary, String contextDescription, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        Bindings bindings = this.convertToBindings(variables, objectResolver, functionLibrary, contextDescription, result);
        String codeString = codeElement.getTextContent();
        try {
            return this.scriptEngine.eval(codeString, bindings);
        }
        catch (ScriptException e) {
            throw new ExpressionEvaluationException(String.valueOf(e.getMessage()) + " " + contextDescription, (Throwable)e);
        }
    }

    private Bindings convertToBindings(Map<QName, Object> variables, ObjectResolver objectResolver, MidPointFunctions functionLibrary, String contextDescription, OperationResult result) throws SchemaException, ObjectNotFoundException {
        Bindings bindings = this.scriptEngine.createBindings();
        bindings.put(FUNCTION_LIBRARY_VARIABLE_NAME, (Object)functionLibrary);
        for (Map.Entry<QName, Object> variableEntry : variables.entrySet()) {
            if (variableEntry.getKey() == null) continue;
            String variableName = variableEntry.getKey().getLocalPart();
            Object variableValue = this.convertVariableValue(variableEntry.getValue(), variableName, objectResolver, contextDescription, result);
            bindings.put(variableName, variableValue);
        }
        return bindings;
    }

    private Object convertVariableValue(Object originalValue, String variableName, ObjectResolver objectResolver, String contextDescription, OperationResult result) throws SchemaException, ObjectNotFoundException {
        if (originalValue instanceof ObjectReferenceType) {
            originalValue = this.resolveReference((ObjectReferenceType)originalValue, objectResolver, variableName, contextDescription, result);
        }
        if (originalValue instanceof PrismObject) {
            return ((PrismObject)originalValue).asObjectable();
        }
        if (originalValue instanceof PrismContainerValue) {
            return ((PrismContainerValue)originalValue).asContainerable();
        }
        if (originalValue instanceof PrismPropertyValue) {
            return ((PrismPropertyValue)originalValue).getValue();
        }
        return originalValue;
    }

    private Object resolveReference(ObjectReferenceType ref, ObjectResolver objectResolver, String name, String contextDescription, OperationResult result) throws SchemaException, ObjectNotFoundException {
        if (ref.getOid() == null) {
            throw new SchemaException("Null OID in reference in variable " + name + " in " + contextDescription);
        }
        try {
            return objectResolver.resolve(ref, ObjectType.class, contextDescription, result);
        }
        catch (ObjectNotFoundException e) {
            throw new ObjectNotFoundException("Object not found during variable " + name + " resolution in " + contextDescription + ": " + e.getMessage(), (Throwable)e, ref.getOid());
        }
        catch (SchemaException e) {
            throw new SchemaException("Schema error during variable " + name + " resolution in " + contextDescription + ": " + e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public String getLanguageName() {
        return this.scriptEngine.getFactory().getLanguageName();
    }

    @Override
    public String getLanguageUrl() {
        return LANGUAGE_URL_BASE + this.getLanguageName();
    }
}

