/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.impl;

import com.evolveum.midpoint.common.refinery.RefinedResourceSchema;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.schema.processor.ResourceSchema;
import com.evolveum.midpoint.schema.util.ResourceTypeUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.CachingMetadataType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.XmlSchemaType;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.w3c.dom.Element;

@Component
public class ResourceSchemaCache {
    private Map<String, ResourceSchemaCacheEntry> cache = new HashMap<String, ResourceSchemaCacheEntry>();
    @Autowired(required=true)
    private PrismContext prismContext;

    ResourceSchemaCache() {
    }

    public synchronized ResourceType put(ResourceType resourceType) throws SchemaException {
        Element xsdElement;
        if (resourceType.getSchema() == null) {
            return resourceType;
        }
        String oid = resourceType.getOid();
        if (oid == null) {
            return resourceType;
        }
        XmlSchemaType xmlSchemaType = resourceType.getSchema();
        String serial = null;
        if (xmlSchemaType.getCachingMetadata() != null) {
            serial = xmlSchemaType.getCachingMetadata().getSerialNumber();
        }
        if (serial == null) {
            return resourceType;
        }
        if (this.cache.containsKey(oid)) {
            ResourceSchemaCacheEntry entry = this.cache.get(oid);
            if (serial.equals(entry.serialNumber)) {
                RefinedResourceSchema.setParsedResourceSchemaConditional((ResourceType)resourceType, (ResourceSchema)entry.parsedSchema);
                return resourceType;
            }
            this.cache.remove(oid);
        }
        if ((xsdElement = ResourceTypeUtil.getResourceXsdSchema((ResourceType)resourceType)) == null) {
            throw new IllegalArgumentException("No resource schema in " + resourceType + ", cannot put in cache");
        }
        ResourceSchema parsedSchema = ResourceSchema.parse((Element)xsdElement, (String)resourceType.toString(), (PrismContext)this.prismContext);
        ResourceSchemaCacheEntry entry = new ResourceSchemaCacheEntry(serial, xsdElement, parsedSchema);
        this.cache.put(oid, entry);
        RefinedResourceSchema.setParsedResourceSchemaConditional((ResourceType)resourceType, (ResourceSchema)parsedSchema);
        return resourceType;
    }

    public synchronized ResourceType get(ResourceType resourceType) throws SchemaException {
        if (resourceType.getSchema() == null) {
            return resourceType;
        }
        String oid = resourceType.getOid();
        if (oid == null) {
            return resourceType;
        }
        XmlSchemaType xmlSchemaType = resourceType.getSchema();
        if (xmlSchemaType == null) {
            return resourceType;
        }
        ResourceSchemaCacheEntry entry = this.cache.get(oid);
        if (entry == null) {
            return this.put(resourceType);
        }
        CachingMetadataType cachingMetadata = xmlSchemaType.getCachingMetadata();
        if (cachingMetadata != null && cachingMetadata.getSerialNumber() != null && !cachingMetadata.getSerialNumber().equals(entry.serialNumber)) {
            return this.put(resourceType);
        }
        RefinedResourceSchema.setParsedResourceSchemaConditional((ResourceType)resourceType, (ResourceSchema)entry.parsedSchema);
        return resourceType;
    }

    private class ResourceSchemaCacheEntry {
        public String serialNumber;
        public Element xsdElement;
        public ResourceSchema parsedSchema;

        private ResourceSchemaCacheEntry(String serialNumber, Element xsdElement, ResourceSchema parsedSchema) {
            this.serialNumber = serialNumber;
            this.xsdElement = xsdElement;
            this.parsedSchema = parsedSchema;
        }
    }
}

