/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.impl;

import com.evolveum.midpoint.provisioning.api.ChangeNotificationDispatcher;
import com.evolveum.midpoint.provisioning.api.ResourceObjectChangeListener;
import com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription;
import com.evolveum.midpoint.provisioning.impl.ChangeNotificationDispatcherImpl$AjcClosure1;
import com.evolveum.midpoint.provisioning.impl.ChangeNotificationDispatcherImpl$AjcClosure3;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.util.aspect.MidpointAspect;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.Validate;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.springframework.stereotype.Component;

@Component
public class ChangeNotificationDispatcherImpl
implements ChangeNotificationDispatcher {
    private List<ResourceObjectChangeListener> listeners = new ArrayList<ResourceObjectChangeListener>();
    private static final Trace LOGGER;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        ChangeNotificationDispatcherImpl.ajc$preClinit();
        LOGGER = TraceManager.getTrace(ChangeNotificationDispatcherImpl.class);
    }

    public synchronized void registerNotificationListener(ResourceObjectChangeListener listener) {
        if (this.listeners.contains(listener)) {
            LOGGER.warn("Resource object change listener '{}' is already registered. Subsequent registration is ignored", (Object)listener);
        } else {
            this.listeners.add(listener);
        }
    }

    public synchronized void unregisterNotificationListener(ResourceObjectChangeListener listener) {
        this.listeners.remove(listener);
    }

    public void notifyChange(ResourceObjectShadowChangeDescription change, Task task, OperationResult parentResult) {
        ResourceObjectShadowChangeDescription resourceObjectShadowChangeDescription = change;
        Task task2 = task;
        OperationResult operationResult = parentResult;
        Object[] objectArray = new Object[]{resourceObjectShadowChangeDescription, task2, operationResult};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, resourceObjectShadowChangeDescription, task2, operationResult, joinPoint};
        MidpointAspect.aspectOf().processResourceObjectChangeListenerNdc(new ChangeNotificationDispatcherImpl$AjcClosure1(objectArray2).linkClosureAndJoinPoint(69648));
    }

    public String getName() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)MidpointAspect.aspectOf().processResourceObjectChangeListenerNdc(new ChangeNotificationDispatcherImpl$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ void notifyChange_aroundBody0(ChangeNotificationDispatcherImpl ajc$this, ResourceObjectShadowChangeDescription change, Task task, OperationResult parentResult, JoinPoint joinPoint) {
        Validate.notNull((Object)change, (String)"Change description of resource object shadow must not be null.");
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("SYNCHRONIZATION change notification\n{} ", (Object)change.dump());
        }
        change.checkConsistence();
        if (ajc$this.listeners != null && !ajc$this.listeners.isEmpty()) {
            for (ResourceObjectChangeListener listener : ajc$this.listeners) {
                try {
                    listener.notifyChange(change, task, parentResult);
                }
                catch (RuntimeException e) {
                    LOGGER.error("Exception {} thrown by object change listener {}: {}", new Object[]{e.getClass(), listener.getName(), e.getMessage(), e});
                }
            }
        } else {
            LOGGER.warn("Change notification received but listener list is empty, there is nobody to get the message");
        }
    }

    static final /* synthetic */ String getName_aroundBody2(ChangeNotificationDispatcherImpl ajc$this, JoinPoint joinPoint) {
        return "object change notification dispatcher";
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("ChangeNotificationDispatcherImpl.java", ChangeNotificationDispatcherImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "notifyChange", "com.evolveum.midpoint.provisioning.impl.ChangeNotificationDispatcherImpl", "com.evolveum.midpoint.provisioning.api.ResourceObjectShadowChangeDescription:com.evolveum.midpoint.task.api.Task:com.evolveum.midpoint.schema.result.OperationResult", "change:task:parentResult", "", "void"), 77);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getName", "com.evolveum.midpoint.provisioning.impl.ChangeNotificationDispatcherImpl", "", "", "", "java.lang.String"), 105);
    }
}

