/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.consistency.impl;

import com.evolveum.midpoint.provisioning.api.GenericConnectorException;
import com.evolveum.midpoint.provisioning.consistency.api.ErrorHandler;
import com.evolveum.midpoint.provisioning.consistency.impl.CommunicationExceptionHandler;
import com.evolveum.midpoint.provisioning.consistency.impl.ConfigurationExceptionHandler;
import com.evolveum.midpoint.provisioning.consistency.impl.GenericErrorHandler;
import com.evolveum.midpoint.provisioning.consistency.impl.ObjectAlreadyExistHandler;
import com.evolveum.midpoint.provisioning.consistency.impl.ObjectNotFoundHandler;
import com.evolveum.midpoint.provisioning.consistency.impl.SchemaExceptionHandler;
import com.evolveum.midpoint.provisioning.consistency.impl.SecurityViolationHandler;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SecurityViolationException;
import com.evolveum.midpoint.util.exception.SystemException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ErrorHandlerFactory {
    @Autowired(required=true)
    CommunicationExceptionHandler communicationExceptionHandler;
    @Autowired(required=true)
    SchemaExceptionHandler schemaExceptionHandler;
    @Autowired(required=true)
    ObjectNotFoundHandler objectNotFoundHandler;
    @Autowired(required=true)
    ObjectAlreadyExistHandler objectAlreadyExistsHandler;
    @Autowired(required=true)
    GenericErrorHandler genericErrorHandler;
    @Autowired(required=true)
    ConfigurationExceptionHandler configurationExceptionHandler;
    @Autowired(required=true)
    SecurityViolationHandler securityViolationHandler;

    public ErrorHandler createErrorHandler(Exception ex) {
        if (ex instanceof CommunicationException) {
            return this.communicationExceptionHandler;
        }
        if (ex instanceof GenericConnectorException) {
            return this.genericErrorHandler;
        }
        if (ex instanceof ObjectAlreadyExistsException) {
            return this.objectAlreadyExistsHandler;
        }
        if (ex instanceof ObjectNotFoundException) {
            return this.objectNotFoundHandler;
        }
        if (ex instanceof SchemaException) {
            return this.schemaExceptionHandler;
        }
        if (ex instanceof ConfigurationException) {
            return this.configurationExceptionHandler;
        }
        if (ex instanceof SecurityViolationException) {
            return this.securityViolationHandler;
        }
        throw new SystemException("Unknown error occurred: " + ex.getMessage(), (Throwable)ex);
    }
}

