/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.test.common;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class PropertyBag {
    private final Map<String, Object> bag;

    PropertyBag(Map<String, Object> bag) {
        this.bag = new HashMap<String, Object>(bag);
    }

    public <T> T getProperty(String name, Class<T> type) {
        if (!this.bag.containsKey(name)) {
            throw new IllegalArgumentException(MessageFormat.format("Property named \"{0}\" not found in bag", name));
        }
        return this.castValue(name, type);
    }

    private <T> T castValue(String name, Class<T> type) {
        Object value = this.bag.get(name);
        if (value == null) {
            return null;
        }
        if (!type.isInstance(value)) {
            throw new ClassCastException(MessageFormat.format("Property named \"{0}\" is of type \"{1}\" but expected type was \"{2}\"", name, value.getClass(), type));
        }
        return type.cast(value);
    }

    public <T> T getProperty(String name, Class<T> type, T def) {
        if (!this.bag.containsKey(name)) {
            return def;
        }
        return this.castValue(name, type);
    }

    public String getStringProperty(String name) {
        return this.getProperty(name, String.class);
    }

    public String toString() {
        return this.bag.toString();
    }

    Map<String, Object> toMap() {
        return this.bag;
    }
}

