/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.task.quartzimpl;

import com.evolveum.midpoint.task.api.Task;
import com.evolveum.midpoint.task.api.TaskExecutionStatus;
import com.evolveum.midpoint.task.quartzimpl.execution.JobExecutor;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.MisfireActionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ScheduleType;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.TriggerKey;

public class TaskQuartzImplUtil {
    private static final transient Trace LOGGER = TraceManager.getTrace(TaskQuartzImplUtil.class);
    public static final long SINGLE_TASK_CHECK_INTERVAL = 10000L;

    public static JobKey createJobKeyForTask(Task t) {
        return new JobKey(t.getOid());
    }

    public static JobKey createJobKeyForTaskOid(String oid) {
        return new JobKey(oid);
    }

    public static TriggerKey createTriggerKeyForTask(Task t) {
        return new TriggerKey(t.getOid());
    }

    public static TriggerKey createTriggerKeyForTaskOid(String oid) {
        return new TriggerKey(oid);
    }

    public static JobDetail createJobDetailForTask(Task task) {
        JobDetail job = JobBuilder.newJob(JobExecutor.class).withIdentity(TaskQuartzImplUtil.createJobKeyForTask(task)).storeDurably().requestRecovery().build();
        return job;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Trigger createTriggerForTask(Task task) throws ParseException {
        boolean looselyBoundRecurrent;
        if (task.getExecutionStatus() != TaskExecutionStatus.RUNNABLE) {
            return null;
        }
        TriggerBuilder tb = TriggerBuilder.newTrigger().withIdentity(TaskQuartzImplUtil.createTriggerKeyForTask(task)).forJob(TaskQuartzImplUtil.createJobKeyForTask(task));
        if (task.getSchedule() != null) {
            Date lst;
            Date est = task.getSchedule().getEarliestStartTime() != null ? task.getSchedule().getEarliestStartTime().toGregorianCalendar().getTime() : null;
            Date date = lst = task.getSchedule().getLatestStartTime() != null ? task.getSchedule().getLatestStartTime().toGregorianCalendar().getTime() : null;
            if (lst != null && est == null && lst.getTime() < System.currentTimeMillis()) {
                est = lst;
            }
            if (est != null) {
                tb.startAt(est);
            } else {
                tb.startNow();
            }
            if (lst != null) {
                tb.endAt(lst);
            }
            if (task.getSchedule().getLatestFinishTime() != null) {
                tb.endAt(task.getSchedule().getLatestFinishTime().toGregorianCalendar().getTime());
            }
        }
        if (task.isCycle() && task.isLooselyBound()) {
            SimpleScheduleBuilder sb;
            looselyBoundRecurrent = true;
            ScheduleType sch = task.getSchedule();
            if (sch == null) {
                throw new IllegalStateException("Recurrent task " + task + " does not have a schedule.");
            }
            if (sch.getInterval() != null) {
                SimpleScheduleBuilder ssb = SimpleScheduleBuilder.simpleSchedule().withIntervalInSeconds(sch.getInterval().intValue()).repeatForever();
                if (sch.getMisfireAction() == null || sch.getMisfireAction() == MisfireActionType.EXECUTE_IMMEDIATELY) {
                    sb = ssb.withMisfireHandlingInstructionFireNow();
                } else {
                    if (sch.getMisfireAction() != MisfireActionType.RESCHEDULE) throw new SystemException("Invalid value of misfireAction: " + sch.getMisfireAction() + " for task " + task);
                    sb = ssb.withMisfireHandlingInstructionNextWithRemainingCount();
                }
            } else {
                if (sch.getCronLikePattern() == null) throw new IllegalStateException("The schedule for task " + task + " is neither fixed nor cron-like one.");
                CronScheduleBuilder csb = CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)sch.getCronLikePattern());
                if (sch.getMisfireAction() == null || sch.getMisfireAction() == MisfireActionType.EXECUTE_IMMEDIATELY) {
                    sb = csb.withMisfireHandlingInstructionFireAndProceed();
                } else {
                    if (sch.getMisfireAction() != MisfireActionType.RESCHEDULE) throw new SystemException("Invalid value of misfireAction: " + sch.getMisfireAction() + " for task " + task);
                    sb = csb.withMisfireHandlingInstructionDoNothing();
                }
            }
            tb.withSchedule((ScheduleBuilder)sb);
        } else {
            looselyBoundRecurrent = false;
        }
        tb.usingJobData("schedule", TaskQuartzImplUtil.scheduleFingerprint(task.getSchedule()));
        tb.usingJobData("looselyBoundRecurrent", Boolean.valueOf(looselyBoundRecurrent));
        return tb.build();
    }

    public static Trigger createTriggerNowForTask(Task task) {
        TriggerBuilder tb = TriggerBuilder.newTrigger().forJob(TaskQuartzImplUtil.createJobKeyForTask(task)).startNow();
        return tb.build();
    }

    private static long xmlGCtoMillis(XMLGregorianCalendar gc) {
        return gc != null ? gc.toGregorianCalendar().getTimeInMillis() : 0L;
    }

    private static String scheduleFingerprint(ScheduleType scheduleType) {
        if (scheduleType == null) {
            return "";
        }
        return scheduleType.getInterval() + " $$ " + scheduleType.getCronLikePattern() + " $$ " + TaskQuartzImplUtil.xmlGCtoMillis(scheduleType.getEarliestStartTime()) + " $$ " + TaskQuartzImplUtil.xmlGCtoMillis(scheduleType.getLatestStartTime()) + " $$ " + TaskQuartzImplUtil.xmlGCtoMillis(scheduleType.getLatestFinishTime()) + " $$ " + scheduleType.getMisfireAction() + " $$";
    }

    public static boolean triggerDataMapsDiffer(Trigger triggerAsIs, Trigger triggerToBe) {
        JobDataMap asIs = triggerAsIs.getJobDataMap();
        JobDataMap toBe = triggerToBe.getJobDataMap();
        boolean scheduleDiffer = !toBe.getString("schedule").equals(asIs.getString("schedule"));
        boolean lbrDiffer = toBe.getBoolean("looselyBoundRecurrent") ^ asIs.getBoolean("looselyBoundRecurrent");
        if (scheduleDiffer) {
            LOGGER.trace("trigger data maps differ in schedule: triggerAsIs.schedule = " + asIs.getString("schedule") + ", triggerToBe.schedule = " + toBe.getString("schedule"));
        }
        if (lbrDiffer) {
            LOGGER.trace("trigger data maps differ in looselyBoundRecurrent: triggerAsIs = " + asIs.getString("looselyBoundRecurrent") + ", triggerToBe = " + toBe.getString("looselyBoundRecurrent"));
        }
        return scheduleDiffer || lbrDiffer;
    }

    public static List<String> tasksToOperationResult(Collection<Task> tasks) {
        ArrayList<String> retval = new ArrayList<String>();
        for (Task t : tasks) {
            retval.add(String.valueOf(t.getOid()) + ": " + t.getName());
        }
        return retval;
    }

    public static ParseException validateCronExpression(String cron) {
        try {
            CronScheduleBuilder.cronScheduleNonvalidatedExpression((String)cron);
            return null;
        }
        catch (ParseException pe) {
            return pe;
        }
    }
}

