/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.filter;

import com.evolveum.midpoint.model.filter.AbstractFilter;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.text.Normalizer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

public class DiacriticsFilter
extends AbstractFilter {
    private static final Trace LOGGER = TraceManager.getTrace(DiacriticsFilter.class);

    @Override
    public <T> PrismPropertyValue<T> apply(PrismPropertyValue<T> propertyValue) {
        Validate.notNull(propertyValue, (String)"Node must not be null.");
        String text = this.getStringValue(propertyValue);
        if (StringUtils.isEmpty((String)text)) {
            return propertyValue;
        }
        String newValue = Normalizer.normalize(text, Normalizer.Form.NFD).replaceAll("\\p{InCombiningDiacriticalMarks}+", "");
        propertyValue.setValue((Object)newValue);
        return propertyValue;
    }
}

