/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.navigation.paging;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.list.Loop;
import org.apache.wicket.markup.html.list.LoopItem;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.IPagingLabelProvider;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigationLink;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.collections.MicroMap;

public class PagingNavigation
extends Loop {
    private static final long serialVersionUID = 1L;
    protected IPageable pageable;
    protected IPagingLabelProvider labelProvider;
    private int startIndex;
    private int margin = -1;
    private String separator = null;
    private int viewSize = 10;

    public PagingNavigation(String id, IPageable pageable) {
        this(id, pageable, null);
    }

    public PagingNavigation(String id, IPageable pageable, IPagingLabelProvider labelProvider) {
        super(id, (IModel<Integer>)null);
        this.pageable = pageable;
        this.labelProvider = labelProvider;
        this.startIndex = 0;
    }

    public int getMargin() {
        if (this.margin == -1 && this.viewSize != 0) {
            return this.viewSize / 2;
        }
        return this.margin;
    }

    public String getSeparator() {
        return this.separator;
    }

    public int getViewSize() {
        return this.viewSize;
    }

    public void setViewSize(int size) {
        this.viewSize = size;
    }

    public void setMargin(int margin) {
        this.margin = margin;
    }

    public void setSeparator(String separator) {
        this.separator = separator;
    }

    protected void onBeforeRender() {
        this.setDefaultModel(new Model<Integer>(this.pageable.getPageCount()));
        this.setStartIndex();
        super.onBeforeRender();
    }

    protected final int getStartIndex() {
        return this.startIndex;
    }

    protected void populateItem(LoopItem loopItem) {
        int pageIndex = this.getStartIndex() + loopItem.getIndex();
        AbstractLink link = this.newPagingNavigationLink("pageLink", this.pageable, pageIndex);
        link.add(new TitleAppender(pageIndex));
        loopItem.add(link);
        String label = "";
        label = this.labelProvider != null ? this.labelProvider.getPageLabel(pageIndex) : String.valueOf(pageIndex + 1);
        link.add(new Label("pageNumber", label));
    }

    protected AbstractLink newPagingNavigationLink(String id, IPageable pageable, int pageIndex) {
        return new PagingNavigationLink(id, pageable, pageIndex);
    }

    protected void renderItem(LoopItem loopItem) {
        super.renderItem(loopItem);
        if (this.separator != null && loopItem.getIndex() != this.getIterations() - 1) {
            this.getResponse().write((CharSequence)this.separator);
        }
    }

    private void setStartIndex() {
        int firstListItem = this.startIndex;
        int viewSize = Math.min(this.getViewSize(), this.pageable.getPageCount());
        int margin = this.getMargin();
        int currentPage = this.pageable.getCurrentPage();
        if (currentPage < firstListItem + margin) {
            firstListItem = currentPage - margin;
        } else if (currentPage >= firstListItem + viewSize - margin) {
            firstListItem = currentPage + margin + 1 - viewSize;
        }
        if (firstListItem + viewSize >= this.pageable.getPageCount()) {
            firstListItem = this.pageable.getPageCount() - viewSize;
        }
        if (firstListItem < 0) {
            firstListItem = 0;
        }
        if (viewSize != this.getIterations() || this.startIndex != firstListItem) {
            this.modelChanging();
            this.addStateChange();
            this.startIndex = firstListItem;
            this.setIterations(Math.min(viewSize, this.pageable.getPageCount()));
            this.modelChanged();
            this.removeAll();
        }
    }

    private void setIterations(int i) {
        this.setDefaultModelObject(i);
    }

    private final class TitleAppender
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private static final String RES = "PagingNavigation.page";
        private final int page;

        public TitleAppender(int page) {
            this.page = page;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            MicroMap vars = new MicroMap((Object)"page", (Object)String.valueOf(this.page + 1));
            tag.put("title", PagingNavigation.this.getString(RES, Model.ofMap(vars)));
        }
    }
}

