/*
 * Decompiled with CFR 0.152.
 */
package org.basex.server;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.basex.core.Context;
import org.basex.core.Prop;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.Util;

public final class Log {
    private static final DateFormat DATE = new SimpleDateFormat("yyyy-MM-dd");
    private static final DateFormat TIME = new SimpleDateFormat("HH:mm:ss.SSS");
    private final boolean quiet;
    private final File dir;
    private String start;
    private FileOutputStream fos;

    public Log(Context ctx, boolean q) {
        this.dir = ctx.mprop.dbpath(".logs");
        this.quiet = q;
        if (!q) {
            this.create(new Date());
        }
    }

    public synchronized void write(Object ... str) {
        if (this.quiet) {
            return;
        }
        Date now = new Date();
        if (!this.start.equals(DATE.format(now))) {
            this.close();
            this.create(now);
        }
        TokenBuilder tb = new TokenBuilder(TIME.format(now));
        Object[] objectArray = str;
        int n = str.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            tb.add(9);
            tb.add(Token.chop(Token.token(s.toString().replaceAll("[\\r\\n ]+", " ")), 1000));
            ++n2;
        }
        tb.add(Prop.NL);
        try {
            this.fos.write(tb.finish());
            this.fos.flush();
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    private synchronized void create(Date d) {
        this.dir.mkdirs();
        this.start = DATE.format(d);
        try {
            this.fos = new FileOutputStream(new File(this.dir, String.valueOf(this.start) + ".log"), true);
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }

    public synchronized void close() {
        if (this.quiet) {
            return;
        }
        try {
            this.fos.close();
        }
        catch (IOException ex) {
            Util.stack(ex);
        }
    }
}

