/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.ft;

import java.io.IOException;
import org.basex.data.FTMatch;
import org.basex.data.FTStringMatch;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.expr.Expr;
import org.basex.query.ft.FTExpr;
import org.basex.query.ft.FTFilter;
import org.basex.query.util.Var;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.ft.FTLexer;
import org.basex.util.ft.FTUnit;

public final class FTDistance
extends FTFilter {
    private final Expr[] dist;

    public FTDistance(InputInfo ii, FTExpr e, Expr[] d, FTUnit u) {
        super(ii, e);
        this.dist = d;
        this.unit = u;
    }

    @Override
    public FTExpr comp(QueryContext ctx) throws QueryException {
        int d = 0;
        while (d != this.dist.length) {
            this.dist[d] = this.dist[d].comp(ctx);
            ++d;
        }
        return super.comp(ctx);
    }

    @Override
    protected boolean filter(QueryContext ctx, FTMatch mtc, FTLexer lex) throws QueryException {
        long min = this.checkItr(this.dist[0], ctx);
        long max = this.checkItr(this.dist[1], ctx);
        mtc.sort();
        FTMatch match = new FTMatch();
        FTStringMatch sm = null;
        FTStringMatch f = null;
        for (FTStringMatch m : mtc) {
            if (m.ex) {
                match.add(m);
                continue;
            }
            if (sm != null) {
                int d = this.pos(m.s, lex) - this.pos(sm.e, lex) - 1;
                if ((long)d < min || (long)d > max) {
                    return false;
                }
            } else {
                f = m;
            }
            sm = m;
        }
        f.e = sm.e;
        mtc.reset();
        mtc.add(f);
        mtc.add(match);
        return true;
    }

    @Override
    public boolean uses(Expr.Use u) {
        Expr[] exprArray = this.dist;
        int n = this.dist.length;
        int n2 = 0;
        while (n2 < n) {
            Expr d = exprArray[n2];
            if (d.uses(u)) {
                return true;
            }
            ++n2;
        }
        return super.uses(u);
    }

    @Override
    public int count(Var v) {
        int c = 0;
        Expr[] exprArray = this.dist;
        int n = this.dist.length;
        int n2 = 0;
        while (n2 < n) {
            Expr d = exprArray[n2];
            c += d.count(v);
            ++n2;
        }
        return c + super.count(v);
    }

    @Override
    public boolean removable(Var v) {
        Expr[] exprArray = this.dist;
        int n = this.dist.length;
        int n2 = 0;
        while (n2 < n) {
            Expr d = exprArray[n2];
            if (!d.removable(v)) {
                return false;
            }
            ++n2;
        }
        return super.removable(v);
    }

    @Override
    public FTExpr remove(Var v) {
        int d = 0;
        while (d != this.dist.length) {
            this.dist[d] = this.dist[d].remove(v);
            ++d;
        }
        return super.remove(v);
    }

    @Override
    public void plan(Serializer ser) throws IOException {
        ser.openElement(this, (byte[][])new byte[][]{Token.token("distance"), Token.token(this.dist[0] + "-" + this.dist[1] + " " + (Object)((Object)this.unit))});
        super.plan(ser);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "distance" + "(" + this.dist[0] + "-" + this.dist[1] + " " + (Object)((Object)this.unit) + ")";
    }
}

