/*
 * Decompiled with CFR 0.152.
 */
package org.basex.index.ft;

import java.io.IOException;
import org.basex.data.Data;
import org.basex.data.MetaData;
import org.basex.index.ft.FTBuilder;
import org.basex.index.ft.FTIndex;
import org.basex.index.ft.FTList;
import org.basex.index.ft.FTTrie;
import org.basex.index.ft.FTTrieArray;
import org.basex.index.ft.FTTrieHash;
import org.basex.index.ft.FTTrieList;
import org.basex.io.out.DataOutput;
import org.basex.io.random.DataAccess;
import org.basex.util.Token;
import org.basex.util.list.IntArrayList;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

final class FTTrieBuilder
extends FTBuilder {
    private FTTrieArray index = new FTTrieArray(128);
    private FTTrieHash hash = new FTTrieHash();
    private int offset;

    protected FTTrieBuilder(Data d) throws IOException {
        super(d);
    }

    @Override
    public FTIndex build() throws IOException {
        this.index();
        return new FTTrie(this.data);
    }

    @Override
    void index(byte[] tok) {
        this.hash.index(tok, this.pre, this.pos);
    }

    @Override
    int nrTokens() {
        return this.hash.size();
    }

    @Override
    void calcFreq() {
        this.hash.init();
        while (this.hash.more()) {
            this.calcFreq(this.hash.pre[this.hash.next()]);
        }
    }

    @Override
    public void write() throws IOException {
        if (!this.merge) {
            this.writeAll();
            return;
        }
        this.writeIndex(this.csize++);
        DataOutput outB = new DataOutput(this.data.meta.dbfile("ftxb"));
        DataOutput outT = new DataOutput(this.data.meta.dbfile("ftxt"));
        IntList ind = new IntList();
        FTList[] v = new FTList[this.csize];
        int b = 0;
        while (b < this.csize) {
            v[b] = new FTTrieList(this.data, b);
            ++b;
        }
        IntList il = new IntList();
        while (this.check(v)) {
            int min = 0;
            il.reset();
            il.add(min);
            int i = 0;
            while (i < this.csize) {
                if (min != i && v[i].tok.length != 0) {
                    int d = Token.diff(v[min].tok, v[i].tok);
                    if (d > 0 || v[min].tok.length == 0) {
                        min = i;
                        il.reset();
                        il.add(min);
                    } else if (d == 0 && v[i].tok.length > 0) {
                        il.add(i);
                    }
                }
                ++i;
            }
            if (ind.size() == 0 || ind.get(ind.size() - 1) != v[min].tok[0]) {
                ind.add(v[min].tok[0]);
            }
            outT.writeToken(v[min].tok);
            outT.write4(this.merge(outB, il, v));
            outT.write5(outB.size());
        }
        outT.writeToken(Token.EMPTY);
        outT.close();
        outB.close();
        this.writeSplitTrie(ind);
    }

    private void writeAll() throws IOException {
        if (this.scm == 0) {
            this.hash.init();
        } else {
            this.hash.initIter();
        }
        DataOutput outB = new DataOutput(this.data.meta.dbfile("ftxb"));
        while (this.hash.more()) {
            int p = this.hash.next();
            byte[] tok = this.hash.key();
            int ds = this.hash.sizes[p];
            long cpre = outB.size();
            this.writeFTData(outB, this.hash.pre[p], this.hash.pos[p]);
            this.index.insertSorted(tok, ds, cpre);
        }
        outB.close();
        this.hash = null;
        TokenList tokens = this.index.tokens;
        IntArrayList next = this.index.next;
        DataOutput outA = new DataOutput(this.data.meta.dbfile("ftxa"));
        DataOutput outC = new DataOutput(this.data.meta.dbfile("ftxc"));
        outA.write1(1);
        outA.write1(0);
        int[] root = next.get(0);
        int js = root.length - 2;
        int j = 1;
        while (j < js) {
            int p = root[j];
            outA.write4(p);
            outA.write1(tokens.get(next.get(p)[0])[0]);
            ++j;
        }
        outA.write4(root[root.length - 2]);
        outA.write5(0L);
        outC.write4(0);
        this.writeSubTree(null, outA, outC, 0, (root.length - 3) * 5 + 11);
        outC.write4(0);
        outA.close();
        outC.close();
    }

    private void writeSplitTrie(IntList roots) throws IOException {
        byte[] tok;
        MetaData md = this.data.meta;
        DataOutput outA = new DataOutput(md.dbfile("ftxa"));
        DataOutput outC = new DataOutput(md.dbfile("ftxc"));
        DataAccess outT = new DataAccess(md.dbfile("ftxt"));
        int[] root = new int[roots.size()];
        int rp = 0;
        outA.write1(1);
        outA.write1(0);
        int j = 0;
        while (j < roots.size()) {
            outA.write4(0);
            outA.write1(roots.get(j));
            ++j;
        }
        outA.write4(0);
        outA.write5(0L);
        outC.write4(0);
        int siz = (int)(2L + (long)roots.size() * 5L + 9L);
        while ((tok = outT.readToken()).length != 0) {
            int s = outT.read4();
            long off = outT.read5();
            if (rp < roots.size() && tok[0] != roots.get(rp)) {
                siz = this.writeSubTree(root, outA, outC, rp, siz);
                ++rp;
                this.index = new FTTrieArray(128);
            }
            this.index.insertSorted(tok, s, off);
        }
        this.writeSubTree(root, outA, outC, rp, siz);
        outT.close();
        outA.close();
        outC.write4(0);
        outC.close();
        DataAccess tmp = new DataAccess(md.dbfile("ftxa"));
        long c = 2L;
        int[] nArray = root;
        int n = root.length;
        int n2 = 0;
        while (n2 < n) {
            int r = nArray[n2];
            tmp.writeInt(c, r);
            c += 5L;
            ++n2;
        }
        tmp.close();
        md.drop("ftxt");
    }

    private int writeSubTree(int[] root, DataOutput outA, DataOutput outC, int rp, int siz) throws IOException {
        TokenList tokens = this.index.tokens;
        IntArrayList next = this.index.next;
        if (root != null) {
            root[rp] = next.get(0)[1] + this.offset;
        }
        int s = siz;
        int il = next.size();
        int i = 1;
        while (i < il) {
            int[] nxt = next.get(i);
            int lp = nxt[nxt.length - 1] >= 0 ? 0 : -1;
            outA.write1(tokens.get(nxt[0]).length);
            outA.writeBytes(tokens.get(nxt[0]));
            int jl = nxt.length - 2 + lp;
            int j = 1;
            while (j < jl) {
                outA.write4(nxt[j] + this.offset);
                outA.write1(tokens.get(next.get(nxt[j])[0])[0]);
                ++j;
            }
            outA.write4(nxt[jl]);
            if (lp == 0 || nxt[jl] == 0 && nxt[jl + 1] == 0) {
                outA.write5(nxt[jl + 1]);
            } else {
                int n = nxt.length - 2;
                outA.write5((long)nxt[n] << 16 + (-nxt[n + 1] & 0xFFFF));
            }
            outC.write4(s);
            s += tokens.get(nxt[0]).length + (nxt.length - 3 + lp) * 5 + 10;
            ++i;
        }
        this.offset += next.size() - 1;
        return s;
    }

    @Override
    protected void writeIndex(int cs) throws IOException {
        String f = "ftx" + (this.merge ? Integer.valueOf(cs) : "");
        DataOutput outA = new DataOutput(this.data.meta.dbfile(String.valueOf(f) + 'a'));
        DataOutput outB = new DataOutput(this.data.meta.dbfile(String.valueOf(f) + 'b'));
        if (this.scm == 0) {
            this.hash.init();
        } else {
            this.hash.initIter();
        }
        while (this.hash.more()) {
            int p = this.hash.next();
            byte[] t = this.hash.key();
            int s = this.hash.sizes[p];
            this.writeFTData(outB, this.hash.pre[p], this.hash.pos[p]);
            outA.write1(t.length);
            outA.writeBytes(t);
            outA.write4(s);
            outA.write5(outB.size());
        }
        outA.write1(0);
        outA.close();
        outB.close();
        this.hash = new FTTrieHash();
    }
}

