/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.core.cmd.AInfo;
import org.basex.data.Data;
import org.basex.index.IndexToken;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class InfoIndex
extends AInfo {
    public InfoIndex() {
        this(null);
    }

    public InfoIndex(Object type) {
        super(513, type != null && type != Commands.CmdIndexInfo.NULL ? type.toString() : null);
    }

    @Override
    protected boolean run() throws IOException {
        Data data = this.context.data;
        if (this.args[0] != null) {
            Commands.CmdIndexInfo ci = this.getOption(Commands.CmdIndexInfo.class);
            if (ci == null) {
                return this.error(Text.CMDUNKNOWN, this);
            }
            byte[] inf = InfoIndex.info(ci, data);
            this.out.print(inf);
            return inf.length != 0;
        }
        TokenBuilder tb = new TokenBuilder();
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.TAG, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.ATTNAME, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.TEXT, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.ATTRIBUTE, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.FULLTEXT, data));
        tb.add(InfoIndex.info(Commands.CmdIndexInfo.PATH, data));
        this.out.print(tb.finish());
        return true;
    }

    public static Commands.CmdIndexInfo info(String index) {
        return InfoIndex.getOption(index, Commands.CmdIndexInfo.class);
    }

    public static byte[] info(Commands.CmdIndexInfo idx, Data data) {
        switch (idx) {
            case TAG: {
                return InfoIndex.info(Text.INFOTAGS, IndexToken.IndexType.TAG, data, true);
            }
            case ATTNAME: {
                return InfoIndex.info(Text.INFOATTS, IndexToken.IndexType.ATTNAME, data, true);
            }
            case TEXT: {
                return InfoIndex.info(Text.INFOTEXTINDEX, IndexToken.IndexType.TEXT, data, data.meta.textindex);
            }
            case ATTRIBUTE: {
                return InfoIndex.info(Text.INFOATTRINDEX, IndexToken.IndexType.ATTRIBUTE, data, data.meta.attrindex);
            }
            case FULLTEXT: {
                return InfoIndex.info(Text.INFOFTINDEX, IndexToken.IndexType.FULLTEXT, data, data.meta.ftindex);
            }
            case PATH: {
                return InfoIndex.info(Text.INFOPATHINDEX, IndexToken.IndexType.PATH, data, data.meta.pathindex);
            }
        }
        return Token.token("- " + Text.INDNOTAVL);
    }

    private static byte[] info(String ds, IndexToken.IndexType it, Data data, boolean avl) {
        TokenBuilder tb = new TokenBuilder(ds).add(Text.NL);
        if (avl) {
            tb.add(data.info(it));
        } else {
            tb.addExt("- " + Text.INDNOTAVL, new Object[]{it});
        }
        return tb.add(Text.NL).finish();
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init((Object)((Object)Commands.Cmd.INFO) + " " + (Object)((Object)Commands.CmdInfo.INDEX)).args();
    }
}

