/*
 * Decompiled with CFR 0.152.
 */
package org.basex.api.xqj;

import java.net.URI;
import javax.xml.namespace.QName;
import javax.xml.xquery.XQItemType;
import org.basex.api.xqj.BXQException;
import org.basex.query.QueryText;
import org.basex.query.item.AtomType;
import org.basex.query.item.NodeType;
import org.basex.query.item.Type;
import org.basex.util.Token;

final class BXQItemType
implements XQItemType {
    private static final Type[] BASE;
    static final BXQItemType DEFAULT;
    private final QName name;
    private final int base;
    private final int occ;
    private final Type type;

    static {
        Type[] typeArray = new Type[52];
        typeArray[4] = AtomType.AAT;
        typeArray[5] = AtomType.ATM;
        typeArray[6] = AtomType.DTD;
        typeArray[7] = AtomType.YMD;
        typeArray[8] = AtomType.URI;
        typeArray[9] = AtomType.B64;
        typeArray[10] = AtomType.BLN;
        typeArray[11] = AtomType.DAT;
        typeArray[12] = AtomType.INT;
        typeArray[13] = AtomType.ITR;
        typeArray[14] = AtomType.SHR;
        typeArray[15] = AtomType.LNG;
        typeArray[16] = AtomType.DTM;
        typeArray[17] = AtomType.DEC;
        typeArray[18] = AtomType.DBL;
        typeArray[19] = AtomType.DUR;
        typeArray[20] = AtomType.FLT;
        typeArray[21] = AtomType.DAY;
        typeArray[22] = AtomType.MON;
        typeArray[23] = AtomType.MDA;
        typeArray[24] = AtomType.YEA;
        typeArray[25] = AtomType.YMO;
        typeArray[26] = AtomType.HEX;
        typeArray[27] = AtomType.NOT;
        typeArray[28] = AtomType.QNM;
        typeArray[29] = AtomType.STR;
        typeArray[30] = AtomType.TIM;
        typeArray[31] = AtomType.BYT;
        typeArray[32] = AtomType.NPI;
        typeArray[33] = AtomType.NNI;
        typeArray[34] = AtomType.NIN;
        typeArray[35] = AtomType.PIN;
        typeArray[36] = AtomType.ULN;
        typeArray[37] = AtomType.UIN;
        typeArray[38] = AtomType.USH;
        typeArray[39] = AtomType.UBY;
        typeArray[40] = AtomType.NST;
        typeArray[41] = AtomType.TOK;
        typeArray[42] = AtomType.LAN;
        typeArray[43] = AtomType.NAM;
        typeArray[44] = AtomType.NCN;
        typeArray[45] = AtomType.NMT;
        typeArray[46] = AtomType.ID;
        typeArray[47] = AtomType.IDR;
        typeArray[48] = AtomType.ENT;
        BASE = typeArray;
        DEFAULT = new BXQItemType((Type)AtomType.ITEM, null, -1, 3);
    }

    BXQItemType(int b) throws BXQException {
        this(BASE[b], null, b);
        if (this.type == null) {
            throw new BXQException("Atomic value expected.", new Object[0]);
        }
    }

    BXQItemType(Type t) {
        this(t, null, -1);
    }

    BXQItemType(Type t, QName n, int b) {
        this(t, n, b, 2);
    }

    BXQItemType(Type t, QName n, int b, int o) {
        this.name = n;
        this.type = t;
        this.base = b;
        this.occ = o;
    }

    public int getBaseType() throws BXQException {
        if (this.type.unt()) {
            this.check(new Type[]{NodeType.DEL, NodeType.ELM, NodeType.ATT, AtomType.ATM});
        }
        if (this.base != -1) {
            return this.base;
        }
        int b = 0;
        while (b < BASE.length) {
            if (BASE[b] == this.type) {
                return b;
            }
            ++b;
        }
        throw new BXQException("Item has no base type.", new Object[0]);
    }

    public int getItemKind() {
        if (this.type instanceof NodeType) {
            switch ((NodeType)this.type) {
                case ATT: {
                    return 2;
                }
                case COM: {
                    return 3;
                }
                case DOC: {
                    return 4;
                }
                case DEL: {
                    return 5;
                }
                case ELM: {
                    return 7;
                }
                case NOD: {
                    return 9;
                }
                case PI: {
                    return 10;
                }
                case TXT: {
                    return 11;
                }
            }
            return 1;
        }
        return this.type == AtomType.ITEM ? 8 : 1;
    }

    public int getItemOccurrence() {
        return this.occ;
    }

    public QName getNodeName() throws BXQException {
        this.check(new Type[]{NodeType.DEL, NodeType.ELM, NodeType.ATT});
        return this.name;
    }

    public String getPIName() throws BXQException {
        if (this.type != NodeType.PI) {
            throw new BXQException("Node must be a processing instruction.", new Object[0]);
        }
        return this.name == null ? null : this.name.getLocalPart();
    }

    public URI getSchemaURI() {
        return null;
    }

    public QName getTypeName() throws BXQException {
        if (this.type.unt()) {
            this.check(new Type[]{NodeType.DEL, NodeType.ELM, NodeType.ATT, AtomType.ATM});
        }
        if (this.type == AtomType.ITEM) {
            throw new BXQException("Item has wrong type.", new Object[0]);
        }
        Type t = this.base != -1 ? BASE[this.base] : this.type;
        return new QName(Token.string((byte[])QueryText.XSURI), Token.string((byte[])t.nam()));
    }

    public boolean isAnonymousType() {
        return false;
    }

    public boolean isElementNillable() {
        return false;
    }

    public XQItemType getItemType() {
        return this;
    }

    Type getType() {
        return this.type;
    }

    private void check(Type ... types) throws BXQException {
        Type[] typeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Type t = typeArray[n2];
            if (this.type == t) {
                return;
            }
            ++n2;
        }
        throw new BXQException("Item has wrong type.", new Object[0]);
    }

    public String toString() {
        return Token.string((byte[])this.type.nam());
    }
}

