/*
 * Decompiled with CFR 0.152.
 */
package org.forgerock.openicf.csvfile.sync;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.forgerock.openicf.csvfile.CSVFileConfiguration;
import org.forgerock.openicf.csvfile.sync.Change;
import org.forgerock.openicf.csvfile.sync.CsvItemComparator;
import org.forgerock.openicf.csvfile.sync.DiffException;
import org.forgerock.openicf.csvfile.sync.RecordSet;
import org.forgerock.openicf.csvfile.util.CsvItem;
import org.forgerock.openicf.csvfile.util.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryDiff {
    private CSVFileConfiguration configuration;
    private Pattern linePattern;
    private File oldFile;
    private File newFile = null;

    public InMemoryDiff(File oldFile, File newFile, Pattern linePattern, CSVFileConfiguration configuration) {
        Utils.notNullArgument(newFile, "newFile");
        Utils.notNullArgument(linePattern, "linePattern");
        Utils.notNullArgument((Object)configuration, "configuration");
        this.oldFile = oldFile;
        this.newFile = newFile;
        this.configuration = configuration;
        this.linePattern = linePattern;
    }

    public List<Change> diff() throws DiffException {
        ArrayList<Change> changes = new ArrayList<Change>();
        try {
            if (this.oldFile != null) {
                this.testHeaders(this.newFile, this.oldFile);
            }
            RecordSet newRecordSet = this.createRecordSet(this.newFile);
            int uidIndex = newRecordSet.getHeaders().indexOf(this.configuration.getUniqueAttribute());
            if (this.oldFile != null) {
                RecordSet oldRecordSet = this.createRecordSet(this.oldFile);
                ArrayList<CsvItem> newList = new ArrayList<CsvItem>(newRecordSet.getRecords());
                ArrayList<CsvItem> oldList = new ArrayList<CsvItem>(oldRecordSet.getRecords());
                changes.addAll(this.findChanges(uidIndex, newRecordSet.getHeaders(), newList, oldList));
            } else {
                Set<CsvItem> items = newRecordSet.getRecords();
                Iterator<CsvItem> iterator = items.iterator();
                Change change = null;
                while (iterator.hasNext()) {
                    CsvItem item = iterator.next();
                    change = new Change(item.getAttribute(uidIndex), Change.Type.CREATE, newRecordSet.getHeaders(), item.getAttributes());
                    changes.add(change);
                }
            }
        }
        catch (DiffException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new DiffException("Can't create csv diff, reason: " + ex.getMessage(), ex);
        }
        return changes;
    }

    private List<Change> findChanges(int uidIndex, List<String> headers, List<CsvItem> newList, List<CsvItem> oldList) {
        CsvItem item;
        int newIndex;
        ArrayList<Change> changes = new ArrayList<Change>();
        Change change = null;
        int oldIndex = 0;
        block0: for (newIndex = 0; newIndex < newList.size(); ++newIndex) {
            CsvItem newItem = newList.get(newIndex);
            String newUid = newItem.getAttribute(uidIndex);
            while (oldIndex < oldList.size()) {
                CsvItem item2;
                CsvItem oldItem = oldList.get(oldIndex);
                String oldUid = oldItem.getAttribute(uidIndex);
                int compare = String.CASE_INSENSITIVE_ORDER.compare(newUid, oldUid);
                if (compare < 0) {
                    item2 = newList.get(newIndex);
                    change = new Change(item2.getAttribute(uidIndex), Change.Type.CREATE, headers, item2.getAttributes());
                    changes.add(change);
                    continue block0;
                }
                if (compare <= 0) {
                    if (!this.isEqual(newItem, oldItem)) {
                        change = new Change(newItem.getAttribute(uidIndex), Change.Type.MODIFY, headers, newItem.getAttributes());
                        changes.add(change);
                    }
                    ++oldIndex;
                    continue block0;
                }
                item2 = oldList.get(oldIndex);
                change = new Change(item2.getAttribute(uidIndex), Change.Type.DELETE, headers, item2.getAttributes());
                changes.add(change);
                if (++oldIndex < oldList.size()) continue;
                break block0;
            }
        }
        while (newIndex < newList.size()) {
            item = newList.get(newIndex);
            change = new Change(item.getAttribute(uidIndex), Change.Type.CREATE, headers, item.getAttributes());
            changes.add(change);
            ++newIndex;
        }
        while (oldIndex < oldList.size()) {
            item = oldList.get(oldIndex);
            change = new Change(item.getAttribute(uidIndex), Change.Type.DELETE, headers, item.getAttributes());
            changes.add(change);
            ++oldIndex;
        }
        return changes;
    }

    private boolean isEqual(CsvItem item1, CsvItem item2) {
        return Arrays.equals(item1.getAttributes().toArray(), item2.getAttributes().toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RecordSet createRecordSet(File file) throws IOException, DiffException {
        RecordSet recordSet = null;
        BufferedReader reader = null;
        try {
            reader = Utils.createReader(file, this.configuration);
            List<String> headers = Utils.readHeader(reader, this.linePattern, this.configuration);
            int index = headers.indexOf(this.configuration.getUniqueAttribute());
            if (index < 0 || index >= headers.size()) {
                throw new DiffException("Header in '" + file.getAbsolutePath() + "' doesn't contain unique attribute '" + this.configuration.getUniqueAttribute() + "' as defined in configuration.");
            }
            TreeSet<CsvItem> set = new TreeSet<CsvItem>(new CsvItemComparator(index));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (Utils.isEmptyOrComment(line)) continue;
                set.add(new CsvItem(Utils.parseValues(line, this.linePattern, this.configuration)));
            }
            recordSet = new RecordSet(headers, set);
        }
        finally {
            if (reader != null) {
                Utils.closeReader(reader, null);
            }
        }
        return recordSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testHeaders(File newFile, File oldFile) throws IOException, DiffException {
        List<String> newHeaders = null;
        List<String> oldHeaders = null;
        BufferedReader newReader = null;
        BufferedReader oldReader = null;
        try {
            newReader = Utils.createReader(newFile, this.configuration);
            newHeaders = Utils.readHeader(newReader, this.linePattern, this.configuration);
            oldReader = Utils.createReader(oldFile, this.configuration);
            oldHeaders = Utils.readHeader(oldReader, this.linePattern, this.configuration);
        }
        catch (Throwable throwable) {
            Utils.closeReader(newReader, null);
            Utils.closeReader(oldReader, null);
            throw throwable;
        }
        Utils.closeReader(newReader, null);
        Utils.closeReader(oldReader, null);
        if (newHeaders == null || oldHeaders == null || !Arrays.equals(newHeaders.toArray(), oldHeaders.toArray())) {
            throw new DiffException("Headers in files '" + newFile.getPath() + "' and '" + oldFile.getPath() + "' doesn't match.");
        }
    }
}

