/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.http.servlet;

import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class ForwardAttributes {
    private final String requestUri;
    private final String servletPath;
    private final String contextPath;
    private final String queryString;

    private ForwardAttributes(String requestUri, String servletPath, String contextPath, String queryString) {
        this.requestUri = requestUri;
        this.servletPath = servletPath;
        this.contextPath = contextPath;
        this.queryString = queryString;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public static ForwardAttributes of(HttpServletRequest request) {
        Args.notNull((Object)request, (String)"request");
        String requestUri = (String)request.getAttribute("javax.servlet.forward.request_uri");
        String servletPath = (String)request.getAttribute("javax.servlet.forward.servlet_path");
        String contextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
        String queryString = (String)request.getAttribute("javax.servlet.forward.query_string");
        if (!(Strings.isEmpty((CharSequence)requestUri) && Strings.isEmpty((CharSequence)servletPath) && Strings.isEmpty((CharSequence)contextPath) && Strings.isEmpty((CharSequence)queryString))) {
            return new ForwardAttributes(requestUri, servletPath, contextPath, queryString);
        }
        return null;
    }

    public String toString() {
        return "ForwardAttributes [requestUri=" + this.requestUri + ", servletPath=" + this.servletPath + ", contextPath=" + this.contextPath + ", queryString=" + this.queryString + "]";
    }
}

