/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.persistence.entity;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.activiti.engine.impl.cfg.IdGenerator;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.db.DbSqlSession;
import org.activiti.engine.impl.db.PersistentObject;
import org.activiti.engine.impl.form.StartFormHandler;
import org.activiti.engine.impl.identity.Authentication;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.HistoricActivityInstanceEntity;
import org.activiti.engine.impl.persistence.entity.HistoricProcessInstanceEntity;
import org.activiti.engine.impl.persistence.entity.SuspensionState;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ProcessDefinitionImpl;
import org.activiti.engine.impl.pvm.runtime.InterpretableExecution;
import org.activiti.engine.impl.task.TaskDefinition;
import org.activiti.engine.impl.util.ClockUtil;
import org.activiti.engine.repository.ProcessDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessDefinitionEntity
extends ProcessDefinitionImpl
implements ProcessDefinition,
PersistentObject {
    private static final long serialVersionUID = 1L;
    protected String key;
    protected int revision = 1;
    protected int version;
    protected String category;
    protected String deploymentId;
    protected String resourceName;
    protected Integer historyLevel;
    protected StartFormHandler startFormHandler;
    protected String diagramResourceName;
    protected boolean isGraphicalNotationDefined;
    protected Map<String, TaskDefinition> taskDefinitions;
    protected boolean hasStartFormKey;
    protected int suspensionState = SuspensionState.ACTIVE.getStateCode();

    public ProcessDefinitionEntity() {
        super(null);
    }

    public ExecutionEntity createProcessInstance(String businessKey, ActivityImpl initial) {
        int historyLevel;
        ExecutionEntity processInstance = null;
        processInstance = initial == null ? (ExecutionEntity)super.createProcessInstance() : (ExecutionEntity)super.createProcessInstanceForInitial(initial);
        CommandContext commandContext = Context.getCommandContext();
        processInstance.setExecutions(new ArrayList<ExecutionEntity>());
        processInstance.setProcessDefinition(this.processDefinition);
        if (businessKey != null) {
            processInstance.setBusinessKey(businessKey);
        }
        processInstance.setProcessInstance(processInstance);
        String initiatorVariableName = (String)this.getProperty("initiatorVariableName");
        if (initiatorVariableName != null) {
            String authenticatedUserId = Authentication.getAuthenticatedUserId();
            processInstance.setVariable(initiatorVariableName, authenticatedUserId);
        }
        if ((historyLevel = Context.getProcessEngineConfiguration().getHistoryLevel()) >= 1) {
            HistoricProcessInstanceEntity historicProcessInstance = new HistoricProcessInstanceEntity(processInstance);
            commandContext.getSession(DbSqlSession.class).insert(historicProcessInstance);
        }
        if (historyLevel >= 3) {
            IdGenerator idGenerator = Context.getProcessEngineConfiguration().getIdGenerator();
            String processDefinitionId = processInstance.getProcessDefinitionId();
            String processInstanceId = processInstance.getProcessInstanceId();
            String executionId = processInstance.getId();
            HistoricActivityInstanceEntity historicActivityInstance = new HistoricActivityInstanceEntity();
            historicActivityInstance.setId(idGenerator.getNextId());
            historicActivityInstance.setProcessDefinitionId(processDefinitionId);
            historicActivityInstance.setProcessInstanceId(processInstanceId);
            historicActivityInstance.setExecutionId(executionId);
            historicActivityInstance.setActivityId(processInstance.getActivityId());
            historicActivityInstance.setActivityName((String)processInstance.getActivity().getProperty("name"));
            historicActivityInstance.setActivityType((String)processInstance.getActivity().getProperty("type"));
            Date now = ClockUtil.getCurrentTime();
            historicActivityInstance.setStartTime(now);
            commandContext.getDbSqlSession().insert(historicActivityInstance);
        }
        return processInstance;
    }

    public ExecutionEntity createProcessInstance(String businessKey) {
        return this.createProcessInstance(businessKey, null);
    }

    @Override
    public ExecutionEntity createProcessInstance() {
        return this.createProcessInstance(null);
    }

    @Override
    protected InterpretableExecution newProcessInstance(ActivityImpl activityImpl) {
        ExecutionEntity processInstance = new ExecutionEntity(activityImpl);
        processInstance.insert();
        return processInstance;
    }

    @Override
    public String toString() {
        return "ProcessDefinitionEntity[" + this.id + "]";
    }

    @Override
    public Object getPersistentState() {
        HashMap<String, Integer> persistentState = new HashMap<String, Integer>();
        persistentState.put("suspensionState", this.suspensionState);
        return persistentState;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Override
    public String getDescription() {
        return (String)this.getProperty("documentation");
    }

    @Override
    public String getDeploymentId() {
        return this.deploymentId;
    }

    public void setDeploymentId(String deploymentId) {
        this.deploymentId = deploymentId;
    }

    @Override
    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public Integer getHistoryLevel() {
        return this.historyLevel;
    }

    public void setHistoryLevel(Integer historyLevel) {
        this.historyLevel = historyLevel;
    }

    public StartFormHandler getStartFormHandler() {
        return this.startFormHandler;
    }

    public void setStartFormHandler(StartFormHandler startFormHandler) {
        this.startFormHandler = startFormHandler;
    }

    public Map<String, TaskDefinition> getTaskDefinitions() {
        return this.taskDefinitions;
    }

    public void setTaskDefinitions(Map<String, TaskDefinition> taskDefinitions) {
        this.taskDefinitions = taskDefinitions;
    }

    @Override
    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    @Override
    public String getDiagramResourceName() {
        return this.diagramResourceName;
    }

    public void setDiagramResourceName(String diagramResourceName) {
        this.diagramResourceName = diagramResourceName;
    }

    @Override
    public boolean hasStartFormKey() {
        return this.hasStartFormKey;
    }

    public boolean getHasStartFormKey() {
        return this.hasStartFormKey;
    }

    public void setStartFormKey(boolean hasStartFormKey) {
        this.hasStartFormKey = hasStartFormKey;
    }

    public void setHasStartFormKey(boolean hasStartFormKey) {
        this.hasStartFormKey = hasStartFormKey;
    }

    public boolean isGraphicalNotationDefined() {
        return this.isGraphicalNotationDefined;
    }

    public void setGraphicalNotationDefined(boolean isGraphicalNotationDefined) {
        this.isGraphicalNotationDefined = isGraphicalNotationDefined;
    }

    public int getRevision() {
        return this.revision;
    }

    public void setRevision(int revision) {
        this.revision = revision;
    }

    public int getRevisionNext() {
        return this.revision + 1;
    }

    public int getSuspensionState() {
        return this.suspensionState;
    }

    public void setSuspensionState(int suspensionState) {
        this.suspensionState = suspensionState;
    }

    @Override
    public boolean isSuspended() {
        return this.suspensionState == SuspensionState.SUSPENDED.getStateCode();
    }
}

