/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.mail;

import java.util.Map;
import org.activiti.engine.impl.cmd.GetUserAccountCmd;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.identity.Account;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.mail.MailScanCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateMailScanCmd
implements Command<MailScanCmd> {
    protected String userId;
    protected String userPassword;

    public CreateMailScanCmd(String userId, String userPassword) {
        this.userId = userId;
        this.userPassword = userPassword;
    }

    @Override
    public MailScanCmd execute(CommandContext commandContext) {
        MailScanCmd mailScanCmd = null;
        Account account = new GetUserAccountCmd(this.userId, this.userPassword, "mailscan").execute(commandContext);
        if (account != null) {
            Map<String, String> details = account.getDetails();
            String imapUsername = account.getUsername();
            String imapPassword = account.getPassword();
            String toDoFolderName = details.get("toDoFolderName");
            String toDoInActivitiFolderName = details.get("toDoInActivitiFolderName");
            String imapHost = details.get("imapHost");
            String imapProtocol = details.get("imapProtocol");
            if (imapHost == null) {
                Map<Object, Object> beans = Context.getProcessEngineConfiguration().getBeans();
                imapHost = (String)beans.get("imapHost");
                imapProtocol = (String)beans.get("imapProtocol");
            }
            mailScanCmd = new MailScanCmd();
            mailScanCmd.setUserId(this.userId);
            mailScanCmd.setImapUsername(imapUsername);
            mailScanCmd.setImapPassword(imapPassword);
            mailScanCmd.setImapHost(imapHost);
            mailScanCmd.setImapProtocol(imapProtocol);
            mailScanCmd.setToDoFolderName(toDoFolderName);
            mailScanCmd.setToDoInActivitiFolderName(toDoInActivitiFolderName);
        }
        return mailScanCmd;
    }
}

