/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.provisioning.consistency.impl;

import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.provisioning.consistency.api.ErrorHandler;
import com.evolveum.midpoint.provisioning.ucf.api.GenericFrameworkException;
import com.evolveum.midpoint.provisioning.util.ShadowCacheUtil;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.DeltaConvertor;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.CommunicationException;
import com.evolveum.midpoint.util.exception.ConfigurationException;
import com.evolveum.midpoint.util.exception.ObjectAlreadyExistsException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.FailedOperationTypeType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceObjectShadowType;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.apache.commons.lang.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class CommunicationExceptionHandler
extends ErrorHandler {
    @Autowired
    @Qualifier(value="cacheRepositoryService")
    private RepositoryService cacheRepositoryService = null;

    public RepositoryService getCacheRepositoryService() {
        return this.cacheRepositoryService;
    }

    public void setCacheRepositoryService(RepositoryService repositoryService) {
        this.cacheRepositoryService = repositoryService;
    }

    @Override
    public void handleError(ResourceObjectShadowType shadow, Exception ex) throws SchemaException, GenericFrameworkException, CommunicationException, ObjectNotFoundException, ObjectAlreadyExistsException, ConfigurationException {
        OperationResult operationResult = new OperationResult(String.valueOf(CommunicationExceptionHandler.class.getName()) + ".handleError");
        Validate.notNull((Object)shadow, (String)"Shadow must not be null.");
        Validate.notNull((Object)shadow.getFailedOperationType(), (String)"Failed operation type must not be null.");
        if (FailedOperationTypeType.ADD == shadow.getFailedOperationType()) {
            if (shadow.getName() == null) {
                shadow.setName(ShadowCacheUtil.determineShadowName(shadow));
            }
            shadow.setAttemptNumber(Integer.valueOf(0));
            if (shadow.getObjectChange() != null && shadow.getOid() != null) {
                Collection deltas = DeltaConvertor.toModifications((Collection)shadow.getObjectChange().getModification(), (PrismObjectDefinition)shadow.asPrismObject().getDefinition());
                this.cacheRepositoryService.modifyObject(AccountShadowType.class, shadow.getOid(), deltas, operationResult);
            }
        } else if (FailedOperationTypeType.MODIFY == shadow.getFailedOperationType()) {
            ArrayList<PropertyDelta> modifications = new ArrayList<PropertyDelta>();
            PropertyDelta propertyDelta = PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)shadow.asPrismObject().getDefinition()), (QName)ResourceObjectShadowType.F_RESULT, (Object[])new Object[]{shadow.getResult()});
            modifications.add(propertyDelta);
            propertyDelta = PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)shadow.asPrismObject().getDefinition()), (QName)ResourceObjectShadowType.F_FAILED_OPERATION_TYPE, (Object[])new Object[]{shadow.getFailedOperationType()});
            modifications.add(propertyDelta);
            propertyDelta = PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)shadow.asPrismObject().getDefinition()), (QName)ResourceObjectShadowType.F_OBJECT_CHANGE, (Object[])new Object[]{shadow.getObjectChange()});
            modifications.add(propertyDelta);
            propertyDelta = PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)shadow.asPrismObject().getDefinition()), (QName)ResourceObjectShadowType.F_ATTEMPT_NUMBER, (Object[])new Object[]{0});
            modifications.add(propertyDelta);
            this.getCacheRepositoryService().modifyObject(AccountShadowType.class, shadow.getOid(), modifications, operationResult);
        } else if (FailedOperationTypeType.DELETE == shadow.getFailedOperationType()) {
            ArrayList<PropertyDelta> modifications = new ArrayList<PropertyDelta>();
            PropertyDelta propertyDelta = PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)shadow.asPrismObject().getDefinition()), (QName)ResourceObjectShadowType.F_RESULT, (Object[])new Object[]{shadow.getResult()});
            modifications.add(propertyDelta);
            propertyDelta = PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)shadow.asPrismObject().getDefinition()), (QName)ResourceObjectShadowType.F_FAILED_OPERATION_TYPE, (Object[])new Object[]{FailedOperationTypeType.DELETE});
            modifications.add(propertyDelta);
            propertyDelta = PropertyDelta.createReplaceDelta((PrismContainerDefinition)((PrismContainerDefinition)shadow.asPrismObject().getDefinition()), (QName)ResourceObjectShadowType.F_ATTEMPT_NUMBER, (Object[])new Object[]{0});
            modifications.add(propertyDelta);
            this.getCacheRepositoryService().modifyObject(AccountShadowType.class, shadow.getOid(), modifications, operationResult);
        }
    }
}

