/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.refinery.ResourceAccountType;
import com.evolveum.midpoint.common.valueconstruction.ValueConstruction;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructionFactory;
import com.evolveum.midpoint.model.AccountSyncContext;
import com.evolveum.midpoint.model.PolicyDecision;
import com.evolveum.midpoint.model.SyncContext;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismProperty;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.schema.constants.SchemaConstants;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AccountShadowType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceAccountTypeDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceActivationDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ResourceActivationEnableDefinitionType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ValueConstructionType;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ActivationProcessor {
    private static final Trace LOGGER = TraceManager.getTrace(ActivationProcessor.class);
    @Autowired(required=true)
    private PrismContext prismContext;
    @Autowired(required=true)
    private ValueConstructionFactory valueConstructionFactory;

    public void processActivation(SyncContext context, OperationResult result) throws ExpressionEvaluationException, ObjectNotFoundException, SchemaException {
        ObjectDelta<UserType> userDelta = context.getUserDelta();
        if (userDelta == null) {
            LOGGER.trace("userDelta is null, skipping activation processing");
            return;
        }
        PropertyDelta enabledValueDelta = userDelta.findPropertyDelta(SchemaConstants.PATH_ACTIVATION_ENABLE);
        PrismObject<UserType> userNew = context.getUserNew();
        if (userNew == null) {
            LOGGER.trace("userNew is null, skipping activation processing");
            return;
        }
        PrismProperty userEnabledNew = userNew.findProperty(SchemaConstants.PATH_ACTIVATION_ENABLE);
        PrismObjectDefinition accountDefinition = this.prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(AccountShadowType.class);
        PrismPropertyDefinition accountEnabledPropertyDefinition = accountDefinition.findPropertyDefinition(SchemaConstants.PATH_ACTIVATION_ENABLE);
        for (AccountSyncContext accCtx : context.getAccountContexts()) {
            ResourceAccountType rat = accCtx.getResourceAccountType();
            PolicyDecision policyDecision = accCtx.getPolicyDecision();
            if (policyDecision != null && (policyDecision == PolicyDecision.DELETE || policyDecision == PolicyDecision.UNLINK)) {
                LOGGER.trace("Activation processing skipped for " + rat + ", account is being deleted or unlinked");
                continue;
            }
            ObjectDelta<AccountShadowType> accountDelta = accCtx.getAccountDelta();
            if ((accountDelta == null || accountDelta.getChangeType() != ChangeType.ADD) && enabledValueDelta == null) {
                LOGGER.trace("No change in activation and the account is not added, skipping activation processing for account " + rat);
                continue;
            }
            ResourceAccountTypeDefinitionType resourceAccountDefType = accCtx.getResourceAccountTypeDefinitionType();
            if (resourceAccountDefType == null) {
                LOGGER.trace("No ResourceAccountTypeDefinition, therefore also no activation outbound definition, skipping activation processing for account " + rat);
                continue;
            }
            ResourceActivationDefinitionType activationType = resourceAccountDefType.getActivation();
            if (activationType == null) {
                LOGGER.trace("No activation definition in account type {}, skipping activation processing", (Object)rat);
                continue;
            }
            ResourceActivationEnableDefinitionType enabledType = activationType.getEnabled();
            if (enabledType == null) {
                LOGGER.trace("No 'enabled' definition in activation in account type {}, skipping activation processing", (Object)rat);
                continue;
            }
            ValueConstructionType outbound = enabledType.getOutbound();
            if (outbound == null) {
                LOGGER.trace("No outbound definition in 'enabled' definition in activation in account type {}, skipping activation processing", (Object)rat);
                continue;
            }
            ValueConstruction enabledConstruction = this.valueConstructionFactory.createValueConstruction(outbound, (ItemDefinition)accountEnabledPropertyDefinition, "outbound activation in account type " + rat);
            enabledConstruction.setInput((Item)userEnabledNew);
            enabledConstruction.evaluate(result);
            PrismProperty accountEnabledNew = (PrismProperty)enabledConstruction.getOutput();
            if (accountEnabledNew == null || accountEnabledNew.isEmpty()) {
                LOGGER.trace("Activation 'enable' expression resulted in null or empty value, skipping activation processing for {}", (Object)rat);
                continue;
            }
            PropertyDelta accountEnabledDelta = PropertyDelta.createDelta((PropertyPath)SchemaConstants.PATH_ACTIVATION_ENABLE, AccountShadowType.class, (PrismContext)this.prismContext);
            accountEnabledDelta.setValuesToReplace((Collection)accountEnabledNew.getValues());
            LOGGER.trace("Adding new 'enabled' delta for account {}: {}", (Object)rat, (Object)accountEnabledNew.getValues());
            accCtx.addToSecondaryDelta(accountEnabledDelta);
        }
    }
}

