/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.impl.api.local;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.IOUtil;
import org.identityconnectors.common.ReflectionUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.api.ConnectorInfo;
import org.identityconnectors.framework.api.ConnectorInfoManager;
import org.identityconnectors.framework.api.ConnectorKey;
import org.identityconnectors.framework.common.FrameworkUtil;
import org.identityconnectors.framework.common.exceptions.ConfigurationException;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.impl.api.APIConfigurationImpl;
import org.identityconnectors.framework.impl.api.ConnectorMessagesImpl;
import org.identityconnectors.framework.impl.api.local.BundleClassLoader;
import org.identityconnectors.framework.impl.api.local.BundleLibSorter;
import org.identityconnectors.framework.impl.api.local.ConnectorBundleManifestParser;
import org.identityconnectors.framework.impl.api.local.JavaClassProperties;
import org.identityconnectors.framework.impl.api.local.LocalConnectorInfoImpl;
import org.identityconnectors.framework.impl.api.local.ThreadClassLoaderManager;
import org.identityconnectors.framework.impl.api.local.WorkingBundleInfo;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.PoolableConnector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalConnectorInfoManagerImpl
implements ConnectorInfoManager {
    private static final Log _log = Log.getLog(LocalConnectorInfoManagerImpl.class);
    private List<ConnectorInfo> _connectorInfo;

    public LocalConnectorInfoManagerImpl(List<URL> bundleURLs, ClassLoader bundleParentClassLoader) throws ConfigurationException {
        List<WorkingBundleInfo> workingInfo = LocalConnectorInfoManagerImpl.expandBundles(bundleURLs);
        WorkingBundleInfo.resolve(workingInfo);
        this._connectorInfo = LocalConnectorInfoManagerImpl.createConnectorInfo(workingInfo, bundleParentClassLoader);
    }

    private static List<WorkingBundleInfo> expandBundles(List<URL> bundleURLs) throws ConfigurationException {
        ArrayList<WorkingBundleInfo> rv = new ArrayList<WorkingBundleInfo>();
        for (URL url : bundleURLs) {
            File file = new File(url.getFile());
            WorkingBundleInfo info = "file".equals(url.getProtocol()) && file.isDirectory() ? LocalConnectorInfoManagerImpl.processDirectory(file) : LocalConnectorInfoManagerImpl.processURL(url, true);
            rv.add(info);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkingBundleInfo processDirectory(File dir) throws ConfigurationException {
        WorkingBundleInfo info = new WorkingBundleInfo(dir.getAbsolutePath());
        try {
            File nativeDir;
            File manifest = new File(dir, "META-INF/MANIFEST.MF");
            FileInputStream in = null;
            try {
                in = new FileInputStream(manifest);
                Manifest rawManifest = new Manifest(in);
                ConnectorBundleManifestParser parser = new ConnectorBundleManifestParser(info.getOriginalLocation(), rawManifest);
                info.setManifest(parser.parse());
            }
            catch (Throwable throwable) {
                IOUtil.quietClose(in);
                throw throwable;
            }
            IOUtil.quietClose(in);
            info.getImmediateClassPath().add(dir.toURL());
            List<String> bundleContents = LocalConnectorInfoManagerImpl.listBundleContents(dir);
            info.getImmediateBundleContents().addAll(bundleContents);
            File libDir = new File(dir, "lib");
            if (libDir.exists()) {
                List<URL> libURLs = BundleLibSorter.getSortedURLs(libDir);
                for (URL lib : libURLs) {
                    WorkingBundleInfo embedded = LocalConnectorInfoManagerImpl.processURL(lib, false);
                    info.getEmbeddedBundles().add(embedded);
                }
            }
            if ((nativeDir = new File(dir, "native")).exists()) {
                for (File file : BundleLibSorter.getSortedFiles(nativeDir)) {
                    if (!file.isFile()) continue;
                    String localName = file.getName();
                    info.getImmediateNativeLibraries().put(localName, file.getAbsolutePath());
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        return info;
    }

    private static List<String> listBundleContents(File dir) {
        ArrayList<String> rv = new ArrayList<String>();
        for (File file : dir.listFiles()) {
            LocalConnectorInfoManagerImpl.listBundleContents2("", file, rv);
        }
        return rv;
    }

    private static void listBundleContents2(String prefix, File file, List<String> result) {
        result.add(prefix + file.getName());
        if (file.isDirectory()) {
            for (File sub : file.listFiles()) {
                LocalConnectorInfoManagerImpl.listBundleContents2(prefix + "/", sub, result);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static WorkingBundleInfo processURL(URL url, boolean topLevel) throws ConfigurationException {
        WorkingBundleInfo info = new WorkingBundleInfo(url.toString());
        BundleTempDirectory tempDir = new BundleTempDirectory();
        try {
            JarInputStream stream = null;
            if (url.getProtocol().equals("file")) {
                info.getImmediateClassPath().add(url);
            } else {
                InputStream stream2 = null;
                try {
                    stream2 = url.openStream();
                    info.getImmediateClassPath().add(tempDir.copyStreamToFile(stream2).toURL());
                }
                finally {
                    IOUtil.quietClose(stream2);
                }
            }
            TreeMap<String, URL> libURLs = new TreeMap<String, URL>();
            try {
                stream = new JarInputStream(url.openStream());
                if (topLevel) {
                    Manifest rawManifest = stream.getManifest();
                    ConnectorBundleManifestParser parser = new ConnectorBundleManifestParser(info.getOriginalLocation(), rawManifest);
                    info.setManifest(parser.parse());
                }
                JarEntry entry = null;
                while ((entry = stream.getNextJarEntry()) != null) {
                    String localName;
                    String name = entry.getName();
                    info.getImmediateBundleContents().add(name);
                    if (name.startsWith("lib/") && !entry.isDirectory()) {
                        localName = name.substring("lib/".length());
                        URL tempurl = tempDir.copyStreamToFile(stream, name).toURL();
                        libURLs.put(localName, tempurl);
                    }
                    if (!name.startsWith("native/") || entry.isDirectory()) continue;
                    localName = name.substring("native/".length());
                    File tempFile = tempDir.copyStreamToFile(stream, name);
                    info.getImmediateNativeLibraries().put(localName, tempFile.getAbsolutePath());
                }
            }
            catch (Throwable throwable) {
                IOUtil.quietClose(stream);
                throw throwable;
            }
            IOUtil.quietClose(stream);
            for (URL lib : libURLs.values()) {
                WorkingBundleInfo embedded = LocalConnectorInfoManagerImpl.processURL(lib, false);
                info.getEmbeddedBundles().add(embedded);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(e);
        }
        return info;
    }

    private static List<ConnectorInfo> createConnectorInfo(Collection<WorkingBundleInfo> parsed, ClassLoader bundleParentClassLoader) throws ConfigurationException {
        ArrayList<ConnectorInfo> rv = new ArrayList<ConnectorInfo>();
        for (WorkingBundleInfo bundleInfo : parsed) {
            BundleClassLoader loader = new BundleClassLoader(bundleInfo.getEffectiveClassPath(), bundleInfo.getEffectiveNativeLibraries(), bundleParentClassLoader);
            for (String name : bundleInfo.getImmediateBundleContents()) {
                Class<?> connectorClass = null;
                ConnectorClass options = null;
                if (name.endsWith(".class")) {
                    String className = name.substring(0, name.length() - ".class".length());
                    className = className.replace('/', '.');
                    try {
                        connectorClass = loader.loadClass(className);
                        options = connectorClass.getAnnotation(ConnectorClass.class);
                    }
                    catch (Throwable e) {
                        _log.warn(e, "Unable to load class {0} from bundle {1}. Class will be ignored and will not be listed in list of connectors.", className, bundleInfo.getOriginalLocation());
                    }
                }
                if (connectorClass == null || options == null) continue;
                if (!Connector.class.isAssignableFrom(connectorClass)) {
                    String message = "Class " + connectorClass + " does not implement " + Connector.class.getName();
                    throw new ConfigurationException(message);
                }
                LocalConnectorInfoImpl info = new LocalConnectorInfoImpl();
                info.setConnectorClass(connectorClass.asSubclass(Connector.class));
                info.setConnectorConfigurationClass(options.configurationClass());
                info.setConnectorDisplayNameKey(options.displayNameKey());
                info.setConnectorKey(new ConnectorKey(bundleInfo.getManifest().getBundleName(), bundleInfo.getManifest().getBundleVersion(), connectorClass.getName()));
                ConnectorMessagesImpl messages = LocalConnectorInfoManagerImpl.loadMessageCatalog(bundleInfo.getEffectiveContents(), loader, info.getConnectorClass());
                info.setMessages(messages);
                info.setDefaultAPIConfiguration(LocalConnectorInfoManagerImpl.createDefaultAPIConfiguration(info));
                rv.add(info);
            }
        }
        return rv;
    }

    private static APIConfigurationImpl createDefaultAPIConfiguration(LocalConnectorInfoImpl localInfo) {
        ThreadClassLoaderManager.getInstance().pushClassLoader(localInfo.getConnectorClass().getClassLoader());
        try {
            Class<? extends Connector> connectorClass = localInfo.getConnectorClass();
            APIConfigurationImpl rv = new APIConfigurationImpl();
            Configuration config = localInfo.getConnectorConfigurationClass().newInstance();
            boolean pooling = PoolableConnector.class.isAssignableFrom(connectorClass);
            rv.setConnectorPoolingSupported(pooling);
            rv.setConfigurationProperties(JavaClassProperties.createConfigurationProperties(config));
            rv.setConnectorInfo(localInfo);
            rv.setSupportedOperations(FrameworkUtil.getDefaultSupportedOperations(connectorClass));
            APIConfigurationImpl aPIConfigurationImpl = rv;
            return aPIConfigurationImpl;
        }
        catch (Exception e) {
            throw ConnectorException.wrap(e);
        }
        finally {
            ThreadClassLoaderManager.getInstance().popClassLoader();
        }
    }

    private static ConnectorMessagesImpl loadMessageCatalog(Set<String> bundleContents, ClassLoader loader, Class<? extends Connector> connector) throws ConfigurationException {
        try {
            String[] prefixes = LocalConnectorInfoManagerImpl.getBundleNamePrefixes(connector);
            String suffix = ".properties";
            ConnectorMessagesImpl rv = new ConnectorMessagesImpl();
            for (int i = prefixes.length - 1; i >= 0; --i) {
                String prefix = prefixes[i];
                for (String path : bundleContents) {
                    String localeStr;
                    if (!path.startsWith(prefix) || !(localeStr = path.substring(prefix.length())).endsWith(".properties")) continue;
                    localeStr = localeStr.substring(0, localeStr.length() - ".properties".length());
                    Locale locale = LocalConnectorInfoManagerImpl.parseLocale(localeStr);
                    Properties properties = IOUtil.getResourceAsProperties(loader, path);
                    Map<String, String> map = rv.getCatalogs().get(locale);
                    if (map == null) {
                        map = new HashMap<String, String>();
                        rv.getCatalogs().put(locale, map);
                    }
                    map.putAll(CollectionUtil.newMap(properties));
                }
            }
            return rv;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationException(e);
        }
    }

    private static Locale parseLocale(String str) {
        String lang = null;
        String country = null;
        String variant = null;
        StringTokenizer tok = new StringTokenizer(str, "_", false);
        if (tok.hasMoreTokens()) {
            lang = tok.nextToken();
        }
        if (tok.hasMoreTokens()) {
            country = tok.nextToken();
        }
        if (tok.hasMoreTokens()) {
            variant = tok.nextToken();
        }
        if (variant != null) {
            return new Locale(lang, country, variant);
        }
        if (country != null) {
            return new Locale(lang, country);
        }
        if (lang != null) {
            return new Locale(lang);
        }
        return new Locale("");
    }

    private static String[] getBundleNamePrefixes(Class<? extends Connector> connector) {
        ConnectorClass configOpts = connector.getAnnotation(ConnectorClass.class);
        String[] paths = null;
        if (configOpts != null) {
            paths = configOpts.messageCatalogPaths();
        }
        if (paths == null || paths.length == 0) {
            String pkage = ReflectionUtil.getPackage(connector);
            String messageCatalog = pkage + ".Messages";
            paths = new String[]{messageCatalog};
        }
        for (int i = 0; i < paths.length; ++i) {
            paths[i] = paths[i].replace('.', '/');
        }
        return paths;
    }

    @Override
    public ConnectorInfo findConnectorInfo(ConnectorKey key) {
        for (ConnectorInfo info : this._connectorInfo) {
            if (!info.getConnectorKey().equals(key)) continue;
            return info;
        }
        return null;
    }

    @Override
    public List<ConnectorInfo> getConnectorInfos() {
        return Collections.unmodifiableList(this._connectorInfo);
    }

    private static final class BundleTempDirectory {
        private final Random _random = new Random(System.currentTimeMillis());
        private File _bundleTempDir;

        private BundleTempDirectory() {
        }

        public File copyStreamToFile(InputStream stream) throws IOException {
            File candidate;
            File bundleDir = this.getBundleTempDir();
            while (!(candidate = new File(bundleDir, "file-" + this.nextRandom())).createNewFile()) {
            }
            candidate.deleteOnExit();
            this.copyStream(stream, candidate);
            return candidate;
        }

        public File copyStreamToFile(InputStream stream, String name) throws IOException {
            File bundleDir = this.getBundleTempDir();
            File newFile = new File(bundleDir, name);
            if (newFile.exists()) {
                throw new IOException("File " + newFile + " already exists");
            }
            File parent = newFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IOException("Could not create directory " + parent);
            }
            while (!parent.equals(bundleDir)) {
                parent.deleteOnExit();
                parent = parent.getParentFile();
            }
            newFile.deleteOnExit();
            this.copyStream(stream, newFile);
            return newFile;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void copyStream(InputStream stream, File toFile) throws IOException {
            FileOutputStream out = new FileOutputStream(toFile);
            try {
                IOUtil.copyFile(stream, out);
            }
            finally {
                out.close();
            }
        }

        private File getBundleTempDir() throws IOException {
            File candidate;
            if (this._bundleTempDir != null) {
                return this._bundleTempDir;
            }
            File tempDir = new File(System.getProperty("java.io.tmpdir"));
            if (!tempDir.exists()) {
                throw new IOException("Temporary directory " + tempDir + " does not exist");
            }
            while (!(candidate = new File(tempDir, "bundle-" + this.nextRandom())).mkdir()) {
            }
            candidate.deleteOnExit();
            this._bundleTempDir = candidate;
            return candidate;
        }

        private int nextRandom() {
            return this._random.nextInt() & Integer.MAX_VALUE;
        }
    }
}

