/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.repo.sql.query;

import com.evolveum.midpoint.repo.sql.data.common.RContainer;
import com.evolveum.midpoint.repo.sql.data.common.RContainerType;
import com.evolveum.midpoint.repo.sql.data.common.RObjectReference;
import com.evolveum.midpoint.repo.sql.query.AttributeDefinition;
import com.evolveum.midpoint.repo.sql.query.EntityDefinition;
import com.evolveum.midpoint.repo.sql.query.QueryAttribute;
import com.evolveum.midpoint.repo.sql.query.QueryEntity;
import com.evolveum.midpoint.repo.sql.query.QueryException;
import com.evolveum.midpoint.repo.sql.util.ClassMapper;
import com.evolveum.midpoint.schema.constants.ObjectTypes;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.hibernate.annotations.Index;

public class QueryRegistry {
    private static final Trace LOGGER = TraceManager.getTrace(QueryRegistry.class);
    private static QueryRegistry registry;
    private Map<QName, EntityDefinition> definitions = new HashMap<QName, EntityDefinition>();

    public static QueryRegistry getInstance() throws QueryException {
        if (registry == null) {
            registry = new QueryRegistry();
            registry.init();
        }
        return registry;
    }

    public <T extends ObjectType> EntityDefinition findDefinition(Class<T> type) {
        ObjectTypes def = ObjectTypes.getObjectType(type);
        return this.findDefinition(def.getQName());
    }

    public EntityDefinition findDefinition(QName qname) {
        Validate.notNull((Object)qname, (String)"QName must not be null.");
        return this.definitions.get(qname);
    }

    private void init() throws QueryException {
        LOGGER.debug("Initializing query definition registry.");
        Collection<RContainerType> types = ClassMapper.getKnownTypes();
        for (RContainerType type : types) {
            Class<? extends RContainer> clazz = type.getClazz();
            EntityDefinition entityDef = new EntityDefinition();
            ObjectTypes objectType = ClassMapper.getObjectTypeForHQLType(type);
            entityDef.setName(objectType.getQName());
            entityDef.setType(objectType.getTypeQName());
            this.definitions.put(entityDef.getName(), entityDef);
            List<Field> fields = QueryRegistry.getFields(clazz);
            LOGGER.trace("Processing {}, fields count: {}.", new Object[]{clazz.getName(), fields.size()});
            for (Field field : fields) {
                this.createDefinition(entityDef, field);
            }
        }
        StringBuilder builder = new StringBuilder();
        DebugUtil.debugDumpMapMultiLine((StringBuilder)builder, this.definitions, (int)3);
        LOGGER.trace("Registry dump\n{}", new Object[]{builder.toString()});
        LOGGER.debug("Query definition registry initialization finished.");
    }

    private void createDefinition(EntityDefinition parent, Field field) {
        if (this.hasAnnotation(field, QueryEntity.class)) {
            LOGGER.trace("Entity {}", new Object[]{field.getName()});
            QueryEntity queryEntity = field.getAnnotation(QueryEntity.class);
            String name = StringUtils.isNotEmpty((String)queryEntity.name()) ? queryEntity.name() : field.getName();
            String namespace = StringUtils.isNotEmpty((String)queryEntity.namespace()) ? queryEntity.namespace() : "http://midpoint.evolveum.com/xml/ns/public/common/common-2";
            EntityDefinition entityDef = new EntityDefinition();
            entityDef.setName(new QName(namespace, name));
            entityDef.setAny(queryEntity.any());
            entityDef.setEmbedded(queryEntity.embedded());
            parent.putDefinition(entityDef.getName(), entityDef);
        } else if (this.hasAnnotation(field, QueryAttribute.class)) {
            LOGGER.trace("Attribute {}", new Object[]{field.getName()});
            QueryAttribute queryAttribute = field.getAnnotation(QueryAttribute.class);
            String name = StringUtils.isNotEmpty((String)queryAttribute.name()) ? queryAttribute.name() : field.getName();
            String namespace = StringUtils.isNotEmpty((String)queryAttribute.namespace()) ? queryAttribute.namespace() : "http://midpoint.evolveum.com/xml/ns/public/common/common-2";
            AttributeDefinition attrDef = new AttributeDefinition();
            attrDef.setName(new QName(namespace, name));
            attrDef.setIndexed(this.isFieldIndexed(field));
            attrDef.setEnumerated(queryAttribute.enumerated());
            attrDef.setPolyString(queryAttribute.polyString());
            if (queryAttribute.enumerated()) {
                attrDef.setClassType(field.getType());
            }
            if (RObjectReference.class.isAssignableFrom(field.getType())) {
                attrDef.setReference(true);
            }
            parent.putDefinition(attrDef.getName(), attrDef);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isFieldIndexed(Field field) {
        try {
            Annotation[] annotations;
            Method getter = PropertyUtils.getReadMethod((PropertyDescriptor)new PropertyDescriptor(field.getName(), field.getDeclaringClass()));
            if (getter == null) {
                return false;
            }
            Annotation[] annotationArray = annotations = getter.getDeclaredAnnotations();
            int n = annotations.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                Annotation annotation = annotationArray[n2];
                if (annotation instanceof Index) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            LOGGER.trace("Is field indexed check failed, reason: " + ex.getMessage(), (Throwable)ex);
        }
        return false;
    }

    private boolean hasAnnotation(Field field, Class<? extends Annotation> type) {
        return field.getAnnotation(type) != null;
    }

    public static List<Field> getFields(Class clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (clazz == null) {
            return fields;
        }
        fields.addAll(QueryRegistry.getFields(clazz.getSuperclass()));
        Field[] fieldArray = clazz.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (!Modifier.isStatic(field.getModifiers())) {
                fields.add(field);
            }
            ++n2;
        }
        return fields;
    }
}

