/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.schema;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.Objectable;
import com.evolveum.midpoint.prism.PrismContainerDefinition;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.prism.PrismObjectDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ChangeType;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.ObjectDelta;
import com.evolveum.midpoint.prism.dom.PrismDomProcessor;
import com.evolveum.midpoint.prism.xml.XmlTypeConverter;
import com.evolveum.midpoint.schema.holder.XPathHolder;
import com.evolveum.midpoint.util.DOMUtil;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.exception.SystemException;
import com.evolveum.midpoint.xml.ns._public.common.api_types_2.ObjectModificationType;
import com.evolveum.prism.xml.ns._public.types_2.ChangeTypeType;
import com.evolveum.prism.xml.ns._public.types_2.ItemDeltaType;
import com.evolveum.prism.xml.ns._public.types_2.ModificationTypeType;
import com.evolveum.prism.xml.ns._public.types_2.ObjectDeltaType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DeltaConvertor {
    public static final QName PATH_ELEMENT_NAME = new QName("http://prism.evolveum.com/xml/ns/public/types-2", "path");

    public static <T extends Objectable> ObjectDelta<T> createObjectDelta(ObjectModificationType objectModification, Class<T> type, PrismContext prismContext) throws SchemaException {
        PrismObjectDefinition objectDefinition = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(type);
        if (objectDefinition == null) {
            throw new SchemaException("No object definition for class " + type);
        }
        return DeltaConvertor.createObjectDelta(objectModification, objectDefinition);
    }

    public static <T extends Objectable> ObjectDelta<T> createObjectDelta(ObjectModificationType objectModification, PrismObjectDefinition<T> objDef) throws SchemaException {
        ObjectDelta objectDelta = new ObjectDelta(objDef.getCompileTimeClass(), ChangeType.MODIFY);
        objectDelta.setOid(objectModification.getOid());
        for (ItemDeltaType propMod : objectModification.getModification()) {
            ItemDelta itemDelta = DeltaConvertor.createItemDelta(propMod, objDef);
            objectDelta.addModification(itemDelta);
        }
        return objectDelta;
    }

    public static <T extends Objectable> Collection<? extends ItemDelta> toModifications(ObjectModificationType objectModification, Class<T> type, PrismContext prismContext) throws SchemaException {
        PrismObjectDefinition objectDefinition = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(type);
        if (objectDefinition == null) {
            throw new SchemaException("No object definition for class " + type);
        }
        return DeltaConvertor.toModifications(objectModification, objectDefinition);
    }

    public static <T extends Objectable> Collection<? extends ItemDelta> toModifications(ObjectModificationType objectModification, PrismObjectDefinition<T> objDef) throws SchemaException {
        return DeltaConvertor.toModifications(objectModification.getModification(), objDef);
    }

    public static <T extends Objectable> Collection<? extends ItemDelta> toModifications(Collection<ItemDeltaType> itemDeltaTypes, PrismObjectDefinition<T> objDef) throws SchemaException {
        ArrayList<ItemDelta> modifications = new ArrayList<ItemDelta>();
        for (ItemDeltaType propMod : itemDeltaTypes) {
            ItemDelta itemDelta = DeltaConvertor.createItemDelta(propMod, objDef);
            modifications.add(itemDelta);
        }
        return modifications;
    }

    public static <T extends Objectable> ObjectModificationType toObjectModificationType(ObjectDelta<T> delta) throws SchemaException {
        if (delta.getChangeType() != ChangeType.MODIFY) {
            throw new IllegalStateException("Cannot produce ObjectModificationType from delta of type " + delta.getChangeType());
        }
        ObjectModificationType modType = new ObjectModificationType();
        modType.setOid(delta.getOid());
        List<ItemDeltaType> propModTypes = modType.getModification();
        for (ItemDelta propDelta : delta.getModifications()) {
            Collection<ItemDeltaType> propPropModTypes;
            try {
                propPropModTypes = DeltaConvertor.toPropertyModificationTypes(propDelta);
            }
            catch (SchemaException e) {
                throw new SchemaException(String.valueOf(e.getMessage()) + " in " + delta.toString(), (Throwable)e);
            }
            propModTypes.addAll(propPropModTypes);
        }
        return modType;
    }

    public static ObjectDeltaType toObjectDeltaType(ObjectDelta<? extends Objectable> objectDelta) throws SchemaException {
        ObjectDeltaType objectDeltaType = new ObjectDeltaType();
        objectDeltaType.setChangeType(DeltaConvertor.convertChangeType(objectDelta.getChangeType()));
        objectDeltaType.setOid(objectDelta.getOid());
        if (objectDelta.getChangeType() == ChangeType.ADD) {
            PrismObject prismObject = objectDelta.getObjectToAdd();
            if (prismObject != null) {
                PrismDomProcessor domProcessor = prismObject.getPrismContext().getPrismDomProcessor();
                Element objectElement = domProcessor.serializeToDom(prismObject);
                ObjectDeltaType.ObjectToAdd objectToAdd = new ObjectDeltaType.ObjectToAdd();
                objectToAdd.setAny((Object)objectElement);
                objectDeltaType.setObjectToAdd(objectToAdd);
            }
        } else if (objectDelta.getChangeType() == ChangeType.MODIFY) {
            ObjectModificationType modType = new ObjectModificationType();
            modType.setOid(objectDelta.getOid());
            for (ItemDelta propDelta : objectDelta.getModifications()) {
                Collection<ItemDeltaType> propPropModTypes;
                try {
                    propPropModTypes = DeltaConvertor.toPropertyModificationTypes(propDelta);
                }
                catch (SchemaException e) {
                    throw new SchemaException(String.valueOf(e.getMessage()) + " in " + objectDelta.toString(), (Throwable)e);
                }
                objectDeltaType.getModification().addAll(propPropModTypes);
            }
        } else if (objectDelta.getChangeType() != ChangeType.DELETE) {
            throw new SystemException("Unknown changetype " + objectDelta.getChangeType());
        }
        return objectDeltaType;
    }

    private static ChangeTypeType convertChangeType(ChangeType changeType) {
        if (changeType == ChangeType.ADD) {
            return ChangeTypeType.ADD;
        }
        if (changeType == ChangeType.MODIFY) {
            return ChangeTypeType.MODIFY;
        }
        if (changeType == ChangeType.DELETE) {
            return ChangeTypeType.DELETE;
        }
        throw new SystemException("Unknown changetype " + changeType);
    }

    public static ItemDelta createItemDelta(ItemDeltaType propMod, Class<? extends Objectable> objectType, PrismContext prismContext) throws SchemaException {
        PrismObjectDefinition objectDefinition = prismContext.getSchemaRegistry().findObjectDefinitionByCompileTimeClass(objectType);
        return DeltaConvertor.createItemDelta(propMod, (PrismContainerDefinition)objectDefinition);
    }

    public static ItemDelta createItemDelta(ItemDeltaType propMod, PrismContainerDefinition pcDef) throws SchemaException {
        XPathHolder xpath = new XPathHolder(propMod.getPath());
        PropertyPath parentPath = xpath.toPropertyPath();
        if (propMod.getValue() == null) {
            throw new IllegalArgumentException("No value in item delta (path: " + parentPath + ") while creating a property delta");
        }
        PrismContainerDefinition containingPcd = pcDef.findContainerDefinition(parentPath);
        if (containingPcd == null) {
            throw new SchemaException("No container definition for " + parentPath + " (while creating delta for " + pcDef + ")");
        }
        Collection items = pcDef.getPrismContext().getPrismDomProcessor().parseContainerItems(containingPcd, propMod.getValue().getAny());
        if (items.size() > 1) {
            throw new SchemaException("Expected presence of a single item (path " + propMod.getPath() + ") in a object modification, but found " + items.size() + " instead");
        }
        if (items.size() < 1) {
            throw new SchemaException("Expected presence of a value (path " + propMod.getPath() + ") in a object modification, but found nothing");
        }
        Item item = (Item)items.iterator().next();
        ItemDelta itemDelta = item.createDelta(parentPath.subPath(item.getName()));
        if (propMod.getModificationType() == ModificationTypeType.ADD) {
            itemDelta.addValuesToAdd((Collection)item.getValues());
        } else if (propMod.getModificationType() == ModificationTypeType.DELETE) {
            itemDelta.addValuesToDelete((Collection)item.getValues());
        } else if (propMod.getModificationType() == ModificationTypeType.REPLACE) {
            itemDelta.setValuesToReplace((Collection)item.getValues());
        }
        return itemDelta;
    }

    public static Collection<ItemDeltaType> toPropertyModificationTypes(ItemDelta delta) throws SchemaException {
        ItemDeltaType mod;
        delta.checkConsistence();
        ArrayList<ItemDeltaType> mods = new ArrayList<ItemDeltaType>();
        XPathHolder xpath = new XPathHolder(delta.getParentPath());
        Document document = DOMUtil.getDocument();
        Element xpathElement = xpath.toElement(PATH_ELEMENT_NAME, document);
        if (delta.getValuesToReplace() != null) {
            mod = new ItemDeltaType();
            mod.setPath(xpathElement);
            mod.setModificationType(ModificationTypeType.REPLACE);
            try {
                DeltaConvertor.addModValues(delta, mod, delta.getValuesToReplace(), document);
            }
            catch (SchemaException e) {
                throw new SchemaException(String.valueOf(e.getMessage()) + " while converting property " + delta.getName(), (Throwable)e);
            }
            mods.add(mod);
        }
        if (delta.getValuesToAdd() != null) {
            mod = new ItemDeltaType();
            mod.setPath(xpathElement);
            mod.setModificationType(ModificationTypeType.ADD);
            try {
                DeltaConvertor.addModValues(delta, mod, delta.getValuesToAdd(), document);
            }
            catch (SchemaException e) {
                throw new SchemaException(String.valueOf(e.getMessage()) + " while converting property " + delta.getName(), (Throwable)e);
            }
            mods.add(mod);
        }
        if (delta.getValuesToDelete() != null) {
            mod = new ItemDeltaType();
            mod.setPath(xpathElement);
            mod.setModificationType(ModificationTypeType.DELETE);
            try {
                DeltaConvertor.addModValues(delta, mod, delta.getValuesToDelete(), document);
            }
            catch (SchemaException e) {
                throw new SchemaException(String.valueOf(e.getMessage()) + " while converting property " + delta.getName(), (Throwable)e);
            }
            mods.add(mod);
        }
        return mods;
    }

    private static void addModValues(ItemDelta delta, ItemDeltaType mod, Collection<PrismPropertyValue<Object>> values, Document document) throws SchemaException {
        QName elementName = delta.getName();
        ItemDeltaType.Value modValue = new ItemDeltaType.Value();
        mod.setValue(modValue);
        for (PrismPropertyValue<Object> value : values) {
            Object realValue;
            Object xmlValue = realValue = value.getValue();
            if (XmlTypeConverter.canConvert(realValue.getClass())) {
                xmlValue = XmlTypeConverter.toXsdElement((Object)realValue, (QName)delta.getName(), (Document)document, (boolean)true);
            }
            if (!(xmlValue instanceof Element) && !(xmlValue instanceof JAXBElement)) {
                xmlValue = new JAXBElement(elementName, xmlValue.getClass(), xmlValue);
            }
            modValue.getAny().add(xmlValue);
        }
    }
}

