/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.prism;

import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.ItemDefinition;
import com.evolveum.midpoint.prism.PrismConstants;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismPropertyDefinition;
import com.evolveum.midpoint.prism.PrismPropertyValue;
import com.evolveum.midpoint.prism.PrismValue;
import com.evolveum.midpoint.prism.PropertyPath;
import com.evolveum.midpoint.prism.delta.ItemDelta;
import com.evolveum.midpoint.prism.delta.PropertyDelta;
import com.evolveum.midpoint.prism.polystring.PolyString;
import com.evolveum.midpoint.prism.polystring.PolyStringNormalizer;
import com.evolveum.midpoint.util.DebugDumpable;
import com.evolveum.midpoint.util.DebugUtil;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;

public class PrismProperty<V>
extends Item<PrismPropertyValue<V>> {
    private static final Trace LOGGER = TraceManager.getTrace(PrismProperty.class);

    public PrismProperty(QName name) {
        super(name);
    }

    protected PrismProperty(QName name, PrismPropertyDefinition definition, PrismContext prismContext) {
        super(name, definition, prismContext);
    }

    @Override
    public PrismPropertyDefinition getDefinition() {
        return (PrismPropertyDefinition)this.definition;
    }

    public void setDefinition(PrismPropertyDefinition definition) {
        this.definition = definition;
    }

    @Override
    public List<PrismPropertyValue<V>> getValues() {
        return super.getValues();
    }

    public PrismPropertyValue<V> getValue() {
        if (this.getDefinition() != null && !this.getDefinition().isDynamic() && this.getDefinition().isMultiValue()) {
            throw new IllegalStateException("Attempt to get single value from property " + this.getName() + " with multiple values");
        }
        List<PrismPropertyValue<V>> values = this.getValues();
        if (values == null || values.isEmpty()) {
            return null;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        throw new IllegalStateException("Attempt to get a single value from a multi-valued property " + this.getName());
    }

    public <T> List<PrismPropertyValue<T>> getValues(Class<T> T) {
        return this.getValues();
    }

    public Collection<V> getRealValues() {
        ArrayList<V> realValues = new ArrayList<V>(this.getValues().size());
        for (PrismPropertyValue<V> pValue : this.getValues()) {
            realValues.add(pValue.getValue());
        }
        return realValues;
    }

    public <T> Collection<T> getRealValues(Class<T> type) {
        ArrayList<V> realValues = new ArrayList<V>(this.getValues().size());
        for (PrismPropertyValue<V> pValue : this.getValues()) {
            realValues.add(pValue.getValue());
        }
        return realValues;
    }

    public V getRealValue() {
        if (this.getValue() == null) {
            return null;
        }
        return this.getValue().getValue();
    }

    public <T> T getRealValue(Class<T> type) {
        if (this.getValue() == null) {
            return null;
        }
        V value = this.getValue().getValue();
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        throw new ClassCastException("Cannot cast value of property " + this.getName() + " which is of type " + value.getClass() + " to " + type);
    }

    public <T> T[] getRealValuesArray(Class<T> type) {
        Object valuesArrary = Array.newInstance(type, this.getValues().size());
        int j = 0;
        while (j < this.getValues().size()) {
            V avalue = this.getValues().get(j).getValue();
            Array.set(valuesArrary, j, avalue);
            ++j;
        }
        return (Object[])valuesArrary;
    }

    public <T> PrismPropertyValue<T> getValue(Class<T> T) {
        if (this.getDefinition() != null && this.getDefinition().isMultiValue()) {
            throw new IllegalStateException("Attempt to get single value from property " + this.name + " with multiple values");
        }
        if (this.getValues().size() > 1) {
            throw new IllegalStateException("Attempt to get single value from property " + this.name + " with multiple values");
        }
        if (this.getValues().isEmpty()) {
            return null;
        }
        PrismPropertyValue<V> o = this.getValues().iterator().next();
        return o;
    }

    public void setValue(PrismPropertyValue<V> value) {
        this.getValues().clear();
        this.addValue(value);
    }

    public void setRealValue(Object realValue) {
        this.setValue(new PrismPropertyValue<Object>(realValue));
    }

    public void addValues(Collection<PrismPropertyValue<V>> pValuesToAdd) {
        for (PrismPropertyValue<V> pValue : pValuesToAdd) {
            this.addValue(pValue);
        }
    }

    public void addValue(PrismPropertyValue<V> pValueToAdd) {
        Iterator<PrismPropertyValue<V>> iterator = this.getValues().iterator();
        while (iterator.hasNext()) {
            PrismPropertyValue<V> pValue = iterator.next();
            if (!pValue.equalsRealValue(pValueToAdd)) continue;
            LOGGER.warn("Adding value to property " + this.getName() + " that already exists (overwriting), value: " + pValueToAdd);
            iterator.remove();
        }
        this.prepareValue(pValueToAdd);
        pValueToAdd.setParent(this);
        this.getValues().add(pValueToAdd);
    }

    private void prepareValue(PrismPropertyValue<V> value) {
        PolyStringNormalizer polyStringNormalizer;
        if (value.isRaw()) {
            return;
        }
        V realValue = value.getValue();
        if (realValue == null) {
            return;
        }
        if (realValue instanceof PolyString && this.getPrismContext() != null && (polyStringNormalizer = this.getPrismContext().getDefaultPolyStringNormalizer()) != null) {
            ((PolyString)realValue).recompute(polyStringNormalizer);
        }
    }

    public boolean deleteValues(Collection<PrismPropertyValue<V>> pValuesToDelete) {
        boolean changed = false;
        for (PrismPropertyValue<V> pValue : pValuesToDelete) {
            if (!changed) {
                changed = this.deleteValue(pValue);
                continue;
            }
            this.deleteValue(pValue);
        }
        return changed;
    }

    public boolean deleteValue(PrismPropertyValue<V> pValueToDelete) {
        Iterator<PrismPropertyValue<V>> iterator = this.getValues().iterator();
        boolean found = false;
        while (iterator.hasNext()) {
            PrismPropertyValue<V> pValue = iterator.next();
            if (!pValue.equalsRealValue(pValueToDelete)) continue;
            iterator.remove();
            pValue.setParent(null);
            found = true;
        }
        if (!found) {
            LOGGER.warn("Deleting value of property " + this.getName() + " that does not exist (skipping), value: " + pValueToDelete);
        }
        return found;
    }

    public void replaceValues(Collection<PrismPropertyValue<V>> valuesToReplace) {
        this.getValues().clear();
        this.addValues(valuesToReplace);
    }

    public boolean hasValue(PrismPropertyValue<V> value) {
        return super.hasValue(value);
    }

    public boolean hasRealValue(PrismPropertyValue<V> value) {
        for (PrismPropertyValue<V> propVal : this.getValues()) {
            if (!propVal.equalsRealValue(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public PrismPropertyValue<V> getPreviousValue(PrismValue value) {
        return (PrismPropertyValue)super.getPreviousValue(value);
    }

    @Override
    public PrismPropertyValue<V> getNextValue(PrismValue value) {
        return (PrismPropertyValue)super.getNextValue(value);
    }

    public Class<V> getValueClass() {
        V firstVal;
        PrismPropertyValue<V> firstPVal;
        if (this.getDefinition() != null) {
            return this.getDefinition().getTypeClass();
        }
        if (!this.getValues().isEmpty() && (firstPVal = this.getValues().get(0)) != null && (firstVal = firstPVal.getValue()) != null) {
            return firstVal.getClass();
        }
        return PrismConstants.DEFAULT_VALUE_CLASS;
    }

    @Override
    public PropertyDelta<V> createDelta(PropertyPath path) {
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("Attempt to create delta with null or empty path");
        }
        return new PropertyDelta(path, this.getDefinition());
    }

    public PropertyDelta<V> diff(PrismProperty<V> other, PropertyPath pathPrefix) {
        return this.diff(other, pathPrefix, true);
    }

    public PropertyDelta<V> diff(PrismProperty<V> other, PropertyPath pathPrefix, boolean ignoreMetadata) {
        ArrayList deltas = new ArrayList();
        this.diffInternal(other, pathPrefix, deltas, ignoreMetadata);
        if (deltas.isEmpty()) {
            return null;
        }
        if (deltas.size() > 1) {
            throw new IllegalStateException("Unexpected number of deltas from property diff: " + deltas);
        }
        return (PropertyDelta)deltas.get(0);
    }

    @Override
    protected void checkDefinition(ItemDefinition def) {
        if (!(def instanceof PrismPropertyDefinition)) {
            throw new IllegalArgumentException("Definition " + def + " cannot be applied to property " + this);
        }
    }

    @Override
    public PrismProperty<V> clone() {
        PrismProperty<V> clone = new PrismProperty<V>(this.getName(), this.getDefinition(), this.prismContext);
        this.copyValues(clone);
        return clone;
    }

    protected void copyValues(PrismProperty<V> clone) {
        super.copyValues(clone);
        for (PrismPropertyValue<V> value : this.getValues()) {
            clone.addValue((PrismPropertyValue<V>)value.clone());
        }
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }

    @Override
    protected ItemDelta fixupDelta(ItemDelta delta, Item otherItem, PropertyPath pathPrefix, boolean ignoreMetadata) {
        PrismPropertyDefinition def = this.getDefinition();
        if (def != null && def.isSingleValue() && !delta.isEmpty()) {
            PrismProperty other = (PrismProperty)otherItem;
            PropertyDelta propertyDelta = (PropertyDelta)delta;
            delta.clear();
            ArrayList<PrismValue> replaceValues = new ArrayList<PrismValue>(other.getValues().size());
            for (PrismPropertyValue<V> value : other.getValues()) {
                replaceValues.add(value.clone());
            }
            propertyDelta.setValuesToReplace(replaceValues);
            return propertyDelta;
        }
        return super.fixupDelta(delta, otherItem, pathPrefix, ignoreMetadata);
    }

    @Override
    public String toString() {
        return String.valueOf(this.getDebugDumpClassName()) + "(" + DebugUtil.prettyPrint((QName)this.getName()) + "):" + this.getValues();
    }

    @Override
    public String debugDump(int indent) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < indent) {
            sb.append(DebugDumpable.INDENT_STRING);
            ++i;
        }
        sb.append(this.getDebugDumpClassName()).append(": ").append(DebugUtil.prettyPrint((QName)this.getName())).append(" = ");
        if (this.getValues() == null) {
            sb.append("null");
        } else {
            sb.append("[ ");
            Iterator<PrismPropertyValue<V>> iterator = this.getValues().iterator();
            while (iterator.hasNext()) {
                PrismPropertyValue<V> value = iterator.next();
                sb.append(DebugUtil.prettyPrint(value));
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" ]");
        }
        PrismPropertyDefinition def = this.getDefinition();
        if (def != null) {
            sb.append(" def(");
            sb.append(DebugUtil.prettyPrint((QName)def.getTypeName()));
            if (def.isDynamic()) {
                sb.append(",dyn");
            }
            sb.append(")");
        }
        return sb.toString();
    }

    public String getHumanReadableDump() {
        StringBuilder sb = new StringBuilder();
        sb.append(DebugUtil.prettyPrint((QName)this.getName())).append(" = ");
        if (this.getValues() == null) {
            sb.append("null");
        } else {
            sb.append("[ ");
            Iterator<PrismPropertyValue<V>> iterator = this.getValues().iterator();
            while (iterator.hasNext()) {
                PrismPropertyValue<V> value = iterator.next();
                sb.append(value.getHumanReadableDump());
                if (!iterator.hasNext()) continue;
                sb.append(", ");
            }
            sb.append(" ]");
        }
        return sb.toString();
    }

    @Override
    protected String getDebugDumpClassName() {
        return "PP";
    }
}

