/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.item;

import java.math.BigDecimal;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.Duration;
import org.basex.query.QueryException;
import org.basex.query.item.AtomType;
import org.basex.query.item.Date;
import org.basex.query.item.Item;
import org.basex.query.item.Type;
import org.basex.query.util.Err;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public class Dur
extends Item {
    protected static final long DAYSECONDS = 86400L;
    private static final Pattern DUR = Pattern.compile("(-?)P(([0-9]+)Y)?(([0-9]+)M)?(([0-9]+)D)?(T(([0-9]+)H)?(([0-9]+)M)?(([0-9]+(\\.[0-9]+)?)?S)?)?");
    protected int mon;
    protected BigDecimal sc;

    public Dur(byte[] v, InputInfo ii) throws QueryException {
        this(v, AtomType.DUR, ii);
    }

    protected Dur(Type t) {
        super(t);
    }

    protected Dur(Dur d) {
        this(d, AtomType.DUR);
    }

    private Dur(Dur d, Type t) {
        this(t);
        this.mon = d.mon;
        this.sc = d.sc == null ? BigDecimal.valueOf(0L) : d.sc;
    }

    private Dur(byte[] v, Type t, InputInfo ii) throws QueryException {
        this(t);
        String val = Token.string(v).trim();
        Matcher mt = DUR.matcher(val);
        if (!mt.matches() || val.endsWith("P") || val.endsWith("T")) {
            this.dateErr(v, "P2000Y12MT23H12M34S", ii);
        }
        int y = mt.group(2) != null ? Token.toInt(mt.group(3)) : 0;
        int m = mt.group(4) != null ? Token.toInt(mt.group(5)) : 0;
        long d = mt.group(6) != null ? Token.toInt(mt.group(7)) : 0;
        long h = mt.group(9) != null ? Token.toInt(mt.group(10)) : 0;
        long n = mt.group(11) != null ? Token.toInt(mt.group(12)) : 0;
        double s = mt.group(13) != null ? Token.toDouble(Token.token(mt.group(14))) : 0.0;
        this.mon = y * 12 + m;
        this.sc = BigDecimal.valueOf(d * 86400L + h * 3600L + n * 60L);
        this.sc = this.sc.add(BigDecimal.valueOf(s));
        if (!mt.group(1).isEmpty()) {
            this.mon = -this.mon;
            this.sc = this.sc.negate();
        }
    }

    public final int yea() {
        return this.mon / 12;
    }

    public final int mon() {
        return this.mon % 12;
    }

    public final long day() {
        return this.sc.longValue() / 86400L;
    }

    private long tim() {
        return this.sc.longValue() % 86400L;
    }

    public final long hou() {
        return this.tim() / 3600L;
    }

    public final long min() {
        return this.tim() % 3600L / 60L;
    }

    public final BigDecimal sec() {
        return this.sc.remainder(BigDecimal.valueOf(60L));
    }

    @Override
    public byte[] atom(InputInfo ii) {
        TokenBuilder tb = new TokenBuilder();
        if (this.mon < 0 || this.sc.signum() < 0) {
            tb.add(45);
        }
        tb.add(80);
        if (this.yea() != 0) {
            tb.addLong(Math.abs(this.yea()));
            tb.add(89);
        }
        if (this.mon() != 0) {
            tb.addLong(Math.abs(this.mon()));
            tb.add(77);
        }
        if (this.day() != 0L) {
            tb.addLong(Math.abs(this.day()));
            tb.add(68);
        }
        if (this.sc.remainder(BigDecimal.valueOf(86400L)).signum() != 0) {
            tb.add(84);
            if (this.hou() != 0L) {
                tb.addLong(Math.abs(this.hou()));
                tb.add(72);
            }
            if (this.min() != 0L) {
                tb.addLong(Math.abs(this.min()));
                tb.add(77);
            }
            if (this.sec().signum() != 0) {
                tb.add(this.sc());
                tb.add(83);
            }
        }
        if (this.mon == 0 && this.sc.signum() == 0) {
            tb.add("T0S");
        }
        return tb.finish();
    }

    protected final byte[] sc() {
        return Token.chopNumber(Token.token(this.sec().abs().toPlainString()));
    }

    @Override
    public final boolean eq(InputInfo ii, Item it) throws QueryException {
        double s2;
        Dur d = (Dur)(!it.dur() ? this.type.e(it, null, ii) : it);
        double s1 = this.sc == null ? 0.0 : this.sc.doubleValue();
        double d2 = s2 = d.sc == null ? 0.0 : d.sc.doubleValue();
        return this.mon == d.mon && s1 == s2;
    }

    @Override
    public int diff(InputInfo ii, Item it) throws QueryException {
        throw Err.diff(ii, it, this);
    }

    @Override
    public final Duration toJava() {
        return Date.df.newDuration(Token.string(this.atom(null)));
    }

    @Override
    public final int hash(InputInfo ii) {
        return (int)((double)(31 * this.mon) + (this.sc == null ? 0.0 : this.sc.doubleValue()));
    }

    @Override
    public final String toString() {
        return "\"" + Token.string(this.atom(null)) + "\"";
    }
}

