/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui.view.editor;

import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.basex.core.cmd.XQuery;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXEditor;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXLabel;
import org.basex.gui.view.editor.EditorView;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryProcessor;
import org.basex.util.Performance;
import org.basex.util.Token;

final class EditorArea
extends BaseXEditor {
    final BaseXLabel label;
    final EditorView view;
    private IOFile file;
    boolean mod;
    boolean opened;
    int error = -1;
    int threadID;
    byte[] last = Token.EMPTY;
    boolean exec = true;

    EditorArea(EditorView v, IOFile f) {
        super(true, (Window)v.gui);
        this.view = v;
        this.file = f;
        this.label = new BaseXLabel(f.name());
        this.setSyntax(f);
    }

    @Override
    public void setText(byte[] t) {
        super.setText(t);
        this.last = t;
    }

    @Override
    public void keyPressed(KeyEvent e) {
        super.keyPressed(e);
        if (Character.isDefined(e.getKeyChar())) {
            this.error(-1);
        } else {
            this.view.pos.setText(this.pos());
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        this.view.pos.setText(this.pos());
    }

    @Override
    public void keyReleased(KeyEvent e) {
        super.keyReleased(e);
        if (!e.isActionKey() && !BaseXKeys.modifier(e)) {
            this.release(BaseXKeys.EXEC.is(e));
        }
    }

    @Override
    protected void release(boolean force) {
        byte[] in = this.getText();
        boolean eq = Token.eq(in, this.last);
        if (eq && !force) {
            return;
        }
        this.view.refresh(this.mod || !eq, false);
        this.view.pos.setText(this.pos());
        this.gui.context.query = this.file;
        this.last = in;
        if (this.file.xml()) {
            this.view.info("", true);
            this.exec = false;
        } else {
            String qu = in.length == 0 ? "()" : Token.string(in);
            boolean bl = this.exec = !this.module(in);
            if (this.exec && (force || this.gui.gprop.is(GUIProp.EXECRT))) {
                this.gui.execute(false, new XQuery(qu));
            } else {
                QueryContext ctx = new QueryContext(this.gui.context);
                try {
                    if (!this.exec) {
                        ctx.module(qu);
                    } else {
                        ctx.parse(qu);
                    }
                    this.view.info("", true);
                }
                catch (QueryException ex) {
                    this.view.info(ex.getMessage(), false);
                }
            }
        }
    }

    void query() {
        this.release(true);
    }

    IOFile file() {
        return this.file;
    }

    void file(IOFile f) {
        this.file = f;
        this.setSyntax(this.file);
    }

    void markError() {
        final int thread = ++this.threadID;
        final int sleep = this.error == -1 ? 0 : 500;
        new Thread(){

            @Override
            public void run() {
                Performance.sleep(sleep);
                if (thread == EditorArea.this.threadID) {
                    EditorArea.this.error(EditorArea.this.error);
                }
            }
        }.start();
    }

    private boolean module(byte[] qu) {
        return QueryProcessor.removeComments(Token.string(qu), 20).startsWith("module namespace ");
    }
}

