/*
 * Decompiled with CFR 0.152.
 */
package org.basex.gui;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.plaf.basic.BasicComboPopup;
import org.basex.core.CommandParser;
import org.basex.data.Data;
import org.basex.gui.GUI;
import org.basex.gui.GUIProp;
import org.basex.gui.layout.BaseXCombo;
import org.basex.gui.layout.BaseXKeys;
import org.basex.gui.layout.BaseXTextField;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QuerySuggest;
import org.basex.util.list.StringList;

public final class GUIInput
extends BaseXTextField {
    final GUI gui;
    final BaseXCombo box;
    ComboPopup pop;
    private String pre = "";

    GUIInput(final GUI main) {
        super(main);
        this.gui = main;
        Font f = this.getFont();
        this.setFont(f.deriveFont((float)f.getSize() + 2.0f));
        this.box = new BaseXCombo(main, new String[0]);
        this.box.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getModifiers() == 16) {
                    GUIInput.this.completeInput();
                }
            }
        });
        this.pop = new ComboPopup((JComboBox)this.box);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                int count = GUIInput.this.box.getItemCount();
                if (BaseXKeys.ENTER.is(e)) {
                    if (GUIInput.this.pop.isVisible()) {
                        GUIInput.this.completeInput();
                    } else {
                        int i;
                        String txt = GUIInput.this.getText();
                        StringList sl = new StringList();
                        sl.add(txt);
                        GUIProp gprop = GUIInput.this.gui.gprop;
                        int n = i = main.context.data == null ? 2 : gprop.num(GUIProp.SEARCHMODE);
                        String[] hs = i == 0 ? gprop.strings(GUIProp.SEARCH) : (i == 1 ? gprop.strings(GUIProp.XQUERY) : gprop.strings(GUIProp.COMMANDS));
                        int p = 0;
                        while (p < hs.length && sl.size() < 10) {
                            if (!hs[p].equals(txt)) {
                                sl.add(hs[p]);
                            }
                            ++p;
                        }
                        gprop.set(i == 0 ? GUIProp.SEARCH : (i == 1 ? GUIProp.XQUERY : GUIProp.COMMANDS), sl.toArray());
                        if (e.getModifiers() == 0) {
                            main.execute();
                        }
                    }
                    return;
                }
                if (count == 0) {
                    return;
                }
                int bi = GUIInput.this.box.getSelectedIndex();
                if (BaseXKeys.NEXTLINE.is(e)) {
                    if (!GUIInput.this.pop.isVisible()) {
                        GUIInput.this.showPopup();
                    } else if (++bi == count) {
                        bi = 0;
                    }
                } else if (BaseXKeys.PREVLINE.is(e)) {
                    if (!GUIInput.this.pop.isVisible()) {
                        GUIInput.this.showPopup();
                    } else if (--bi < 0) {
                        bi = count - 1;
                    }
                }
                if (bi != GUIInput.this.box.getSelectedIndex()) {
                    GUIInput.this.box.setSelectedIndex(bi);
                }
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (BaseXKeys.ESCAPE.is(e)) {
                    GUIInput.this.pop.setVisible(false);
                } else if (BaseXKeys.ENTER.is(e)) {
                    GUIInput.this.pop.hide();
                } else if (!BaseXKeys.NEXTLINE.is(e) && !BaseXKeys.PREVLINE.is(e)) {
                    if (BaseXKeys.modifier(e) || BaseXKeys.control(e)) {
                        return;
                    }
                    GUIInput.this.showPopup();
                    if (GUIInput.this.gui.gprop.is(GUIProp.EXECRT) && !GUIInput.this.cmdMode()) {
                        main.execute();
                    }
                }
            }
        });
    }

    @Override
    public void setText(String txt) {
        super.setText(txt);
        this.box.removeAllItems();
        this.pop.setVisible(false);
    }

    boolean cmdMode() {
        return this.gui.gprop.num(GUIProp.SEARCHMODE) == 2 || this.gui.context.data == null || this.getText().startsWith("!");
    }

    void completeInput() {
        int ll;
        Object sel = this.box.getSelectedItem();
        if (sel == null) {
            return;
        }
        String suf = sel.toString();
        int pl = this.pre.length();
        int n = ll = pl > 0 ? (int)this.pre.charAt(pl - 1) : 32;
        if (Character.isLetter(ll) && Character.isLetter(suf.charAt(0))) {
            this.pre = String.valueOf(this.pre) + " ";
        }
        this.setText(String.valueOf(this.pre) + sel);
        this.showPopup();
        if (this.gui.gprop.is(GUIProp.EXECRT) && !this.cmdMode()) {
            this.gui.execute();
        }
    }

    void showPopup() {
        String query = this.getText();
        int mode = this.gui.gprop.num(GUIProp.SEARCHMODE);
        if (this.cmdMode()) {
            this.cmdPopup(query);
        } else if (mode == 1 || mode == 0 && query.startsWith("/")) {
            this.queryPopup(query);
        } else {
            this.pop.setVisible(false);
        }
    }

    private void cmdPopup(String query) {
        StringList sl;
        block2: {
            sl = null;
            boolean excl = query.startsWith("!");
            try {
                this.pre = excl ? "!" : "";
                String suf = this.getText().substring(this.pre.length());
                new CommandParser(suf, this.gui.context).parse(true);
            }
            catch (QueryException ex) {
                sl = ex.complete();
                int marked = ex.markedCol() + (excl ? 2 : 1);
                if (ex.markedCol() <= -1 || marked > query.length()) break block2;
                this.pre = query.substring(0, marked);
            }
        }
        this.createCombo(sl);
    }

    private void queryPopup(String query) {
        Data data = this.gui.context.data;
        if (data == null || !data.meta.pathindex) {
            return;
        }
        StringList sl = null;
        try {
            QuerySuggest qs = new QuerySuggest(query, new QueryContext(this.gui.context), data);
            qs.parse(null, null);
            sl = qs.complete();
            this.pre = query.substring(0, qs.qm);
        }
        catch (QueryException ex) {
            sl = ex.complete();
            this.pre = query.substring(0, ex.col() - (ex.col() == 1 ? 1 : 0));
        }
        if (this.getCaretPosition() < this.pre.length()) {
            sl = null;
        }
        this.createCombo(sl);
    }

    private void createCombo(StringList sl) {
        if (sl == null || sl.size() == 0) {
            this.pop.setVisible(false);
            return;
        }
        if (this.comboChanged(sl)) {
            this.box.setModel(new DefaultComboBoxModel<String>(sl.toArray()));
            this.box.setSelectedIndex(-1);
            this.pop = new ComboPopup((JComboBox)this.box);
        }
        int w = this.getFontMetrics(this.getFont()).stringWidth(this.pre);
        this.pop.show(this, Math.min(this.getWidth(), w), this.getHeight());
    }

    private boolean comboChanged(StringList sl) {
        if (sl.size() != this.box.getItemCount()) {
            return true;
        }
        int is = sl.size();
        int i = 0;
        while (i < is) {
            if (!sl.get(i).equals(this.box.getItemAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static final class ComboPopup
    extends BasicComboPopup {
        ComboPopup(JComboBox combo) {
            super(combo);
            int h = combo.getMaximumRowCount();
            this.setPreferredSize(new Dimension(this.getPreferredSize().width, this.getPopupHeightForRowCount(h) + 2));
        }
    }
}

