/*
 * Decompiled with CFR 0.152.
 */
package org.basex.core.cmd;

import java.io.IOException;
import org.basex.core.Command;
import org.basex.core.CommandBuilder;
import org.basex.core.Commands;
import org.basex.core.Text;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.Open;
import org.basex.data.Data;
import org.basex.util.Table;
import org.basex.util.Util;
import org.basex.util.list.IntList;
import org.basex.util.list.TokenList;

public final class ListDB
extends Command {
    public ListDB(String path) {
        super(256, path);
    }

    @Override
    protected boolean run() throws IOException {
        String path;
        String str = this.args[0];
        int s = str.indexOf(47);
        String db = s == -1 ? str : str.substring(0, s);
        String string = path = s == -1 ? "" : str.substring(s + 1);
        if (!ListDB.validName(db, false)) {
            return this.error(Text.NAMEINVALID, db);
        }
        Table table = new Table();
        table.description = Text.INFONDOCS;
        table.header.add(Text.INFOPATH);
        table.header.add(Text.INFONODES);
        try {
            Data data = Open.open(db, this.context);
            IntList il = data.doc(path);
            int i = 0;
            int is = il.size();
            while (i < is) {
                int pre = il.get(i);
                TokenList tl = new TokenList(2);
                tl.add(data.text(pre, true));
                tl.add(data.size(pre, 0));
                table.contents.add(tl);
                ++i;
            }
            Close.close(data, this.context);
        }
        catch (IOException ex) {
            Util.debug(ex);
            String msg = ex.getMessage();
            return msg.isEmpty() ? this.error(Text.DBOPENERR, db) : this.error(msg, new Object[0]);
        }
        table.sort();
        this.out.println(table.finish());
        return true;
    }

    @Override
    public void build(CommandBuilder cb) {
        cb.init(Commands.Cmd.LIST.toString()).args();
    }
}

