/*
 * Decompiled with CFR 0.152.
 */
package org.basex.build;

import java.io.IOException;
import org.basex.build.Builder;
import org.basex.build.Parser;
import org.basex.core.Prop;
import org.basex.data.Data;
import org.basex.data.MemData;
import org.basex.io.IO;

public final class MemBuilder
extends Builder {
    private MemData data;

    public MemBuilder(String nm, Parser parse, Prop pr) {
        super(nm, parse, pr);
    }

    public static Data build(Parser parser, Prop prop) throws IOException {
        return MemBuilder.build(parser.src.name(), parser, prop);
    }

    public static MemData build(String name, Parser parser, Prop prop) throws IOException {
        return new MemBuilder(name, parser, prop).build();
    }

    @Override
    public MemData build() throws IOException {
        this.data = new MemData(this.tags, this.atts, this.ns, this.path, this.prop);
        this.meta = this.data.meta;
        this.meta.name = this.name;
        this.meta.textindex = true;
        this.meta.attrindex = true;
        this.meta.ftindex = false;
        IO file = this.parser.src;
        this.meta.original = file != null ? file.path() : "";
        this.meta.filesize = file != null ? file.length() : 0L;
        this.meta.time = file != null ? file.date() : System.currentTimeMillis();
        this.parse();
        this.data.init();
        return this.data;
    }

    @Override
    public void close() throws IOException {
        this.parser.close();
    }

    @Override
    protected void addDoc(byte[] value) {
        this.data.doc(this.meta.size, 0, value);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void addElem(int dist, int nm, int asize, int uri, boolean ne) {
        this.data.elem(dist, nm, asize, asize, uri, ne);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void addAttr(int nm, byte[] value, int dist, int uri) {
        this.data.attr(this.meta.size, dist, nm, value, uri, false);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void addText(byte[] value, int dist, byte kind) {
        this.data.text(this.meta.size, dist, value, kind);
        this.data.insert(this.meta.size);
    }

    @Override
    protected void setSize(int pre, int size) {
        this.data.size(pre, 1, size);
    }
}

