/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.navigation.paging;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.link.AbstractLink;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.IPagingLabelProvider;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigation;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigationIncrementLink;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigationLink;
import org.apache.wicket.markup.html.panel.Panel;

public class PagingNavigator
extends Panel {
    private static final long serialVersionUID = 1L;
    private PagingNavigation pagingNavigation;
    private final IPageable pageable;
    private final IPagingLabelProvider labelProvider;

    public PagingNavigator(String id, IPageable pageable) {
        this(id, pageable, null);
    }

    public PagingNavigator(String id, IPageable pageable, IPagingLabelProvider labelProvider) {
        super(id);
        this.pageable = pageable;
        this.labelProvider = labelProvider;
    }

    public final IPageable getPageable() {
        return this.pageable;
    }

    protected void onInitialize() {
        super.onInitialize();
        this.pagingNavigation = this.newNavigation("navigation", this.pageable, this.labelProvider);
        this.add(this.pagingNavigation);
        this.add(this.newPagingNavigationLink("first", this.pageable, 0).add(new TitleAppender("PagingNavigator.first")));
        this.add(this.newPagingNavigationIncrementLink("prev", this.pageable, -1).add(new TitleAppender("PagingNavigator.previous")));
        this.add(this.newPagingNavigationIncrementLink("next", this.pageable, 1).add(new TitleAppender("PagingNavigator.next")));
        this.add(this.newPagingNavigationLink("last", this.pageable, -1).add(new TitleAppender("PagingNavigator.last")));
    }

    protected AbstractLink newPagingNavigationIncrementLink(String id, IPageable pageable, int increment) {
        return new PagingNavigationIncrementLink(id, pageable, increment);
    }

    protected AbstractLink newPagingNavigationLink(String id, IPageable pageable, int pageNumber) {
        return new PagingNavigationLink(id, pageable, pageNumber);
    }

    protected PagingNavigation newNavigation(String id, IPageable pageable, IPagingLabelProvider labelProvider) {
        return new PagingNavigation(id, pageable, labelProvider);
    }

    public final PagingNavigation getPagingNavigation() {
        return this.pagingNavigation;
    }

    private final class TitleAppender
    extends Behavior {
        private static final long serialVersionUID = 1L;
        private final String resourceKey;

        public TitleAppender(String resourceKey) {
            this.resourceKey = resourceKey;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            tag.put("title", PagingNavigator.this.getString(this.resourceKey));
        }
    }
}

