/*
 * Decompiled with CFR 0.152.
 */
package com.evolveum.midpoint.model.synchronizer;

import com.evolveum.midpoint.common.valueconstruction.ObjectDeltaObject;
import com.evolveum.midpoint.common.valueconstruction.ValueConstructionFactory;
import com.evolveum.midpoint.model.synchronizer.AccountConstruction;
import com.evolveum.midpoint.model.synchronizer.Assignment;
import com.evolveum.midpoint.model.synchronizer.AssignmentPath;
import com.evolveum.midpoint.model.synchronizer.AssignmentPathSegment;
import com.evolveum.midpoint.prism.Item;
import com.evolveum.midpoint.prism.PrismContainer;
import com.evolveum.midpoint.prism.PrismContainerValue;
import com.evolveum.midpoint.prism.PrismContainerable;
import com.evolveum.midpoint.prism.PrismContext;
import com.evolveum.midpoint.prism.PrismObject;
import com.evolveum.midpoint.repo.api.RepositoryService;
import com.evolveum.midpoint.schema.processor.SimpleDelta;
import com.evolveum.midpoint.schema.result.OperationResult;
import com.evolveum.midpoint.schema.util.ObjectResolver;
import com.evolveum.midpoint.schema.util.ObjectTypeUtil;
import com.evolveum.midpoint.util.exception.ExpressionEvaluationException;
import com.evolveum.midpoint.util.exception.ObjectNotFoundException;
import com.evolveum.midpoint.util.exception.SchemaException;
import com.evolveum.midpoint.util.logging.Trace;
import com.evolveum.midpoint.util.logging.TraceManager;
import com.evolveum.midpoint.xml.ns._public.common.common_2.AssignmentType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectReferenceType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.ObjectType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.RoleType;
import com.evolveum.midpoint.xml.ns._public.common.common_2.UserType;

public class AssignmentEvaluator {
    private static final Trace LOGGER = TraceManager.getTrace(AssignmentEvaluator.class);
    private RepositoryService repository;
    private ObjectDeltaObject<UserType> userOdo;
    private ObjectResolver objectResolver;
    private PrismContext prismContext;
    private ValueConstructionFactory valueConstructionFactory;

    public RepositoryService getRepository() {
        return this.repository;
    }

    public void setRepository(RepositoryService repository) {
        this.repository = repository;
    }

    public ObjectDeltaObject<UserType> getUserOdo() {
        return this.userOdo;
    }

    public void setUserOdo(ObjectDeltaObject<UserType> userOdo) {
        this.userOdo = userOdo;
    }

    public ObjectResolver getObjectResolver() {
        return this.objectResolver;
    }

    public void setObjectResolver(ObjectResolver objectResolver) {
        this.objectResolver = objectResolver;
    }

    public PrismContext getPrismContext() {
        return this.prismContext;
    }

    public void setPrismContext(PrismContext prismContext) {
        this.prismContext = prismContext;
    }

    public ValueConstructionFactory getValueConstructionFactory() {
        return this.valueConstructionFactory;
    }

    public void setValueConstructionFactory(ValueConstructionFactory valueConstructionFactory) {
        this.valueConstructionFactory = valueConstructionFactory;
    }

    public SimpleDelta<Assignment> evaluate(SimpleDelta<AssignmentType> assignmentTypeDelta, ObjectType source, String sourceDescription, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException {
        SimpleDelta delta = new SimpleDelta();
        delta.setType(assignmentTypeDelta.getType());
        for (AssignmentType assignmentType : assignmentTypeDelta.getChange()) {
            this.assertSource(source, assignmentType);
            Assignment assignment = this.evaluate(assignmentType, source, sourceDescription, result);
            delta.getChange().add(assignment);
        }
        return delta;
    }

    public Assignment evaluate(AssignmentType assignmentType, ObjectType source, String sourceDescription, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException {
        this.assertSource(source, assignmentType);
        Assignment assignment = new Assignment();
        AssignmentPath assignmentPath = new AssignmentPath();
        AssignmentPathSegment assignmentPathSegment = new AssignmentPathSegment(assignmentType, null);
        this.evaluateAssignment(assignment, assignmentPathSegment, source, sourceDescription, assignmentPath, result);
        return assignment;
    }

    private void evaluateAssignment(Assignment assignment, AssignmentPathSegment assignmentPathSegment, ObjectType source, String sourceDescription, AssignmentPath assignmentPath, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException {
        this.assertSource(source, assignment);
        assignmentPath.add(assignmentPathSegment);
        AssignmentType assignmentType = assignmentPathSegment.getAssignmentType();
        this.checkSchema(assignmentType, sourceDescription);
        if (assignmentType.getAccountConstruction() != null) {
            this.evaluateConstruction(assignment, assignmentPathSegment, source, sourceDescription, assignmentPath, result);
        } else if (assignmentType.getTarget() != null) {
            this.evaluateTarget(assignment, assignmentPathSegment, assignmentType.getTarget(), source, sourceDescription, assignmentPath, result);
        } else if (assignmentType.getTargetRef() != null) {
            this.evaluateTargetRef(assignment, assignmentPathSegment, assignmentType.getTargetRef(), source, sourceDescription, assignmentPath, result);
        } else {
            throw new SchemaException("No target or accountConstrucion in assignment in " + ObjectTypeUtil.toShortString((ObjectType)source));
        }
        assignmentPath.remove(assignmentPathSegment);
    }

    private void evaluateConstruction(Assignment assignment, AssignmentPathSegment assignmentPathSegment, ObjectType source, String sourceDescription, AssignmentPath assignmentPath, OperationResult result) throws SchemaException, ExpressionEvaluationException, ObjectNotFoundException {
        this.assertSource(source, assignment);
        AssignmentType assignmentType = assignmentPathSegment.getAssignmentType();
        AccountConstruction accContruction = new AccountConstruction(assignmentType.getAccountConstruction(), source);
        accContruction.setAssignmentPath(assignmentPath.clone());
        accContruction.setUserOdo(this.userOdo);
        accContruction.setObjectResolver(this.objectResolver);
        accContruction.setPrismContext(this.prismContext);
        accContruction.setValueConstructionFactory(this.valueConstructionFactory);
        accContruction.evaluate(result);
        assignment.addAccountConstruction(accContruction);
    }

    private void evaluateTargetRef(Assignment assignment, AssignmentPathSegment assignmentPathSegment, ObjectReferenceType targetRef, ObjectType source, String sourceDescription, AssignmentPath assignmentPath, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException {
        this.assertSource(source, assignment);
        String oid = targetRef.getOid();
        if (oid == null) {
            throw new SchemaException("The OID is null in assignment targetRef in " + ObjectTypeUtil.toShortString((ObjectType)source));
        }
        Class clazz = null;
        if (targetRef.getType() != null) {
            clazz = this.prismContext.getSchemaRegistry().determineCompileTimeClass(targetRef.getType());
            if (clazz == null) {
                throw new SchemaException("Cannot determine type from " + targetRef.getType() + " in target reference in " + assignment + " in " + sourceDescription);
            }
        } else {
            throw new SchemaException("Missing type in target reference in " + assignment + " in " + sourceDescription);
        }
        PrismObject target = null;
        try {
            target = this.repository.getObject(clazz, oid, result);
            if (target == null) {
                throw new IllegalArgumentException("Got null target from repository, oid:" + oid + ", class:" + clazz + " (should not happen, probably a bug) in " + sourceDescription);
            }
        }
        catch (ObjectNotFoundException ex) {
            LOGGER.error(String.valueOf(ex.getMessage()) + " in assignment target reference in " + sourceDescription, (Throwable)ex);
        }
        if (target != null) {
            this.evaluateTarget(assignment, assignmentPathSegment, (ObjectType)target.asObjectable(), source, sourceDescription, assignmentPath, result);
        }
    }

    private void evaluateTarget(Assignment assignment, AssignmentPathSegment assignmentPathSegment, ObjectType target, ObjectType source, String sourceDescription, AssignmentPath assignmentPath, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException {
        this.assertSource(source, assignment);
        assignmentPathSegment.setTarget(target);
        if (!(target instanceof RoleType)) {
            throw new SchemaException("Unknown assignment target type " + ObjectTypeUtil.toShortString((ObjectType)target) + " in " + sourceDescription);
        }
        this.evaluateRole(assignment, assignmentPathSegment, (RoleType)target, source, sourceDescription, assignmentPath, result);
    }

    private void evaluateRole(Assignment assignment, AssignmentPathSegment assignmentPathSegment, RoleType role, ObjectType source, String sourceDescription, AssignmentPath assignmentPath, OperationResult result) throws SchemaException, ObjectNotFoundException, ExpressionEvaluationException {
        this.assertSource(source, assignment);
        for (AssignmentType roleAssignment : role.getAssignment()) {
            AssignmentPathSegment roleAssignmentPathSegment = new AssignmentPathSegment(roleAssignment, null);
            String subSourceDescription = role + " in " + sourceDescription;
            this.evaluateAssignment(assignment, roleAssignmentPathSegment, (ObjectType)role, subSourceDescription, assignmentPath, result);
        }
    }

    private void assertSource(ObjectType source, Assignment assignment) {
        if (source == null) {
            throw new IllegalArgumentException("Source cannot be null (while evaluating assignment " + assignment + ")");
        }
    }

    private void assertSource(ObjectType source, AssignmentType assignmentType) {
        if (source == null) {
            throw new IllegalArgumentException("Source cannot be null (while evaluating assignment " + assignmentType + ")");
        }
    }

    private void checkSchema(AssignmentType assignmentType, String sourceDescription) throws SchemaException {
        PrismContainerValue assignmentContainerValue = assignmentType.asPrismContainerValue();
        PrismContainerable assignmentContainer = assignmentContainerValue.getParent();
        if (assignmentContainer == null) {
            throw new SchemaException("The assignment " + assignmentType + " does not have a parent in " + sourceDescription);
        }
        if (assignmentContainer.getDefinition() == null) {
            throw new SchemaException("The assignment " + assignmentType + " does not have definition in " + sourceDescription);
        }
        PrismContainer extensionContainer = assignmentContainerValue.findContainer(AssignmentType.F_EXTENSION);
        if (extensionContainer != null) {
            if (extensionContainer.getDefinition() == null) {
                throw new SchemaException("Extension does not have a definition in assignment " + assignmentType + " in " + sourceDescription);
            }
            for (Item item : extensionContainer.getValue().getItems()) {
                if (item == null) {
                    throw new SchemaException("Null item in extension in assignment " + assignmentType + " in " + sourceDescription);
                }
                if (item.getDefinition() != null) continue;
                throw new SchemaException("Item " + item + " has no definition in extension in assignment " + assignmentType + " in " + sourceDescription);
            }
        }
    }
}

